/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToComplementPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class EquivalentToComplementPatternTest
extends PellintTestCase {
    private EquivalentToComplementPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new EquivalentToComplementPattern();
    }

    @Test
    public void testNone() throws OWLException {
        EquivalentToComplementPatternTest.assertTrue((boolean)this.m_Pattern.isFixable());
        OWLObjectComplementOf comp = OWL.not((OWLDescription)this.m_Cls[0]);
        OWLSubClassAxiom axiom = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)comp);
        EquivalentToComplementPatternTest.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.equivalentClasses((OWLDescription)this.m_P0AllC0, (OWLDescription)comp);
        EquivalentToComplementPatternTest.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_Cls[0], this.m_Cls[1], comp}));
        EquivalentToComplementPatternTest.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.equivalentClasses((OWLDescription)OWL.Nothing, (OWLDescription)OWL.Thing);
        EquivalentToComplementPatternTest.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testComplementOfItself() throws OWLException {
        OWLObjectComplementOf comp = OWL.not((OWLDescription)this.m_Cls[0]);
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)comp);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        EquivalentToComplementPatternTest.assertNotNull((Object)lint);
        EquivalentToComplementPatternTest.assertTrue((boolean)lint.getParticipatingClasses().contains(this.m_Cls[0]));
        LintFixer fixer = lint.getLintFixer();
        EquivalentToComplementPatternTest.assertTrue((boolean)fixer.getAxiomsToRemove().contains(axiom));
        OWLSubClassAxiom expectedAxiom = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)comp);
        EquivalentToComplementPatternTest.assertTrue((boolean)fixer.getAxiomsToAdd().contains(expectedAxiom));
        EquivalentToComplementPatternTest.assertNull((Object)lint.getSeverity());
        EquivalentToComplementPatternTest.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testComplementOfOthers() throws OWLException {
        OWLObjectComplementOf comp = OWL.not((OWLDescription)OWL.or((OWLDescription[])new OWLDescription[]{this.m_Cls[1], this.m_Cls[2]}));
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)comp);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        EquivalentToComplementPatternTest.assertNotNull((Object)lint);
        EquivalentToComplementPatternTest.assertTrue((boolean)lint.getParticipatingClasses().contains(this.m_Cls[0]));
        LintFixer fixer = lint.getLintFixer();
        EquivalentToComplementPatternTest.assertTrue((boolean)fixer.getAxiomsToRemove().contains(axiom));
        OWLSubClassAxiom expectedAxiom = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)comp);
        EquivalentToComplementPatternTest.assertTrue((boolean)fixer.getAxiomsToAdd().contains(expectedAxiom));
    }
}

