/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToTopPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntologyCreationException;

public class EquivalentToTopPatternTest
extends PellintTestCase {
    private EquivalentToTopPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new EquivalentToTopPattern();
    }

    @Test
    public void testNone() throws OWLException {
        EquivalentToTopPatternTest.assertTrue((boolean)this.m_Pattern.isFixable());
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{OWL.Nothing, this.m_Cls[2], this.m_Cls[3]}));
        EquivalentToTopPatternTest.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.subClassOf((OWLDescription)OWL.Thing, (OWLDescription)this.m_Cls[1]);
        EquivalentToTopPatternTest.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testSimple() throws OWLException {
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{OWL.Thing, this.m_Cls[0], this.m_Cls[1]}));
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        EquivalentToTopPatternTest.assertNotNull((Object)lint);
        LintFixer fixer = lint.getLintFixer();
        EquivalentToTopPatternTest.assertTrue((boolean)fixer.getAxiomsToRemove().contains(axiom));
        EquivalentToTopPatternTest.assertTrue((boolean)fixer.getAxiomsToAdd().isEmpty());
        EquivalentToTopPatternTest.assertNull((Object)lint.getSeverity());
        EquivalentToTopPatternTest.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }
}

