/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.LargeDisjunctionPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.test.PellintTestCase;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class LargeDisjunctionPatternTest
extends PellintTestCase {
    private LargeDisjunctionPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new LargeDisjunctionPattern();
    }

    @Test
    public void testNone() throws OWLException {
        this.m_Pattern.setMaxAllowed(3);
        OWLObjectUnionOf union = OWL.or((OWLDescription[])new OWLDescription[]{this.m_Cls[1], OWL.Thing, OWL.Nothing});
        OWLSubClassAxiom axiom = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)union);
        LargeDisjunctionPatternTest.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        LargeDisjunctionPatternTest.assertFalse((boolean)this.m_Pattern.isFixable());
    }

    @Test
    public void testSimple() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectUnionOf union = OWL.or((OWLDescription[])new OWLDescription[]{this.m_Cls[1], this.m_Cls[2], this.m_Cls[3]});
        OWLSubClassAxiom axiom = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)union);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        LargeDisjunctionPatternTest.assertNotNull((Object)lint);
        LargeDisjunctionPatternTest.assertSame((Object)this.m_Pattern, (Object)lint.getPattern());
        LargeDisjunctionPatternTest.assertEquals((int)1, (int)lint.getParticipatingAxioms().size());
        LargeDisjunctionPatternTest.assertNull((Object)lint.getLintFixer());
        LargeDisjunctionPatternTest.assertEquals((double)3.0, (double)lint.getSeverity().doubleValue(), (double)1.0E-6);
        LargeDisjunctionPatternTest.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testDisjointClasses() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectUnionOf union = OWL.or((OWLDescription[])new OWLDescription[]{this.m_Cls[1], this.m_Cls[2], this.m_Cls[3]});
        OWLDisjointClassesAxiom axiom = OWL.disjointClasses((OWLDescription)this.m_Cls[0], (OWLDescription)union);
        LargeDisjunctionPatternTest.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testNested1() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectUnionOf union = OWL.or((OWLDescription[])new OWLDescription[]{this.m_Cls[1], this.m_Cls[2], this.m_Cls[3]});
        OWLObjectAllRestriction all = OWL.all((OWLObjectPropertyExpression)this.m_Pro[0], (OWLDescription)union);
        OWLObjectIntersectionOf and = OWL.and((OWLDescription[])new OWLDescription[]{all, this.m_Cls[4]});
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)and, (OWLDescription)this.m_Cls[0]);
        LargeDisjunctionPatternTest.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testNested2() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectUnionOf union1 = OWL.or((OWLDescription[])new OWLDescription[]{this.m_Cls[1], this.m_Cls[2], this.m_Cls[3]});
        OWLObjectAllRestriction all = OWL.all((OWLObjectPropertyExpression)this.m_Pro[0], (OWLDescription)union1);
        OWLObjectUnionOf union2 = OWL.or((OWLDescription[])new OWLDescription[]{all, this.m_Cls[4]});
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)union2, (OWLDescription)this.m_Cls[0]);
        LargeDisjunctionPatternTest.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }
}

