/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.ontology;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.lintpattern.ontology.EquivalentAndSubclassAxiomPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.List;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class EquivalentAndSubclassAxiomPatternTest
extends PellintTestCase {
    private EquivalentAndSubclassAxiomPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new EquivalentAndSubclassAxiomPattern();
    }

    @Test
    public void testNone1() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_Cls[1]));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.m_Cls[1], (OWLDescription)this.m_Cls[2]));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.m_Cls[1], (OWLDescription)this.m_Cls[3]));
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)this.m_Pattern.isFixable());
        List lints = this.m_Pattern.match(this.m_Ontology);
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)0, (int)lints.size());
    }

    @Test
    public void testNone2() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_Cls[1]));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)OWL.Thing));
        List lints = this.m_Pattern.match(this.m_Ontology);
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)0, (int)lints.size());
    }

    @Test
    public void testNone3() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0));
        List lints = this.m_Pattern.match(this.m_Ontology);
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)0, (int)lints.size());
    }

    @Test
    public void testEquivalentWithOneDescription() throws OWLException {
        OWLObjectMinCardinalityRestriction min = OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)2, (OWLDescription)this.m_Cls[1]);
        OWLEquivalentClassesAxiom badAxiom = OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)min);
        this.addAxiom((OWLAxiom)badAxiom);
        OWLSubClassAxiom fixedAxiom = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)min);
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)OWL.Thing));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_Cls[0], this.m_Cls[3], this.m_Cls[4]})));
        List lints = this.m_Pattern.match(this.m_Ontology);
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)1, (int)lints.size());
        Lint lint = (Lint)lints.get(0);
        Set participatingClasses = lint.getParticipatingClasses();
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)1, (int)participatingClasses.size());
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)participatingClasses.contains(this.m_Cls[0]));
        LintFixer fixer = lint.getLintFixer();
        Set axiomsToRemove = fixer.getAxiomsToRemove();
        Set axiomsToAdd = fixer.getAxiomsToAdd();
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)1, (int)axiomsToRemove.size());
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)axiomsToRemove.contains(badAxiom));
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)1, (int)axiomsToAdd.size());
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom));
        EquivalentAndSubclassAxiomPatternTest.assertNull((Object)lint.getSeverity());
        EquivalentAndSubclassAxiomPatternTest.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testEquivalentWithManyDescriptions() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0SomeC1));
        OWLDescription exactly = OWL.exactly((OWLObjectProperty)this.m_Pro[1], (int)2, (OWLDescription)this.m_Cls[2]);
        OWLEquivalentClassesAxiom badAxiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_Cls[0], this.m_Cls[3], this.m_Cls[4], exactly}));
        this.addAxiom((OWLAxiom)badAxiom);
        Set restOf = CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_Cls[3], this.m_Cls[4], exactly});
        OWLEquivalentClassesAxiom fixedAxiom1 = OWL.equivalentClasses((Set)restOf);
        OWLSubClassAxiom fixedAxiom2 = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)OWL.and((Set)restOf));
        List lints = this.m_Pattern.match(this.m_Ontology);
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)1, (int)lints.size());
        LintFixer fixer = ((Lint)lints.get(0)).getLintFixer();
        Set axiomsToRemove = fixer.getAxiomsToRemove();
        Set axiomsToAdd = fixer.getAxiomsToAdd();
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)1, (int)axiomsToRemove.size());
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)axiomsToRemove.contains(badAxiom));
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)2, (int)axiomsToAdd.size());
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom1));
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom2));
    }

    @Test
    public void testOneOf() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0));
        OWLObjectOneOf oneOf = OWL.oneOf((OWLIndividual[])this.m_Ind);
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_Cls[0], this.m_Cls[1], oneOf})));
        List lints = this.m_Pattern.match(this.m_Ontology);
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)0, (int)lints.size());
    }

    @Test
    public void testOnlyEquivalences() throws OWLException {
        OWLEquivalentClassesAxiom badAxiom1 = OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0);
        OWLSubClassAxiom fixedAxiom1 = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0);
        OWLEquivalentClassesAxiom badAxiom2 = OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0SomeC1);
        OWLSubClassAxiom fixedAxiom2 = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0SomeC1);
        this.addAxiom((OWLAxiom)badAxiom1);
        this.addAxiom((OWLAxiom)badAxiom2);
        List lints = this.m_Pattern.match(this.m_Ontology);
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)1, (int)lints.size());
        Lint lint = (Lint)lints.get(0);
        Set participatingClasses = lint.getParticipatingClasses();
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)1, (int)participatingClasses.size());
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)participatingClasses.contains(this.m_Cls[0]));
        LintFixer fixer = lint.getLintFixer();
        Set axiomsToRemove = fixer.getAxiomsToRemove();
        Set axiomsToAdd = fixer.getAxiomsToAdd();
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)2, (int)axiomsToRemove.size());
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)axiomsToRemove.contains(badAxiom1));
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)axiomsToRemove.contains(badAxiom2));
        EquivalentAndSubclassAxiomPatternTest.assertEquals((int)2, (int)axiomsToAdd.size());
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom1));
        EquivalentAndSubclassAxiomPatternTest.assertTrue((boolean)axiomsToAdd.contains(fixedAxiom2));
    }
}

