/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.ontology;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.lintpattern.ontology.TooManyDifferentIndividualsPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.List;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntologyCreationException;

public class TooManyDifferentIndividualsPatternTest
extends PellintTestCase {
    private TooManyDifferentIndividualsPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new TooManyDifferentIndividualsPattern();
    }

    @Test
    public void testNone() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.differentFrom((OWLIndividual)this.m_Ind[0], (OWLIndividual)this.m_Ind[1]));
        this.addAxiom((OWLAxiom)OWL.differentFrom((OWLIndividual)this.m_Ind[2], (OWLIndividual)this.m_Ind[3]));
        this.m_Pattern.setMaxAllowed(3);
        List lints = this.m_Pattern.match(this.m_Ontology);
        TooManyDifferentIndividualsPatternTest.assertEquals((int)0, (int)lints.size());
        TooManyDifferentIndividualsPatternTest.assertFalse((boolean)this.m_Pattern.isFixable());
    }

    @Test
    public void testOne() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.differentFrom((Set)CollectionUtil.asSet((Object[])new OWLIndividual[]{this.m_Ind[0], this.m_Ind[1], this.m_Ind[2]})));
        this.m_Pattern.setMaxAllowed(3);
        List lints = this.m_Pattern.match(this.m_Ontology);
        TooManyDifferentIndividualsPatternTest.assertEquals((int)0, (int)lints.size());
        this.addAxiom((OWLAxiom)OWL.differentFrom((OWLIndividual)this.m_Ind[3], (OWLIndividual)this.m_Ind[4]));
        lints = this.m_Pattern.match(this.m_Ontology);
        TooManyDifferentIndividualsPatternTest.assertEquals((int)1, (int)lints.size());
        Lint lint = (Lint)lints.get(0);
        TooManyDifferentIndividualsPatternTest.assertNull((Object)lint.getLintFixer());
        TooManyDifferentIndividualsPatternTest.assertEquals((double)8.0, (double)lint.getSeverity().doubleValue(), (double)1.0E-6);
        TooManyDifferentIndividualsPatternTest.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }
}

