/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.model;

import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.OntologyLints;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.test.lintpattern.MockLintPattern;
import com.clarkparsia.pellint.test.model.MockLint;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.semanticweb.owl.model.OWLOntologyChangeException;

public class OntologyLintsTest
extends PellintTestCase {
    @Test
    public void testSize() {
        OntologyLints ontologyLints = new OntologyLints(this.m_Ontology);
        OntologyLintsTest.assertSame((Object)this.m_Ontology, (Object)ontologyLints.getOntology());
        OntologyLintsTest.assertTrue((boolean)ontologyLints.isEmpty());
        OntologyLintsTest.assertEquals((int)0, (int)ontologyLints.size());
        MockLint lint = new MockLint();
        MockLintPattern pattern1 = new MockLintPattern(false);
        ontologyLints.addLint((LintPattern)pattern1, (Lint)lint);
        OntologyLintsTest.assertFalse((boolean)ontologyLints.isEmpty());
        OntologyLintsTest.assertEquals((int)1, (int)ontologyLints.size());
        MockLintPattern pattern2 = new MockLintPattern(true);
        List<Lint> lints = Arrays.asList(new Lint[]{new MockLint(), new MockLint(), new MockLint()});
        ontologyLints.addLints((LintPattern)pattern2, lints);
        OntologyLintsTest.assertFalse((boolean)ontologyLints.isEmpty());
        OntologyLintsTest.assertEquals((int)(1 + lints.size()), (int)ontologyLints.size());
    }

    @Test
    public void testApplyFix() throws OWLOntologyChangeException {
        OntologyLints ontologyLints = new OntologyLints(this.m_Ontology);
        MockLint lint = new MockLint();
        MockLintPattern unfixablePattern = new MockLintPattern(false);
        ontologyLints.addLint((LintPattern)unfixablePattern, (Lint)lint);
        MockLintPattern fixablePattern = new MockLintPattern(true);
        List<Lint> lints = Arrays.asList(new Lint[]{new MockLint(), new MockLint(), new MockLint()});
        ontologyLints.addLints((LintPattern)fixablePattern, lints);
        OntologyLintsTest.assertEquals((int)lints.size(), (int)ontologyLints.applyFix(this.m_Manager));
    }
}

