/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATermAppl;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class ATermTests {
    public static ATermAppl a = PelletTestCase.term("a");
    public static ATermAppl b = PelletTestCase.term("b");
    public static ATermAppl c = PelletTestCase.term("c");
    public static ATermAppl p = PelletTestCase.term("p");
    public static ATermAppl q = PelletTestCase.term("q");
    public static ATermAppl r = PelletTestCase.term("r");

    public static Test suite() {
        return new JUnit4TestAdapter(ATermTests.class);
    }

    @org.junit.Test
    public void testNNF() {
        this.testNNF(PelletTestCase.not(PelletTestCase.some(p, c)), PelletTestCase.all(p, PelletTestCase.not(c)));
        this.testNNF(PelletTestCase.not(PelletTestCase.all(p, c)), PelletTestCase.some(p, PelletTestCase.not(c)));
        this.testNNF(PelletTestCase.not(PelletTestCase.min(p, 1, c)), PelletTestCase.max(p, 0, c));
        this.testNNF(PelletTestCase.not(PelletTestCase.max(p, 0, c)), PelletTestCase.min(p, 1, c));
        this.testNNF(PelletTestCase.not(PelletTestCase.max(p, 1, PelletTestCase.not(PelletTestCase.some(p, c)))), PelletTestCase.min(p, 2, PelletTestCase.all(p, PelletTestCase.not(c))));
    }

    private void testNNF(ATermAppl c, ATermAppl expected) {
        Assert.assertEquals((Object)expected, (Object)ATermUtils.nnf((ATermAppl)c));
    }

    @org.junit.Test
    public void testNormalize() {
        this.testNormalize(PelletTestCase.some(p, PelletTestCase.not(c)), PelletTestCase.not(PelletTestCase.all(p, c)));
        this.testNormalize(PelletTestCase.all(p, PelletTestCase.not(c)), PelletTestCase.all(p, PelletTestCase.not(c)));
        this.testNormalize(PelletTestCase.all(p, PelletTestCase.some(q, c)), PelletTestCase.all(p, PelletTestCase.not(PelletTestCase.all(q, PelletTestCase.not(c)))));
        this.testNormalize(PelletTestCase.min(p, 1, PelletTestCase.not(PelletTestCase.not(c))), PelletTestCase.min(p, 1, c));
        this.testNormalize(PelletTestCase.min(p, 1, PelletTestCase.some(p, c)), PelletTestCase.min(p, 1, PelletTestCase.not(PelletTestCase.all(p, PelletTestCase.not(c)))));
        this.testNormalize(PelletTestCase.min(p, 0, c), ATermUtils.TOP);
        this.testNormalize(PelletTestCase.min(p, 1, ATermUtils.BOTTOM), ATermUtils.BOTTOM);
        this.testNormalize(PelletTestCase.max(p, 0, c), PelletTestCase.not(PelletTestCase.min(p, 1, c)));
        this.testNormalize(PelletTestCase.max(p, 1, c), PelletTestCase.not(PelletTestCase.min(p, 2, c)));
        this.testNormalize(PelletTestCase.max(p, 1, PelletTestCase.not(PelletTestCase.some(p, PelletTestCase.not(PelletTestCase.not(c))))), PelletTestCase.not(PelletTestCase.min(p, 2, PelletTestCase.all(p, PelletTestCase.not(c)))));
        this.testNormalize(PelletTestCase.max(p, 1, ATermUtils.BOTTOM), ATermUtils.TOP);
        this.testNormalize(PelletTestCase.some(p, PelletTestCase.not(PelletTestCase.value(a))), PelletTestCase.not(PelletTestCase.all(p, PelletTestCase.value(a))));
    }

    private void testNormalize(ATermAppl c, ATermAppl expected) {
        Assert.assertEquals((Object)expected, (Object)ATermUtils.normalize((ATermAppl)c));
    }

    @org.junit.Test
    public void testFindPrimitives() {
        this.testFindPrimitives(PelletTestCase.some(p, PelletTestCase.not(c)), new ATermAppl[]{c});
        this.testFindPrimitives(PelletTestCase.and(c, b, PelletTestCase.all(p, a)), new ATermAppl[]{a, b, c});
        this.testFindPrimitives(PelletTestCase.max(p, 1, PelletTestCase.not(PelletTestCase.some(p, PelletTestCase.or(a, b)))), new ATermAppl[]{a, b});
        this.testFindPrimitives(PelletTestCase.min(p, 2, PelletTestCase.or(a, PelletTestCase.and(b, PelletTestCase.not(c)))), new ATermAppl[]{a, b, c});
        this.testFindPrimitives(PelletTestCase.and(PelletTestCase.some(p, ATermUtils.TOP), PelletTestCase.all(p, a), PelletTestCase.and(PelletTestCase.some(p, PelletTestCase.value(r)), PelletTestCase.or(PelletTestCase.self(p), PelletTestCase.max(p, 1, b)))), new ATermAppl[]{ATermUtils.TOP, a, b});
    }

    private void testFindPrimitives(ATermAppl c, ATermAppl[] expected) {
        PelletTestCase.assertIteratorValues(ATermUtils.findPrimitives((ATermAppl)c).iterator(), expected);
    }
}

