/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletTestCase
extends TestCase {
    static ATermAppl TOP = ATermUtils.TOP;
    static ATermAppl BOTTOM = ATermUtils.BOTTOM;

    public static <T> Set<T> set(T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    public static ATermAppl term(String s) {
        return ATermUtils.makeTermAppl((String)s);
    }

    public static ATermList list(ATermAppl ... args) {
        return ATermUtils.makeList((ATerm[])args);
    }

    public static ATermAppl not(ATermAppl c) {
        return ATermUtils.makeNot((ATerm)c);
    }

    public static ATermAppl all(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeAllValues((ATerm)r, (ATerm)c);
    }

    public static ATermAppl some(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeSomeValues((ATerm)r, (ATerm)c);
    }

    public static ATermAppl min(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeMin((ATerm)r, (int)n, (ATerm)c);
    }

    public static ATermAppl max(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeMax((ATerm)r, (int)n, (ATerm)c);
    }

    public static ATermAppl card(ATermAppl r, int n, ATermAppl c) {
        return PelletTestCase.and(PelletTestCase.min(r, n, c), PelletTestCase.max(r, n, c));
    }

    public static ATermAppl inv(ATermAppl r) {
        return ATermUtils.makeInv((ATermAppl)r);
    }

    public static ATermAppl literal(String value) {
        return ATermUtils.makePlainLiteral((String)value);
    }

    public static ATermAppl plainLiteral(String value, String lang) {
        return ATermUtils.makePlainLiteral((String)value, (String)lang);
    }

    public static ATermAppl typedLiteral(String value, String dt) {
        return ATermUtils.makeTypedLiteral((String)value, (String)dt);
    }

    public static ATermAppl value(ATermAppl r) {
        return ATermUtils.makeValue((ATerm)r);
    }

    public static ATermAppl and(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeAnd((ATerm)c1, (ATerm)c2);
    }

    public static ATermAppl and(ATermAppl ... c) {
        return ATermUtils.makeAnd((ATermList)ATermUtils.makeList((ATerm[])c));
    }

    public static ATermAppl or(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeOr((ATermAppl)c1, (ATermAppl)c2);
    }

    public static ATermAppl or(ATermAppl ... c) {
        return ATermUtils.makeOr((ATermList)ATermUtils.makeList((ATerm[])c));
    }

    public static ATermAppl hasValue(ATermAppl r, ATermAppl ind) {
        return ATermUtils.makeHasValue((ATerm)r, (ATerm)ind);
    }

    public static ATermAppl oneOf(ATermAppl ... terms) {
        ATermList list = ATermUtils.EMPTY_LIST;
        for (ATermAppl term : terms) {
            list = list.insert((ATerm)PelletTestCase.value(term));
        }
        return ATermUtils.makeOr((ATermList)list);
    }

    public static ATermAppl self(ATermAppl p) {
        return ATermUtils.makeSelf((ATermAppl)p);
    }

    protected static boolean isAnonValue(Object n) {
        return n instanceof Resource && ((Resource)n).isAnon() || n instanceof Statement && ((Statement)n).getSubject().isAnon() || n instanceof Statement && PelletTestCase.isAnonValue(((Statement)n).getObject());
    }

    public static void assertIteratorContains(Iterator it, Object val) {
        boolean found = false;
        while (it.hasNext() && !found) {
            Object obj = it.next();
            found = obj.equals(val);
        }
        TestCase.assertTrue((String)("Failed to find expected iterator value: " + val), (boolean)found);
    }

    public static void assertIteratorValues(Iterator it, Iterator expected) {
        ArrayList list = new ArrayList();
        while (expected.hasNext()) {
            list.add(expected.next());
        }
        PelletTestCase.assertIteratorValues(it, list.toArray());
    }

    public static void assertIteratorValues(Iterator it, Object[] expected) {
        boolean[] found = new boolean[expected.length];
        for (int i = 0; i < expected.length; ++i) {
            found[i] = false;
        }
        while (it.hasNext()) {
            Object n = it.next();
            boolean gotit = false;
            for (int i = 0; i < expected.length; ++i) {
                if (!n.equals(expected[i])) continue;
                gotit = true;
                found[i] = true;
            }
            PelletTestCase.assertTrue((String)("Found unexpected iterator value: " + n), (boolean)gotit);
        }
        ArrayList<Object> unfound = new ArrayList<Object>();
        for (int i = 0; i < expected.length; ++i) {
            if (found[i]) continue;
            unfound.add(expected[i]);
        }
        PelletTestCase.assertTrue((String)("Failed to find expected iterator values: " + unfound), (boolean)unfound.isEmpty());
    }

    public static Set<Statement> createStatements(Resource subject, Property predicate, RDFNode ... objects) {
        HashSet<Statement> set = new HashSet<Statement>();
        for (RDFNode object : objects) {
            set.add(ResourceFactory.createStatement((Resource)subject, (Property)predicate, (RDFNode)object));
        }
        return set;
    }

    public static void addStatements(Model model, Resource subject, Property predicate, RDFNode ... objects) {
        for (RDFNode object : objects) {
            model.add(subject, predicate, object);
        }
    }

    public static void assertPropertyValues(Model model, Resource subject, Property predicate, RDFNode ... objects) {
        Model values = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(values, subject, predicate, objects);
        PelletTestCase.assertPropertyValues(model, predicate, values);
    }

    public static void assertPropertyValues(Model model, final Property pred, Model inferences) {
        Filter predFilter = new Filter(){

            public boolean accept(Object o) {
                return ((Statement)o).getPredicate().equals(pred);
            }
        };
        StmtIterator i = inferences.listStatements();
        while (i.hasNext()) {
            Statement statement = i.nextStatement();
            PelletTestCase.assertEquals((Object)pred, (Object)statement.getPredicate());
            PelletTestCase.assertTrue((String)(statement + " not inferred"), (boolean)model.contains(statement));
        }
        PelletTestCase.assertIteratorValues((Iterator)model.listStatements(null, pred, (RDFNode)null), (Iterator)inferences.listStatements());
        HashSet<Resource> testedSubj = new HashSet<Resource>();
        HashSet<RDFNode> testedObj = new HashSet<RDFNode>();
        StmtIterator i2 = inferences.listStatements();
        while (i2.hasNext()) {
            Statement statement = i2.nextStatement();
            Resource subj = statement.getSubject();
            RDFNode obj = statement.getObject();
            if (testedSubj.add(subj)) {
                PelletTestCase.assertIteratorValues((Iterator)model.listStatements(subj, pred, (RDFNode)null), (Iterator)inferences.listStatements(subj, pred, (RDFNode)null));
                PelletTestCase.assertIteratorValues((Iterator)model.listStatements(subj, null, (RDFNode)null).filterKeep(predFilter), (Iterator)inferences.listStatements(subj, null, (RDFNode)null).filterKeep(predFilter));
            }
            if (!testedObj.add(obj)) continue;
            PelletTestCase.assertIteratorValues((Iterator)model.listStatements(null, pred, obj), (Iterator)inferences.listStatements(null, pred, obj));
            PelletTestCase.assertIteratorValues((Iterator)model.listStatements(null, null, obj).filterKeep(predFilter), (Iterator)inferences.listStatements(null, null, obj).filterKeep(predFilter));
        }
    }

    public static void testResultSet(ResultSet results, List ans) {
        ArrayList answers = new ArrayList(ans);
        while (results.hasNext()) {
            QuerySolution sol = results.nextSolution();
            PelletTestCase.assertNotNull((String)"QuerySolution", (Object)sol);
            HashMap<String, RDFNode> answer = new HashMap<String, RDFNode>();
            for (String var : results.getResultVars()) {
                RDFNode val = sol.get(var);
                PelletTestCase.assertNotNull((String)("Variable: " + var), (Object)val);
                answer.put(var, val);
            }
            PelletTestCase.assertTrue((String)("Unexpected binding found: " + answer), (boolean)answers.remove(answer));
        }
        PelletTestCase.assertTrue((String)("Binding not found: " + answers), (boolean)answers.isEmpty());
    }

    public static Map createBinding(Object[] keys, Object[] values) {
        PelletTestCase.assertTrue((keys.length == values.length ? 1 : 0) != 0);
        HashMap<Object, Object> answer = new HashMap<Object, Object>();
        for (int i = 0; i < keys.length; ++i) {
            answer.put(keys[i], values[i]);
        }
        return answer;
    }

    public static List createBindings(Object[] keys, Object[][] values) {
        ArrayList answers = new ArrayList();
        for (int i = 0; i < values.length; ++i) {
            HashMap<Object, Object> answer = new HashMap<Object, Object>();
            for (int j = 0; j < keys.length; ++j) {
                answer.put(keys[j], values[i][j]);
            }
            answers.add(answer);
        }
        return answers;
    }

    public static Map createMap(Object[][] values) {
        HashMap map = new HashMap();
        for (int i = 0; i < values.length; ++i) {
            HashSet<Object> set = new HashSet<Object>();
            for (int j = 1; j < values[i].length; ++j) {
                set.add(values[i][j]);
            }
            map.put(values[i][0], set);
        }
        return map;
    }

    public static void printAll(Iterator<?> i) {
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    public static void printAll(Iterator<?> i, String head) {
        System.out.print(head + ": ");
        if (i.hasNext()) {
            System.out.println();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        } else {
            System.out.println("<EMPTY>");
        }
    }

    public static void assertSatisfiable(KnowledgeBase kb, ATermAppl c) {
        PelletTestCase.assertSatisfiable(kb, c, true);
    }

    public static void assertUnsatisfiable(KnowledgeBase kb, ATermAppl c) {
        PelletTestCase.assertSatisfiable(kb, c, false);
    }

    public static void assertSatisfiable(KnowledgeBase kb, ATermAppl c, boolean isSatisfiable) {
        PelletTestCase.assertEquals((String)("Satisfiability for " + c + " failed"), (boolean)isSatisfiable, (boolean)kb.isSatisfiable(c));
    }

    public static void assertSubClass(KnowledgeBase kb, String c1, String c2) {
        PelletTestCase.assertSubClass(kb, PelletTestCase.term(c1), PelletTestCase.term(c2));
    }

    public static void assertSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2) {
        PelletTestCase.assertSubClass(kb, c1, c2, true);
    }

    public static void assertNotSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2) {
        PelletTestCase.assertSubClass(kb, c1, c2, false);
    }

    public static void assertSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2, boolean expectedSubClass) {
        boolean computedSubClass = kb.isSubClassOf(c1, c2);
        PelletTestCase.assertEquals((String)("Subclass check failed for (" + ATermUtils.toString((ATermAppl)c1) + " [= " + ATermUtils.toString((ATermAppl)c2) + ")"), (boolean)expectedSubClass, (boolean)computedSubClass);
        kb.isSatisfiable(c1);
        kb.isSatisfiable(PelletTestCase.not(c1));
        kb.isSatisfiable(c2);
        kb.isSatisfiable(PelletTestCase.not(c2));
        long satCount = kb.getABox().satisfiabilityCount;
        computedSubClass = kb.isSubClassOf(c1, c2);
        boolean cached = satCount == kb.getABox().satisfiabilityCount;
        PelletTestCase.assertEquals((String)("Subclass check (Cached: " + cached + ") failed for (" + ATermUtils.toString((ATermAppl)c1) + " [= " + ATermUtils.toString((ATermAppl)c2) + ")"), (boolean)expectedSubClass, (boolean)computedSubClass);
    }

    public static boolean[] testType(KnowledgeBase kb, String c1, String c2) {
        return PelletTestCase.testType(kb, PelletTestCase.term(c1), PelletTestCase.term(c2));
    }

    public static boolean[] testType(KnowledgeBase kb, ATermAppl ind, ATermAppl c) {
        boolean[] result = new boolean[2];
        result[0] = kb.isType(ind, c);
        kb.isSatisfiable(c);
        kb.isSatisfiable(PelletTestCase.not(c));
        long satCount = kb.getABox().satisfiabilityCount;
        result[1] = kb.isType(ind, c);
        boolean cached = satCount == kb.getABox().satisfiabilityCount;
        return result;
    }
}

