/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import com.clarkparsia.pellet.rules.builtins.NumericPromotion;
import com.clarkparsia.pellet.rules.builtins.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Before;

public class NumericPromotionTests {
    private NumericPromotion promoter;

    public static Test suite() {
        return new JUnit4TestAdapter(NumericPromotionTests.class);
    }

    private void promotionTester(NumericPromotion promoter, Number ... results) {
        promoter.accept((NumericVisitor)new EqualityAssertion(results));
    }

    @Before
    public void setUp() {
        this.promoter = new NumericPromotion();
    }

    @org.junit.Test
    public void byteAndShort() {
        byte b = 4;
        short s = 1000;
        BigInteger bb = new BigInteger("" + b);
        BigInteger bs = new BigInteger("" + s);
        this.promoter.promote(new Number[]{b, s});
        this.promotionTester(this.promoter, bb, bs);
        this.promoter.promote(new Number[]{s, b});
        this.promotionTester(this.promoter, bs, bb);
    }

    @org.junit.Test
    public void longAndBigInt() {
        long l = 40000L;
        BigInteger big = new BigInteger("99999999999999999999999999999999999");
        BigInteger bigl = new BigInteger(new Long(l).toString());
        this.promoter.promote(new Number[]{l, big});
        this.promotionTester(this.promoter, bigl, big);
        this.promoter.promote(new Number[]{big, l});
        this.promotionTester(this.promoter, big, bigl);
    }

    @org.junit.Test
    public void decimalAndDouble() {
        double pi = Math.PI;
        BigDecimal pidec = new BigDecimal(pi).multiply(new BigDecimal(pi));
        this.promoter.promote(new Number[]{pidec, pi});
        this.promotionTester(this.promoter, pidec.doubleValue(), pi);
        this.promoter.promote(new Number[]{pi, pidec});
        this.promotionTester(this.promoter, pi, pidec.doubleValue());
    }

    @org.junit.Test
    public void bigIntAndFloat() {
        BigInteger big = new BigInteger("9999999999999999999999999999999999999999999999");
        float fl = 9.876543E9f;
        float bigf = big.floatValue();
        this.promoter.promote(new Number[]{big, Float.valueOf(fl)});
        this.promotionTester(this.promoter, Float.valueOf(bigf), Float.valueOf(fl));
        this.promoter.promote(new Number[]{Float.valueOf(fl), big});
        this.promotionTester(this.promoter, Float.valueOf(fl), Float.valueOf(bigf));
    }

    private class EqualityAssertion
    implements NumericVisitor {
        private Number[] charge;

        public EqualityAssertion(Number[] charge) {
            this.charge = charge;
        }

        private void test(Number[] args) {
            Assert.assertEquals((String)"Promoted results have wrong number of arguments", (long)this.charge.length, (long)args.length);
            for (int i = 0; i < this.charge.length; ++i) {
                Assert.assertEquals((String)"Promoted results have wrong class", this.charge[i].getClass(), args[i].getClass());
                Assert.assertEquals((String)("Promoted results differ in position " + i), (Object)this.charge[i], (Object)args[i]);
            }
        }

        public void visit(BigDecimal[] args) {
            this.test(args);
        }

        public void visit(BigInteger[] args) {
            this.test(args);
        }

        public void visit(Double[] args) {
            this.test(args);
        }

        public void visit(Float[] args) {
            this.test(args);
        }
    }
}

