/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import org.junit.Assert;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

public class SWRLAbstract {
    protected static String base;

    protected void test(String test) {
        this.testJena(this.url(test + "-premise.rdf"), this.url(test + "-conclusion.rdf"));
        this.testOWLAPI(this.url(test + "-premise.rdf"), this.url(test + "-conclusion.rdf"));
    }

    private void testJena(String premiseURI, String conclusionURI) {
        OntModel premise = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        premise.read(premiseURI);
        premise.prepare();
        Model conclusion = ModelFactory.createDefaultModel();
        conclusion.read(conclusionURI);
        StmtIterator stmtIter = conclusion.listStatements();
        while (stmtIter.hasNext()) {
            Statement s = stmtIter.nextStatement();
            Assert.assertTrue((boolean)premise.contains(s));
        }
    }

    private void testOWLAPI(String premiseURI, String conclusionURI) {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        Reasoner reasoner = new Reasoner(manager);
        try {
            OWLOntology premise = manager.loadOntology(URI.create(premiseURI));
            OWLOntology conclusion = manager.loadOntology(URI.create(conclusionURI));
            reasoner.loadOntology(premise);
            Assert.assertTrue((boolean)reasoner.isEntailed(conclusion));
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }

    private String url(String filename) {
        return base + filename;
    }
}

