/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.HashSet;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.PelletTestSuite;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;

public class SWRLPerformanceTests {
    private static final String base = "file:" + PelletTestSuite.base + "swrl-test/misc/";

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"org.mindswap.pellet.test.rules.SWRLPerformanceTests"});
    }

    @Test
    public void testBasicFamily() throws OWLOntologyCreationException {
        String ns = "http://www.csc.liv.ac.uk/~luigi/ontologies/basicFamily#";
        HashSet<OWLOntology> ontologies = new HashSet<OWLOntology>();
        ontologies.add(OntologyUtils.loadOntology((String)(base + "basicFamilyReference.owl")));
        ontologies.add(OntologyUtils.loadOntology((String)(base + "basicFamilyRules.owl")));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntologies(ontologies);
        OWLObjectProperty uncle = OWL.ObjectProperty((String)(ns + "hasUncle"));
        int i = 0;
        for (OWLIndividual ind : reasoner.getIndividuals()) {
            ++i;
            System.out.println(ind.toString() + ": " + reasoner.getRelatedIndividuals(ind, (OWLObjectPropertyExpression)uncle));
        }
        reasoner.getKB().timers.print();
        for (OWLOntology ontology : ontologies) {
            OWL.manager.removeOntology(ontology.getURI());
        }
    }

    @Test
    public void testDayCare() throws OWLOntologyCreationException {
        String ns = "https://mywebspace.wisc.edu/jpthielman/web/daycareontology#";
        OWLOntology ontology = OntologyUtils.loadOntology((String)(base + "daycare.swrl.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntology(ontology);
        OWLObjectProperty exposedTo = OWL.ObjectProperty((String)(ns + "is_exposed_to"));
        int i = 0;
        for (OWLIndividual ind : reasoner.getIndividuals()) {
            ++i;
            System.out.println(ind.toString() + ": " + reasoner.getRelatedIndividuals(ind, (OWLObjectPropertyExpression)exposedTo));
        }
        reasoner.getKB().timers.print();
        OWL.manager.removeOntology(ontology.getURI());
    }

    @Test
    public void testProtegeFamily() throws Exception {
        String ns = "http://a.com/ontology#";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ontModel.read(base + "family.swrl.owl");
        ontModel.prepare();
        Property hasSibling = ontModel.getProperty(ns + "hasSibling");
        StmtIterator iter = ontModel.listStatements((Resource)null, hasSibling, (RDFNode)null);
        while (iter.hasNext()) {
            Statement statement = iter.nextStatement();
            System.out.println(statement);
        }
        ((PelletInfGraph)ontModel.getGraph()).getKB().timers.print();
        ontModel.close();
    }
}

