/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.RulesToReteTranslator;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.Collections;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.datatypes.XSDString;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class TranslatorTests
extends PelletTestCase {
    private ATermAppl a = ATermUtils.makeTermAppl((String)"a");
    private ATermAppl c = ATermUtils.makePlainLiteral((String)"c");
    private ATermAppl pd = ATermUtils.makeTermAppl((String)"pd");
    private ATermAppl pi = ATermUtils.makeTermAppl((String)"pi");
    private AtomIConstant ca = new AtomIConstant(this.a);
    private AtomDConstant cc = new AtomDConstant(this.c);
    private ATermAppl cra = this.a;
    private ATermAppl crc = ATermUtils.makeTypedLiteral((String)"c", (String)"http://www.w3.org/2001/XMLSchema#string");
    private KnowledgeBase kb;
    private RulesToReteTranslator ruleTranslator;
    private ATermAppl vrx = ATermUtils.makeVar((String)"x");
    private AtomIVariable vx = new AtomIVariable("x");
    private AtomDVariable vz = new AtomDVariable("z");

    public void setUp() {
        this.kb = new KnowledgeBase();
        this.ruleTranslator = new RulesToReteTranslator(this.kb.getABox());
    }

    public void testClassAtom() {
        ClassAtom atom = new ClassAtom(this.a, (AtomIObject)this.vx);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[]{Compiler.TYPE, this.vrx, this.cra});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom((RuleAtom)atom, DependencySet.INDEPENDENT));
    }

    public void testDataRangeAtom() {
        DataRangeAtom atom = new DataRangeAtom(XSDString.instance.getName(), (AtomDObject)this.vz);
        TranslatorTests.assertNull((Object)this.ruleTranslator.translateAtom((RuleAtom)atom, DependencySet.INDEPENDENT));
    }

    public void testDatavaluedPropertyAtom() {
        this.kb.addDatatypeProperty((ATerm)this.pd);
        DatavaluedPropertyAtom atom = new DatavaluedPropertyAtom(this.pd, (AtomIObject)this.vx, (AtomDObject)this.cc);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[]{this.pd, this.vrx, this.crc});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom((RuleAtom)atom, DependencySet.INDEPENDENT));
    }

    public void testDifferentIndividualsAtom() {
        this.kb.addIndividual(this.a);
        DifferentIndividualsAtom atom = new DifferentIndividualsAtom((AtomIObject)this.vx, (AtomIObject)this.ca);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[]{Compiler.DIFF_FROM, this.vrx, this.cra});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom((RuleAtom)atom, DependencySet.INDEPENDENT));
    }

    public void testIndividualPropertyAtom() {
        this.kb.addObjectProperty((ATerm)this.pi);
        this.kb.addIndividual(this.a);
        IndividualPropertyAtom atom = new IndividualPropertyAtom(this.pi, (AtomIObject)this.vx, (AtomIObject)this.ca);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[]{this.pi, this.vrx, this.cra});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom((RuleAtom)atom, DependencySet.INDEPENDENT));
    }

    public void testSameIndividualAtom() {
        this.kb.addIndividual(this.a);
        SameIndividualAtom atom = new SameIndividualAtom((AtomIObject)this.vx, (AtomIObject)this.ca);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[]{Compiler.SAME_AS, this.vrx, this.cra});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom((RuleAtom)atom, DependencySet.INDEPENDENT));
    }

    public void testTranslateRule() {
        this.kb.addObjectProperty((ATerm)this.pi);
        this.kb.addIndividual(this.a);
        IndividualPropertyAtom bodyAtom = new IndividualPropertyAtom(this.pi, (AtomIObject)this.vx, (AtomIObject)this.ca);
        TermTuple bodyTriple = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[]{this.pi, this.vrx, this.cra});
        SameIndividualAtom headAtom = new SameIndividualAtom((AtomIObject)this.vx, (AtomIObject)this.ca);
        TermTuple headTriple = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[]{Compiler.SAME_AS, this.vrx, this.cra});
        Rule rule = new Rule(Collections.singletonList(headAtom), Collections.singletonList(bodyAtom));
        com.clarkparsia.pellet.rules.rete.Rule reteRule = new com.clarkparsia.pellet.rules.rete.Rule(Collections.singletonList(bodyTriple), Collections.singletonList(headTriple));
        TranslatorTests.assertEquals((Object)reteRule, (Object)this.ruleTranslator.translateRule(rule));
    }
}

