/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.owl.EntityFactory;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessList;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.URIUtils;
import org.mindswap.utils.Utils;

public class CreateSequence {
    public static final URI baseURI = URI.create("http://www.example.org/BookPrice.owl#");
    OWLOntology ont;

    Service createSequenceService(List services) {
        Service service = this.ont.createService(URIUtils.createURI(baseURI, "TestService"));
        CompositeProcess process = this.ont.createCompositeProcess(URIUtils.createURI(baseURI, "TestProcess"));
        Profile profile = this.ont.createProfile(URIUtils.createURI(baseURI, "TestProfile"));
        Grounding grounding = this.ont.createGrounding(URIUtils.createURI(baseURI, "TestGrounding"));
        System.out.println(this.ont.getKB().getServices());
        service.setProfile(profile);
        service.setProcess(process);
        service.setGrounding(grounding);
        this.createSequenceProcess(process, services);
        this.createProfile(profile, process);
        ProcessList list = process.getComposedOf().getAllProcesses();
        for (int i = 0; i < list.size(); ++i) {
            AtomicGrounding ag;
            Process pc = list.processAt(i);
            if (!(pc instanceof AtomicProcess) || (ag = ((AtomicProcess)pc).getGrounding()) == null) continue;
            grounding.addGrounding(ag);
        }
        profile.setLabel(this.createLabel(services));
        profile.setTextDescription(profile.getLabel());
        service.setProfile(profile);
        service.setProcess(process);
        service.setGrounding(grounding);
        return service;
    }

    String createLabel(List services) {
        String label = "[";
        for (int i = 0; i < services.size(); ++i) {
            Service s = (Service)services.get(i);
            if (i > 0) {
                label = label + " + ";
            }
            label = label + s.getLabel();
        }
        label = label + "]";
        return label;
    }

    Profile createProfile(Profile profile, Process process) {
        int i;
        for (i = 0; i < process.getInputs().size(); ++i) {
            Input input = process.getInputs().inputAt(i);
            profile.addInput(input);
        }
        for (i = 0; i < process.getOutputs().size(); ++i) {
            Output output = process.getOutputs().outputAt(i);
            profile.addOutput(output);
        }
        return profile;
    }

    CompositeProcess createSequenceProcess(CompositeProcess compositeProcess, List services) {
        boolean createOutput;
        Input input;
        Sequence sequence = this.ont.createSequence();
        compositeProcess.setComposedOf(sequence);
        Perform[] performs = new Perform[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            Service s = (Service)services.get(i);
            Process p = s.getProcess();
            performs[i] = this.ont.createPerform();
            performs[i].setProcess(p);
            sequence.addComponent(performs[i]);
            if (i <= 0) continue;
            Perform prevPerform = performs[i - 1];
            input = p.getInputs().inputAt(0);
            Output output = prevPerform.getProcess().getOutputs().outputAt(0);
            performs[i].addBinding(input, prevPerform, output);
        }
        Perform firstPerform = performs[0];
        Perform lastPerform = performs[services.size() - 1];
        boolean createInput = firstPerform.getProcess().getInputs().size() > 0;
        boolean bl = createOutput = lastPerform.getProcess().getOutputs().size() > 0;
        if (createInput) {
            input = firstPerform.getProcess().getInputs().inputAt(0);
            Input newInput = this.ont.createInput(URIUtils.createURI(baseURI, "TestInput"));
            newInput.setLabel(input.getLabel());
            newInput.setParamType(input.getParamType());
            newInput.setProcess(compositeProcess);
            performs[0].addBinding(input, Perform.TheParentPerform, newInput);
        }
        if (createOutput) {
            Output output = lastPerform.getProcess().getOutputs().outputAt(0);
            Output newOutput = this.ont.createOutput(URIUtils.createURI(baseURI, "TestOutput"));
            newOutput.setLabel(output.toPrettyString());
            newOutput.setParamType(output.getParamType());
            newOutput.setProcess(compositeProcess);
            Result result = this.ont.createResult();
            result.addBinding(newOutput, lastPerform, output);
            compositeProcess.setResult(result);
        }
        return compositeProcess;
    }

    public void runTest() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.getReader().getCache().setLocalCacheDirectory("C:\\mindswap\\composer\\cache");
        this.ont = kb.createOntology();
        ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();
        Service s1 = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/BookFinder.owl#");
        Service s2 = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/BNPrice.owl#");
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(s1);
        services.add(s2);
        Service s = this.createSequenceService(services);
        this.ont.write(System.out, baseURI);
        System.out.println();
        Process process = s.getProcess();
        ValueMap values = new ValueMap();
        values.setValue(process.getInputs().inputAt(0), EntityFactory.createDataValue("City of Glass"));
        System.out.print("Executing...");
        values = exec.execute(process, values);
        System.out.println("done");
        OWLIndividual outValue = values.getIndividualValue(process.getOutput());
        System.out.println("Book Price = ");
        System.out.println(Utils.formatRDF(outValue.toRDF()));
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        CreateSequence test = new CreateSequence();
        test.runTest();
    }
}

