/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;

public class Matchmaker {
    OWLKnowledgeBase kb = OWLFactory.createKB();
    static /* synthetic */ Class class$org$mindswap$owls$process$Output;
    static /* synthetic */ Class class$org$mindswap$owls$process$Input;

    public Matchmaker() {
        this.kb.setReasoner("Pellet");
    }

    public void addOntology(String ont) throws FileNotFoundException, URISyntaxException {
        System.out.println("Reading " + ont);
        this.kb.read(new URI(ont));
    }

    public void addOntology(URI ont) throws FileNotFoundException {
        System.out.println("Reading " + ont);
        this.kb.read(ont);
    }

    public List findServices(boolean getProducers) {
        String hasParameter = getProducers ? "process:hasOutput" : "process:hasInput";
        String queryString = "SELECT * WHERE \t   (?process rdf:type process:Process)\t   (?process " + hasParameter + " ?param)" + "USING " + "      process FOR <http://www.daml.org/services/owl-s/1.1/Process.owl#>";
        return this.kb.query(queryString);
    }

    public List findOutputs() {
        return this.findServices(true);
    }

    public List findInputs() {
        return this.findServices(false);
    }

    public int getMatchType(OWLType outputType, OWLType inputType) {
        if (outputType.isEquivalent(inputType)) {
            return Match.EXACT;
        }
        if (outputType.isSubTypeOf(inputType)) {
            return Match.SUBSUME;
        }
        if (inputType.isSubTypeOf(outputType)) {
            return Match.RELAXED;
        }
        return Match.FAIL;
    }

    public List displayAllMatches() {
        ArrayList<Match> matches = new ArrayList<Match>();
        System.out.println("Computing matches...");
        List producers = this.findOutputs();
        List consumers = this.findInputs();
        Iterator i = producers.iterator();
        while (i.hasNext()) {
            ValueMap binding = (ValueMap)i.next();
            Output output = (Output)binding.getIndividualValue("param").castTo(class$org$mindswap$owls$process$Output == null ? Matchmaker.class$("org.mindswap.owls.process.Output") : class$org$mindswap$owls$process$Output);
            OWLType outputType = output.getParamType();
            Iterator j = consumers.iterator();
            while (j.hasNext()) {
                binding = (ValueMap)j.next();
                Input input = (Input)binding.getIndividualValue("param").castTo(class$org$mindswap$owls$process$Input == null ? Matchmaker.class$("org.mindswap.owls.process.Input") : class$org$mindswap$owls$process$Input);
                OWLType inputType = input.getParamType();
                int matchType = this.getMatchType(outputType, inputType);
                if (matchType == Match.FAIL) continue;
                matches.add(new Match(matchType, output, input));
            }
        }
        return matches;
    }

    public static void printIterator(Iterator i) {
        if (i.hasNext()) {
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        } else {
            System.out.println("<EMPTY>");
        }
        System.out.println();
    }

    public void run() throws FileNotFoundException, URISyntaxException {
        Matchmaker matchmaker = new Matchmaker();
        matchmaker.addOntology("http://www.mindswap.org/2004/owl-s/1.1/BNPrice.owl");
        matchmaker.addOntology("http://www.mindswap.org/2004/owl-s/1.1/BookFinder.owl");
        matchmaker.addOntology("http://www.mindswap.org/2004/owl-s/1.1/CurrencyConverter.owl");
        matchmaker.addOntology("http://www.mindswap.org/2004/owl-s/1.1/Dictionary.owl");
        matchmaker.addOntology("http://www.mindswap.org/2004/owl-s/1.1/ZipCodeFinder.owl");
        matchmaker.addOntology("http://www.mindswap.org/2004/owl-s/1.1/FindLatLong.owl");
        matchmaker.addOntology("http://www.mindswap.org/2004/owl-s/1.1/BabelFishTranslator.owl#");
        List matches = matchmaker.displayAllMatches();
        System.out.println();
        System.out.println("Matches:");
        Matchmaker.printIterator(matches.iterator());
    }

    public static void main(String[] args) throws FileNotFoundException, URISyntaxException {
        Matchmaker test = new Matchmaker();
        test.run();
    }

    public static class Match {
        public static String[] MATCHES = new String[]{"EXACT", "SUBSUME", "RELAXED", "FAIL"};
        public static int EXACT = 0;
        public static int SUBSUME = 1;
        public static int RELAXED = 2;
        public static int FAIL = 3;
        int matchType;
        boolean listMatch;
        Service outputService;
        Output output;
        Service inputService;
        Input input;

        public Match(int matchType, Output output, Input input) {
            this.matchType = matchType;
            this.outputService = output.getService();
            this.output = output;
            this.inputService = input.getService();
            this.input = input;
        }

        public String toString() {
            String str = "";
            str = str + MATCHES[this.matchType] + " ";
            if (this.listMatch) {
                str = str + ".LIST";
            }
            str = str + this.outputService.getLocalName() + "." + this.output.getLocalName();
            str = str + " -> ";
            str = str + this.inputService.getLocalName() + "." + this.input.getLocalName();
            return str;
        }
    }
}

