/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.net.URI;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.PreconditionException;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;

public class PreconditionCheck {
    public void run() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();
        kb.setReasoner("Pellet");
        String langOnt = "http://www.daml.org/2003/09/factbook/languages#";
        Service service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/BabelFishTranslator.owl");
        Process process = service.getProcess();
        OWLIndividual English = kb.getIndividual(URI.create(langOnt + "English"));
        OWLIndividual German = kb.getIndividual(URI.create(langOnt + "German"));
        OWLIndividual Italian = kb.getIndividual(URI.create(langOnt + "Italian"));
        ValueMap values = new ValueMap();
        exec.setPreconditionCheck(false);
        System.out.println("Precondition check disabled");
        System.out.println("---------------------------");
        try {
            values.setDataValue(process.getInput("InputString"), "ciao mondo!");
            values.setValue(process.getInput("InputLanguage"), Italian);
            values.setValue(process.getInput("OutputLanguage"), German);
            System.out.println("Trying unsupported language pair...");
            System.out.println("Precondition satisfied: " + process.getCondition().isTrue(values));
            exec.execute(process, values);
            System.out.println("Execution successecful!");
        }
        catch (PreconditionException e) {
            System.out.println("Precondition evaluation failed!");
            System.out.println(e);
        }
        catch (ExecutionException e) {
            System.out.println("Execution failed!");
            System.out.println(e);
        }
        System.out.println();
        exec.setPreconditionCheck(true);
        System.out.println("Precondition check enabled");
        System.out.println("---------------------------");
        try {
            values.setDataValue(process.getInput("InputString"), "ciao mondo!");
            values.setValue(process.getInput("InputLanguage"), Italian);
            values.setValue(process.getInput("OutputLanguage"), German);
            System.out.println("Trying unsupported language pair...");
            System.out.println("Precondition satisfied: " + process.getCondition().isTrue(values));
            exec.execute(process, values);
            System.out.println("Execution successecful!");
        }
        catch (PreconditionException e) {
            System.out.println("Precondition evaluation failed!");
            System.out.println(e);
        }
        catch (ExecutionException e) {
            System.out.println("Execution failed!");
            System.out.println(e);
        }
        System.out.println();
        try {
            values.setDataValue(process.getInput("InputString"), "ciao mondo!");
            values.setValue(process.getInput("InputLanguage"), Italian);
            values.setValue(process.getInput("OutputLanguage"), English);
            System.out.println("Trying supported language pair...");
            System.out.println("Precondition satisfied: " + process.getCondition().isTrue(values));
            exec.execute(process, values);
            System.out.println("Execution successecful!");
        }
        catch (PreconditionException e) {
            System.out.println("Precondition evaluation failed!");
            System.out.println(e);
        }
        catch (ExecutionException e) {
            System.out.println("Execution failed!");
            System.out.println(e);
        }
    }

    public static void main(String[] args) throws Exception {
        PreconditionCheck test = new PreconditionCheck();
        test.run();
    }
}

