/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.ProcessUtils;

public class PreconditionUsage {
    public void run() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        String langOnt = "http://www.daml.org/2003/09/factbook/languages#";
        Service service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/BabelFishTranslator.owl");
        Process process = service.getProcess();
        Input inLang = process.getInput("InputLanguage");
        Input outLang = process.getInput("OutputLanguage");
        OWLIndividual English = kb.getIndividual(URI.create(langOnt + "English"));
        OWLIndividual Italian = kb.getIndividual(URI.create(langOnt + "Italian"));
        OWLIndividual Russian = kb.getIndividual(URI.create(langOnt + "Russian"));
        ValueMap values = new ValueMap();
        System.out.println("Find all possible languages that can be used");
        System.out.println("------------------------------------------------");
        PreconditionUsage.printAllowedValues(process, values);
        System.out.println("Find languages that English can be translated to");
        System.out.println("------------------------------------------------");
        values.setValue(inLang, English);
        PreconditionUsage.printAllowedValues(process, values);
        System.out.println("Find languages that Italian can be translated to");
        System.out.println("------------------------------------------------");
        values.clear();
        values.setValue(inLang, Italian);
        PreconditionUsage.printAllowedValues(process, values);
        System.out.println("Find languages that can be translated from Russian");
        System.out.println("--------------------------------------------------");
        values.clear();
        values.setValue(outLang, Russian);
        PreconditionUsage.printAllowedValues(process, values);
    }

    public static void printAllowedValues(Process process, ValueMap values) {
        System.out.println("Given Binding:");
        if (values.isEmpty()) {
            System.out.println("   <NONE>");
        } else {
            Iterator i = values.getVariables().iterator();
            while (i.hasNext()) {
                Input input = (Input)i.next();
                OWLIndividual value = values.getIndividualValue(input);
                System.out.println("   " + input.getLocalName() + " = " + value.getLocalName());
            }
        }
        System.out.println("Allowed values:");
        Map allowedValues = ProcessUtils.getAllowedValues(process, values);
        Iterator i = allowedValues.keySet().iterator();
        while (i.hasNext()) {
            Input input = (Input)i.next();
            Set set = (Set)allowedValues.get(input);
            System.out.print("   " + input.getLocalName() + " = [");
            Iterator j = set.iterator();
            while (j.hasNext()) {
                OWLIndividual value = (OWLIndividual)j.next();
                System.out.print(value.getLocalName());
                if (!j.hasNext()) continue;
                System.out.print(", ");
            }
            System.out.println("]");
        }
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        PreconditionUsage test = new PreconditionUsage();
        test.run();
    }
}

