/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.net.URI;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.execution.DefaultProcessMonitor;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLService;

public class RunService {
    Service service;
    Profile profile;
    Process process;
    WSDLService s;
    WSDLOperation op;
    String inValue;
    String outValue;
    ValueMap values;
    ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();

    public RunService() {
        this.exec.addMonitor(new DefaultProcessMonitor());
    }

    public void runZipCode() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        this.service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/ZipCodeFinder.owl");
        this.process = this.service.getProcess();
        this.values = new ValueMap();
        this.values.setDataValue(this.process.getInput("City"), "College Park");
        this.values.setDataValue(this.process.getInput("State"), "MD");
        this.values = this.exec.execute(this.process, this.values);
        OWLIndividual out = this.values.getIndividualValue(this.process.getOutput());
    }

    public void runJGroundingTest() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        this.service = kb.readService("http://www.ifi.unizh.ch/ddis/ont/owl-s/JGroundingTest.owl");
        this.process = this.service.getProcess();
        this.values = new ValueMap();
        this.values.setDataValue(this.process.getInput("FirstParam"), "2");
        this.values.setDataValue(this.process.getInput("SecParam"), "3");
        this.values = this.exec.execute(this.process, this.values);
    }

    public void runBookFinder() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        this.service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/BookFinder.owl");
        this.process = this.service.getProcess();
        this.values = new ValueMap();
        this.inValue = "City of Glass";
        this.values.setDataValue(this.process.getInput("BookName"), this.inValue);
        this.values = this.exec.execute(this.process, this.values);
        OWLIndividual out = this.values.getIndividualValue(this.process.getOutput());
    }

    public void runBookPrice() throws Exception {
        String currencyOnt = "http://www.daml.ecs.soton.ac.uk/ont/currency.owl#";
        OWLKnowledgeBase kb = OWLFactory.createKB();
        this.service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/BookPrice.owl");
        this.process = this.service.getProcess();
        this.values = new ValueMap();
        this.inValue = "City of Glass";
        this.values.setDataValue(this.process.getInput("BookName"), this.inValue);
        this.values.setValue(this.process.getInput("Currency"), kb.getIndividual(URI.create(currencyOnt + "EUR")));
        this.values = this.exec.execute(this.process, this.values);
        OWLIndividual out = this.values.getIndividualValue(this.process.getOutput());
    }

    public void runFindCheaperBook() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        this.exec.setPreconditionCheck(true);
        this.service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/FindCheaperBook.owl");
        this.process = this.service.getProcess();
        this.values = new ValueMap();
        this.values.setDataValue(this.process.getInput("BookName"), "City of Glass");
        this.values = this.exec.execute(this.process, this.values);
        OWLIndividual price = this.values.getIndividualValue(this.process.getOutput("BookPrice"));
        String bookstore = this.values.getStringValue(this.process.getOutput("Bookstore"));
    }

    public void runCurrencyConverter() throws Exception {
        String currencyOnt = "http://www.daml.ecs.soton.ac.uk/ont/currency.owl#";
        String conceptsOnt = "http://www.mindswap.org/2004/owl-s/concepts.owl#";
        OWLKnowledgeBase kb = OWLFactory.createKB();
        this.service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/CurrencyConverter.owl");
        this.process = this.service.getProcess();
        this.values = new ValueMap();
        OWLIndividual EUR = kb.getIndividual(URI.create(currencyOnt + "EUR"));
        this.values.setValue(this.process.getInput("OutputCurrency"), EUR);
        OWLIndividual USD = kb.getIndividual(URI.create(currencyOnt + "USD"));
        OWLClass Price = kb.getClass(URI.create(conceptsOnt + "Price"));
        OWLObjectProperty currency = kb.getObjectProperty(URI.create(conceptsOnt + "currency"));
        OWLDataProperty amount = kb.getDataProperty(URI.create(conceptsOnt + "amount"));
        OWLIndividual inputPrice = kb.createInstance(Price);
        inputPrice.addProperty(currency, USD);
        inputPrice.addProperty(amount, "100");
        this.values.setValue(this.process.getInput("InputPrice"), inputPrice);
        this.values = this.exec.execute(this.process, this.values);
        OWLIndividual out = this.values.getIndividualValue(this.process.getOutput());
    }

    public void runFrenchDictionary() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        this.service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/FrenchDictionary.owl");
        this.process = this.service.getProcess();
        this.values = new ValueMap();
        this.inValue = "mere";
        this.values.setDataValue(this.process.getInput("InputString"), this.inValue);
        this.values = this.exec.execute(this.process, this.values);
        this.outValue = this.values.getValue(this.process.getOutputs().getParameter("OutputString")).toString();
    }

    public void runTranslator() throws Exception {
        String langOnt = "http://www.daml.org/2003/09/factbook/languages#";
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("RDFS");
        this.service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/BabelFishTranslator.owl");
        this.process = this.service.getProcess();
        OWLIndividual English = kb.getIndividual(URI.create(langOnt + "English"));
        OWLIndividual French = kb.getIndividual(URI.create(langOnt + "French"));
        this.values = new ValueMap();
        this.values.setDataValue(this.process.getInput("InputString"), "Hello world!");
        this.values.setValue(this.process.getInput("InputLanguage"), English);
        this.values.setValue(this.process.getInput("OutputLanguage"), French);
        this.values = this.exec.execute(this.process, this.values);
        this.outValue = this.values.getValue(this.process.getOutput()).toString();
    }

    public void runDictionary() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        this.service = kb.readService("http://www.mindswap.org/2004/owl-s/1.1/Dictionary.owl");
        this.process = this.service.getProcess();
        this.values = new ValueMap();
        this.inValue = "hello";
        this.values.setDataValue(this.process.getInput("InputString"), this.inValue);
        this.values = this.exec.execute(this.process, this.values);
        OWLDataValue out = (OWLDataValue)this.values.getValue(this.process.getOutput());
    }

    public void runAll() throws Exception {
        try {
            this.runCurrencyConverter();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runZipCode();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runTranslator();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runJGroundingTest();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runDictionary();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runBookFinder();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runFrenchDictionary();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runBookPrice();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runFindCheaperBook();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        RunService test = new RunService();
        test.runAll();
    }
}

