/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import impl.jena.OWLConverters;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLReaderImpl;
import impl.jena.OWLWriterImpl;
import impl.jena.RDQLParser;
import impl.owl.OWLDataValueListImpl;
import impl.owl.OWLIndividualListImpl;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mx.com.hp.hpl.jena.reasoner.ReasonerRegistry;
import org.mindswap.owl.OWLDataValueList;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.OWLWriter;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.query.ABoxQueryParser;

public class JenaOWLFactory
implements OWLFactory.Interface {
    private Map reasoners = new HashMap();
    private OWLKnowledgeBase kb;

    public JenaOWLFactory() {
        this.reasoners.put("RDFS", ReasonerRegistry.getRDFSReasoner());
        this.reasoners.put("RDFS-Simple", ReasonerRegistry.getRDFSSimpleReasoner());
        this.reasoners.put("Transitive", ReasonerRegistry.getTransitiveReasoner());
        this.reasoners.put("OWL", ReasonerRegistry.getOWLReasoner());
        this.reasoners.put("OWL-Mini", ReasonerRegistry.getOWLMiniReasoner());
        this.reasoners.put("OWL-Micro", ReasonerRegistry.getOWLMicroReasoner());
        this.reasoners.put("DIG", ReasonerRegistry.getDIGReasoner());
        this.reasoners.put("Pellet", new PelletReasoner());
    }

    public Map getReasoners() {
        return Collections.unmodifiableMap(this.reasoners);
    }

    public Object getReasoner(String reasonerName) {
        return this.reasoners.get(reasonerName);
    }

    public OWLReader createReader() {
        return new OWLReaderImpl();
    }

    public OWLWriter createWriter() {
        return new OWLWriterImpl();
    }

    private OWLKnowledgeBase getKB() {
        if (this.kb == null) {
            this.kb = this.createKB();
            this.kb.setAutoTranslate(false);
        }
        return this.kb;
    }

    public OWLOntology createOntology() {
        return this.getKB().createOntology();
    }

    public OWLOntology createOntology(URI uri) {
        return this.getKB().createOntology(uri);
    }

    public OWLKnowledgeBase createKB() {
        return new OWLKnowledgeBaseImpl();
    }

    public OWLDataValueList createDataValueList() {
        return new OWLDataValueListImpl();
    }

    public OWLIndividualList createIndividualList() {
        return new OWLIndividualListImpl();
    }

    public ABoxQueryParser createRDQLParser(OWLModel model) {
        return new RDQLParser(model);
    }

    public Map getDefaultConverters() {
        return OWLConverters.getConverters();
    }
}

