/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import impl.jena.OWLModelImpl;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import org.mindswap.exceptions.CastingException;
import org.mindswap.exceptions.ConversionException;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLType;

public class OWLConverters {
    static /* synthetic */ Class class$mx$com$hp$hpl$jena$rdf$model$Property;

    public static Map getConverters() {
        HashMap<Class, OWLObjectConverter> converters = new HashMap<Class, OWLObjectConverter>();
        ObjectPropertyConverter objPropConverter = new ObjectPropertyConverter();
        DataPropertyConverter dataPropConverter = new DataPropertyConverter();
        CombinedOWLConverter propConverter = new CombinedOWLConverter(OWLProperty.class, new OWLObjectConverter[]{objPropConverter, dataPropConverter});
        ClassConverter classConverter = new ClassConverter();
        DataTypeConverter dataTypeConverter = new DataTypeConverter();
        CombinedOWLConverter typeConverter = new CombinedOWLConverter(OWLType.class, new OWLObjectConverter[]{classConverter, dataTypeConverter});
        IndividualConverter indConverter = new IndividualConverter();
        CombinedOWLConverter entityConverter = new CombinedOWLConverter(OWLType.class, new OWLObjectConverter[]{classConverter, dataTypeConverter, objPropConverter, dataPropConverter, indConverter});
        converters.put(OWLIndividual.class, indConverter);
        converters.put(OWLObjectProperty.class, objPropConverter);
        converters.put(OWLDataProperty.class, dataPropConverter);
        converters.put(OWLProperty.class, propConverter);
        converters.put(OWLClass.class, classConverter);
        converters.put(OWLDataType.class, dataTypeConverter);
        converters.put(OWLType.class, typeConverter);
        converters.put(OWLEntity.class, entityConverter);
        return converters;
    }

    public static class DataTypeConverter
    implements OWLObjectConverter {
        public boolean canCast(OWLObject object) {
            if (object instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)object;
                URI uri = entity.getURI();
                return entity.getKB().getDataType(uri) != null;
            }
            return false;
        }

        public OWLObject cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to ObjectProperty");
            }
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            return entity.getKB().getDataType(uri);
        }

        public OWLObject convert(OWLObject object) {
            if (this.canCast(object)) {
                this.cast(object);
            }
            throw new NotImplementedException();
        }
    }

    public static class IndividualConverter
    implements OWLObjectConverter {
        public boolean canCast(OWLObject object) {
            return object instanceof OWLEntity;
        }

        public OWLObject cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to OWLIndividual");
            }
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            OWLIndividual ind = entity.getKB().getIndividual(uri);
            if (ind == null) {
                ind = entity.getKB().createIndividual(uri);
            }
            return ind;
        }

        public OWLObject convert(OWLObject object) {
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            return entity.getOntology().createObjectProperty(uri);
        }
    }

    public static class ClassConverter
    implements OWLObjectConverter {
        public boolean canCast(OWLObject object) {
            if (object instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)object;
                Resource res = (Resource)entity.getImplementation();
                return ((OWLModelImpl)((Object)entity.getKB())).getClass(res) != null || !OWLConfig.getStrictConversion();
            }
            return false;
        }

        public OWLObject cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to OWLClass");
            }
            OWLEntity entity = (OWLEntity)object;
            Resource res = (Resource)entity.getImplementation();
            return ((OWLModelImpl)((Object)entity.getKB())).wrapClass(res, null);
        }

        public OWLObject convert(OWLObject object) {
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            return entity.getOntology().createClass(uri);
        }
    }

    public static class DataPropertyConverter
    implements OWLObjectConverter {
        public boolean canCast(OWLObject object) {
            if (object instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)object;
                URI uri = entity.getURI();
                return entity.getKB().getDataProperty(uri) != null || !OWLConfig.getStrictConversion();
            }
            return false;
        }

        public OWLObject cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to DatatypeProperty");
            }
            OWLEntity entity = (OWLEntity)object;
            Resource res = (Resource)entity.getImplementation();
            Property prop = (Property)res.as(class$mx$com$hp$hpl$jena$rdf$model$Property == null ? (class$mx$com$hp$hpl$jena$rdf$model$Property = OWLConverters.class$("mx.com.hp.hpl.jena.rdf.model.Property")) : class$mx$com$hp$hpl$jena$rdf$model$Property);
            return ((OWLModelImpl)((Object)entity.getKB())).wrapDataProperty(prop, null);
        }

        public OWLObject convert(OWLObject object) {
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            return entity.getOntology().createDataProperty(uri);
        }
    }

    public static class ObjectPropertyConverter
    implements OWLObjectConverter {
        public boolean canCast(OWLObject object) {
            if (object instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)object;
                URI uri = entity.getURI();
                return entity.getKB().getObjectProperty(uri) != null || !OWLConfig.getStrictConversion();
            }
            return false;
        }

        public OWLObject cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to ObjectProperty");
            }
            OWLEntity entity = (OWLEntity)object;
            Resource res = (Resource)entity.getImplementation();
            Property prop = (Property)res.as(class$mx$com$hp$hpl$jena$rdf$model$Property == null ? (class$mx$com$hp$hpl$jena$rdf$model$Property = OWLConverters.class$("mx.com.hp.hpl.jena.rdf.model.Property")) : class$mx$com$hp$hpl$jena$rdf$model$Property);
            return ((OWLModelImpl)((Object)entity.getKB())).wrapObjectProperty(prop, null);
        }

        public OWLObject convert(OWLObject object) {
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            return entity.getOntology().createObjectProperty(uri);
        }
    }

    public static class CombinedOWLConverter
    implements OWLObjectConverter {
        OWLObjectConverter[] converters;
        Class javaClass;

        public CombinedOWLConverter(Class javaClass, OWLObjectConverter[] converters) {
            this.converters = converters;
            this.javaClass = javaClass;
        }

        public boolean canCast(OWLObject object) {
            boolean strict = OWLConfig.setStrictConversion(true);
            for (int i = 0; i < this.converters.length; ++i) {
                if (!this.converters[i].canCast(object)) continue;
                OWLConfig.setStrictConversion(strict);
                return true;
            }
            OWLConfig.setStrictConversion(strict);
            return false;
        }

        public OWLObject cast(OWLObject object) {
            boolean strict = OWLConfig.setStrictConversion(true);
            for (int i = 0; i < this.converters.length; ++i) {
                if (!this.converters[i].canCast(object)) continue;
                OWLConfig.setStrictConversion(strict);
                return this.converters[i].cast(object);
            }
            OWLConfig.setStrictConversion(strict);
            throw new CastingException("OWLObject " + object + " cannot be cast to " + this.javaClass);
        }

        public OWLObject convert(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("Cannot convert " + object + " to abstract class " + this.javaClass);
            }
            return this.cast(object);
        }
    }
}

