/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import impl.jena.OWLDataValueImpl;
import impl.owl.OWLObjectImpl;
import java.net.URI;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.ResourceFactory;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLDataValueList;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.vocabulary.RDFS;
import org.mindswap.utils.URIUtils;

public abstract class OWLEntityImpl
extends OWLObjectImpl
implements OWLEntity {
    protected Resource resource;
    protected OWLKnowledgeBase kb;
    protected OWLOntology ontology;

    public OWLEntityImpl(OWLOntology ontology, Resource resource) {
        this.resource = resource;
        this.ontology = ontology;
        this.kb = ontology.getKB();
    }

    public OWLKnowledgeBase getKB() {
        return this.kb;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public boolean isAnon() {
        return this.resource.isAnon();
    }

    public URI getURI() {
        if (this.isAnon()) {
            return null;
        }
        return URI.create(this.resource.getURI());
    }

    public String getLocalName() {
        if (this.isAnon()) {
            return null;
        }
        return URIUtils.getLocalName(this.resource.getURI());
    }

    public String getQName() {
        if (this.isAnon()) {
            return null;
        }
        return this.kb.getQNames().shortForm(this.resource.getURI());
    }

    public String getLabel() {
        OWLDataValue value = this.getAnnotation(RDFS.label);
        return value == null ? null : value.getLexicalValue();
    }

    public String getLabel(String lang) {
        OWLDataValue value = this.getAnnotation(RDFS.label, lang);
        return value == null ? null : value.getLexicalValue();
    }

    public OWLDataValueList getLabels() {
        return this.getAnnotations(RDFS.label);
    }

    public void setLabel(String label) {
        this.setAnnotation(RDFS.label, label);
    }

    public void setLabel(String label, String lang) {
        this.setAnnotation(RDFS.label, label, lang);
    }

    public OWLDataValue getAnnotation(URI propURI) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        return this.getDataValue(prop);
    }

    public OWLDataValueList getAnnotations(URI propURI) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        return this.getDataValues(prop);
    }

    public OWLDataValue getAnnotation(URI propURI, String lang) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        return this.getDataValue(prop, lang);
    }

    public void addAnnotation(URI propURI, OWLDataValue value) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.resource.addProperty(prop, (RDFNode)((Literal)value.getImplementation()));
    }

    public void addAnnotation(URI propURI, String value) {
        this.addAnnotation(propURI, value, "");
    }

    public void addAnnotation(URI propURI, String value, String lang) {
        this.addAnnotation(propURI, this.kb.createDataValue(value, lang));
    }

    public void setAnnotation(URI propURI, OWLDataValue value) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.removeDataValues(prop, value.getLanguage());
        this.resource.addProperty(prop, (RDFNode)((Literal)value.getImplementation()));
    }

    public void setAnnotation(URI propURI, String value) {
        this.setAnnotation(propURI, value, "");
    }

    public void setAnnotation(URI propURI, String value, String lang) {
        this.setAnnotation(propURI, this.kb.createDataValue(value, lang));
    }

    protected OWLDataValueList getDataValues(Property prop) {
        OWLDataValueList list = OWLFactory.createDataValueList();
        StmtIterator i = this.resource.listProperties(prop);
        while (i.hasNext()) {
            RDFNode node = i.nextStatement().getObject();
            if (!(node instanceof Literal)) continue;
            Literal literal = (Literal)node;
            list.add(new OWLDataValueImpl(literal));
        }
        return list;
    }

    protected OWLDataValue getDataValue(Property prop) {
        OWLDataValue value = null;
        for (int i = 0; value == null && i < OWLConfig.DEFAULT_LANGS.length; ++i) {
            value = this.getDataValue(prop, OWLConfig.DEFAULT_LANGS[i]);
        }
        return value;
    }

    protected OWLDataValue getDataValue(Property prop, String lang) {
        StmtIterator i = this.resource.listProperties(prop);
        while (i.hasNext()) {
            RDFNode node = i.nextStatement().getObject();
            if (!(node instanceof Literal)) continue;
            Literal literal = (Literal)node;
            if (lang == null) {
                return new OWLDataValueImpl(literal);
            }
            if (!lang.equals(literal.getLanguage())) continue;
            return new OWLDataValueImpl(literal);
        }
        return null;
    }

    protected void removeDataValues(Property prop, String lang) {
        StmtIterator i = this.resource.listProperties(prop);
        while (i.hasNext()) {
            RDFNode node = i.nextStatement().getObject();
            if (!(node instanceof Literal)) continue;
            Literal literal = (Literal)node;
            if (lang == null) {
                i.remove();
                continue;
            }
            if (!lang.equals(literal.getLanguage())) continue;
            i.remove();
        }
    }

    public String toString() {
        URI uri = this.getURI();
        return uri == null ? "Anonymous (" + this.getAnonID() + ")" : uri.toString();
    }

    public String toPrettyString() {
        String value = this.getLabel();
        if (value == null) {
            URI uri = this.getURI();
            value = uri == null ? "Anonymous (" + this.getAnonID() + ")" : (this.kb == null ? uri.toString() : this.kb.getQNames().shortForm(uri));
        }
        return value;
    }

    public String debugString() {
        return this.toString();
    }

    public void removeAnnotations(URI propURI) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.resource.removeAll(prop);
    }

    public Object getImplementation() {
        return this.resource;
    }

    public Object getAnonID() {
        return this.resource.getId();
    }
}

