/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import impl.jena.OWLEntityImpl;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLDataValueList;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.OWLWriter;
import org.mindswap.owls.OWLSOntology;
import org.mindswap.utils.RDFUtils;

public class OWLIndividualImpl
extends OWLEntityImpl
implements OWLIndividual {
    public OWLIndividualImpl(OWLOntology ontology, Resource resource) {
        super(ontology, resource);
    }

    public OWLEntity inOntology(OWLOntology ont) {
        if (this.ontology.equals(ont)) {
            return this;
        }
        return new OWLIndividualImpl(this.ontology, this.resource);
    }

    public boolean hasProperty(OWLProperty prop) {
        return this.kb.hasProperty(this, prop);
    }

    public OWLIndividual getProperty(OWLObjectProperty prop) {
        return this.kb.getProperty((OWLIndividual)this, prop);
    }

    public OWLIndividualList getProperties(OWLObjectProperty prop) {
        return this.kb.getProperties((OWLIndividual)this, prop);
    }

    public Map getProperties() {
        return this.kb.getProperties(this);
    }

    public OWLDataValue getProperty(OWLDataProperty prop) {
        return this.kb.getProperty((OWLIndividual)this, prop);
    }

    public OWLDataValue getProperty(OWLDataProperty prop, String lang) {
        return this.kb.getProperty(this, prop, lang);
    }

    public OWLDataValueList getProperties(OWLDataProperty prop) {
        return this.kb.getProperties((OWLIndividual)this, prop);
    }

    public OWLIndividual getIncomingProperty(OWLObjectProperty prop) {
        return this.kb.getIncomingProperty(prop, this);
    }

    public OWLIndividualList getIncomingProperties(OWLObjectProperty prop) {
        return this.kb.getIncomingProperties(prop, this);
    }

    public OWLIndividualList getIncomingProperties() {
        return this.kb.getIncomingProperties(this);
    }

    public void setProperty(OWLDataProperty prop, String value) {
        this.ontology.setProperty((OWLIndividual)this, prop, value);
    }

    public void setProperty(OWLDataProperty prop, Object value) {
        this.ontology.setProperty((OWLIndividual)this, prop, value);
    }

    public void setProperty(OWLDataProperty prop, OWLDataValue value) {
        this.ontology.setProperty((OWLIndividual)this, prop, value);
    }

    public void addProperty(OWLDataProperty prop, OWLDataValue value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    public void addProperty(OWLDataProperty prop, String value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    public void addProperty(OWLDataProperty prop, Object value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    public void removeProperties(OWLProperty prop) {
        this.ontology.removeProperties(this, prop);
    }

    public void removeProperty(OWLProperty theProp, OWLValue theValue) {
        this.ontology.removeProperty(this, theProp, theValue);
    }

    public void addProperty(OWLObjectProperty prop, OWLIndividual value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    public void setProperty(OWLObjectProperty prop, OWLIndividual value) {
        this.ontology.setProperty((OWLIndividual)this, prop, value);
    }

    public Set getTypes() {
        return this.kb.getTypes(this);
    }

    public boolean hasProperty(OWLProperty prop, OWLValue value) {
        return this.kb.hasProperty(this, prop, value);
    }

    public OWLClass getType() {
        return this.kb.getType(this);
    }

    public boolean isType(OWLClass c) {
        return this.kb.isType(this, c);
    }

    public boolean isDataValue() {
        return false;
    }

    public boolean isIndividual() {
        return true;
    }

    public void addType(OWLClass c) {
        this.ontology.addType(this, c);
    }

    public void removeTypes() {
        this.ontology.removeTypes(this);
    }

    public String toRDF() {
        return this.toRDF(true, true);
    }

    public String toRDF(boolean printRDFTag) {
        return this.toRDF(printRDFTag, false);
    }

    public String toRDF(boolean printRDFTag, boolean keepNamespaces) {
        OWLOntology ont = OWLFactory.createOntology();
        this.getBnodeClosure(this, ont);
        StringWriter sw = new StringWriter();
        OWLWriter writer = ont.getWriter();
        boolean show = writer.isShowXmlDeclaration();
        writer.setShowXmlDeclaration(false);
        ont.write(sw);
        writer.setShowXmlDeclaration(show);
        String rdf = sw.toString();
        if (printRDFTag) {
            return rdf;
        }
        return RDFUtils.removeRDFTag(rdf, keepNamespaces);
    }

    private void getBnodeClosure(OWLIndividual ind, OWLOntology ont) {
        OWLClass c = ind.getOntology().getType(ind);
        if (c == null) {
            c = ind.getKB().getType(ind);
        }
        if (c != null) {
            ont.addType(ind, c);
        }
        Map props = ind.getProperties();
        Iterator i = props.keySet().iterator();
        while (i.hasNext()) {
            OWLProperty p = (OWLProperty)i.next();
            List values = (List)props.get(p);
            Iterator j = values.iterator();
            while (j.hasNext()) {
                OWLIndividual obj;
                OWLValue value = (OWLValue)j.next();
                ont.addProperty(ind, p, value);
                if (!(value instanceof OWLIndividual) || !(obj = (OWLIndividual)value).isAnon()) continue;
                this.getBnodeClosure(obj, ont);
            }
        }
    }

    public OWLOntology getSourceOntology() {
        return this.getOntology().getTranslationSource();
    }

    public OWLSOntology getOWLSOntology() {
        return (OWLSOntology)this.getOntology();
    }

    public boolean isSameAs(OWLIndividual other) {
        return this.kb.isSameAs(this, other);
    }

    public OWLIndividualList getSameIndividuals() {
        return this.kb.getSameIndividuals(this);
    }

    public boolean isDifferentFrom(OWLIndividual other) {
        return this.kb.isDifferentFrom(this, other);
    }

    public OWLIndividualList getDifferentIndividuals() {
        return this.kb.getDifferentIndividuals(this);
    }
}

