/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import impl.jena.OWLClassImpl;
import impl.jena.OWLDataPropertyImpl;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLIndividualImpl;
import impl.jena.OWLModelImpl;
import impl.jena.OWLObjectPropertyImpl;
import impl.jena.OWLOntologyImpl;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.OWLSKnowledgeBase;
import org.mindswap.owls.OWLSOntology;
import org.mindswap.owls.OWLSVersionTranslator;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.utils.QNameProvider;
import org.mindswap.utils.URIUtils;

public class OWLKnowledgeBaseImpl
extends OWLModelImpl
implements OWLKnowledgeBase,
OWLSKnowledgeBase {
    protected Set ontologies;
    private Map uriMap;
    private Map importDependencies;
    protected Set notImported;
    protected OWLReader reader;
    private QNameProvider qnames;
    private boolean autoConsistency;
    private OWLSVersionTranslator translator;
    private OWLKnowledgeBase translationSource;

    public OWLKnowledgeBaseImpl() {
        super(ModelFactory.createDefaultModel());
        this.setAutoTranslate(false);
        this.translationSource = this;
        this.ontologies = new HashSet();
        this.uriMap = new HashMap();
        this.importDependencies = new HashMap();
        this.notImported = new HashSet();
        this.reader = OWLFactory.createReader();
        this.qnames = new QNameProvider();
        this.autoConsistency = false;
        this.createBaseOntology();
    }

    protected void createBaseOntology() {
        URI uri = URI.create("urn:owl-s-api:baseOntology");
        Model model = this.getOntModel().getBaseModel();
        OWLOntology ontology = this.createOntologyWithoutLoading(uri, null, model);
        this.ontologies.add(ontology);
        this.setBaseOntology(ontology);
    }

    public Set getOntologies() {
        return this.getOntologies(true);
    }

    public Set getOntologies(boolean all) {
        if (all) {
            return new HashSet(this.ontologies);
        }
        return new HashSet(this.notImported);
    }

    public OWLOntology getOntology(URI uri) {
        return (OWLOntology)this.uriMap.get(uri);
    }

    public OWLOntology createOntology(boolean load) {
        if (load) {
            return this.createOntology();
        }
        return new OWLOntologyImpl(this, null, null, ModelFactory.createDefaultModel());
    }

    public OWLOntology createOntology() {
        return this.createOntology(null, null, ModelFactory.createDefaultModel());
    }

    public OWLOntology createOntology(URI uri) {
        return this.createOntology(uri, null, ModelFactory.createDefaultModel());
    }

    public OWLOntology createOntology(URI uri, URI fileURI) {
        return this.createOntology(uri, fileURI, ModelFactory.createDefaultModel());
    }

    public OWLOntology createOntology(URI uri, URI fileURI, Object implementation) {
        OWLOntology ont = this.createOntologyWithoutLoading(uri, fileURI, (Model)implementation);
        return this.load(ont);
    }

    protected OWLOntology createOntologyWithoutLoading(URI uri, URI fileURI, Model model) {
        OWLOntologyImpl ont = new OWLOntologyImpl(this, uri, fileURI, model);
        return ont;
    }

    public OWLOntology loadOntology(OWLOntology ont) {
        return this.load(ont);
    }

    public OWLOntology load(OWLOntology ont) {
        return this.load(ont, true);
    }

    public OWLOntology load(OWLOntology ont, boolean withImports) {
        OWLOntology loadedOnt = this.internalLoad(ont, withImports);
        this.notImported.add(loadedOnt);
        if (this.getAutoConsistency() && !this.isConsistent()) {
            System.err.println("WARNING: Rejecting to load " + ont + " " + "which causes the KB to be inconsistent!");
            this.unload(loadedOnt);
            loadedOnt = null;
        }
        return loadedOnt;
    }

    protected OWLOntology internalLoad(OWLOntology ont, boolean withImports) {
        OWLOntology loadedOnt = ont;
        URI uri = loadedOnt.getURI();
        if (uri != null && this.uriMap.containsKey(uri)) {
            return (OWLOntology)this.uriMap.get(uri);
        }
        if (this.getAutoTranslate()) {
            loadedOnt = this.translator.translate(ont);
            if (this.translationSource == this) {
                this.translationSource = OWLFactory.createKB();
                this.translationSource.setAutoTranslate(false);
            }
            this.translationSource.load(loadedOnt.getTranslationSource());
        }
        Model model = ((OntModel)loadedOnt.getImplementation()).getBaseModel();
        loadedOnt = this.createOntologyWithoutLoading(uri, loadedOnt.getFileURI(), model);
        if (uri != null) {
            this.uriMap.put(uri, loadedOnt);
        }
        this.ontologies.add(loadedOnt);
        this.ontModel.addSubModel(model);
        if (withImports) {
            Iterator i = ont.getImports().iterator();
            while (i.hasNext()) {
                OWLOntology imported = (OWLOntology)i.next();
                OWLOntology loadedImport = this.internalLoad(imported, withImports);
                loadedOnt.addImport(loadedImport);
                if (this.notImported.contains(loadedImport)) continue;
                HashSet<OWLOntology> importees = (HashSet<OWLOntology>)this.importDependencies.get(loadedImport);
                if (importees == null) {
                    importees = new HashSet<OWLOntology>();
                    this.importDependencies.put(loadedImport, importees);
                }
                importees.add(loadedOnt);
            }
        }
        return loadedOnt;
    }

    public void unload(URI uri) {
        OWLOntology ont = this.getOntology(uri = URIUtils.standardURI(uri));
        if (ont != null) {
            this.unload(ont);
        } else {
            System.out.println("Ontology " + uri + " not found in KB");
        }
    }

    public void unload(OWLOntology ontology) {
        URI uri = ontology.getURI();
        boolean removed = this.ontologies.remove(ontology);
        if (!removed) {
            String msg = ontology + " is not in the KB";
            if (uri != null && this.uriMap.containsKey(uri)) {
                msg = msg + " but there is another ontology with the same URI in the KB";
            }
            msg = msg + "!";
            throw new IllegalArgumentException(msg);
        }
        if (uri != null) {
            this.uriMap.remove(uri);
        }
        this.notImported.remove(ontology);
        Model m = ((OntModel)ontology.getImplementation()).getBaseModel();
        this.ontModel.removeSubModel(m);
        Iterator i = ontology.getImports().iterator();
        while (i.hasNext()) {
            OWLOntology importOnt = (OWLOntology)i.next();
            Set importees = (Set)this.importDependencies.get(importOnt);
            if (importees == null) continue;
            importees.remove(ontology);
            if (!importees.isEmpty()) continue;
            this.importDependencies.remove(importOnt);
            this.unload(importOnt);
        }
    }

    public OWLOntology read(String uri) throws FileNotFoundException, URISyntaxException {
        return this.reader.read(this, new URI(uri));
    }

    public OWLOntology read(URI uri) throws FileNotFoundException {
        return this.reader.read(this, uri);
    }

    public OWLOntology read(Reader in, URI baseURI) {
        return this.reader.read((OWLKnowledgeBase)this, in, baseURI);
    }

    public OWLOntology read(InputStream in, URI baseURI) {
        return this.reader.read((OWLKnowledgeBase)this, in, baseURI);
    }

    public OWLReader getReader() {
        return this.reader;
    }

    public QNameProvider getQNames() {
        return this.qnames;
    }

    protected OWLDataValue wrapDataValue(Literal l, OWLOntology ont) {
        return new OWLDataValueImpl(l);
    }

    protected OWLIndividual wrapIndividual(Resource r, OWLOntology ont) {
        if (ont != null && ((OntModel)ont.getImplementation()).containsResource((RDFNode)r)) {
            return new OWLIndividualImpl(ont, r);
        }
        Iterator i = this.ontologies.iterator();
        while (i.hasNext()) {
            ont = (OWLOntology)i.next();
            if (!((OntModel)ont.getImplementation()).containsResource((RDFNode)r)) continue;
            return new OWLIndividualImpl(ont, r);
        }
        return new OWLIndividualImpl(this.baseOntology, r);
    }

    protected OWLClass wrapClass(Resource r, OWLOntology ont) {
        if (ont == null) {
            ont = this.baseOntology;
        }
        return new OWLClassImpl(ont, r);
    }

    protected OWLObjectProperty wrapObjectProperty(Property p, OWLOntology ont) {
        if (ont == null) {
            ont = this.baseOntology;
        }
        return new OWLObjectPropertyImpl(ont, p);
    }

    protected OWLDataProperty wrapDataProperty(Property p, OWLOntology ont) {
        if (ont == null) {
            ont = this.baseOntology;
        }
        return new OWLDataPropertyImpl(ont, p);
    }

    public OWLClass createClass(URI uri) {
        return this.baseOntology.createClass(uri);
    }

    public OWLObjectProperty createObjectProperty(URI uri) {
        return this.baseOntology.createObjectProperty(uri);
    }

    public OWLDataProperty createDataProperty(URI uri) {
        return this.baseOntology.createDataProperty(uri);
    }

    public OWLIndividual createIndividual(URI uri) {
        return this.baseOntology.createIndividual(uri);
    }

    public OWLIndividual createInstance(OWLClass c) {
        return this.baseOntology.createInstance(c);
    }

    public OWLIndividual createInstance(OWLClass c, URI uri) {
        return this.baseOntology.createInstance(c, uri);
    }

    public OWLDataValue createDataValue(String value) {
        return this.baseOntology.createDataValue(value);
    }

    public OWLDataValue createDataValue(String value, String language) {
        return this.baseOntology.createDataValue(value, language);
    }

    public OWLDataValue createDataValue(Object value, URI datatypeURI) {
        return this.baseOntology.createDataValue(value, datatypeURI);
    }

    public OWLDataValue createDataValue(Object value) {
        return this.baseOntology.createDataValue(value);
    }

    public void setReader(OWLReader reader) {
        this.reader = reader;
    }

    public void refresh() {
        this.ontModel.rebind();
    }

    public void setProperty(OWLIndividual ind, OWLDataProperty prop, String value) {
        this.baseOntology.setProperty(ind, prop, value);
    }

    public void setProperty(OWLIndividual ind, OWLDataProperty prop, Object value) {
        this.baseOntology.setProperty(ind, prop, value);
    }

    public void setProperty(OWLIndividual ind, OWLDataProperty prop, OWLDataValue value) {
        this.baseOntology.setProperty(ind, prop, value);
    }

    public void addProperty(OWLIndividual ind, OWLProperty prop, OWLValue value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    public void addProperty(OWLIndividual ind, OWLDataProperty prop, OWLDataValue value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    public void addProperty(OWLIndividual ind, OWLDataProperty prop, String value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    public void addProperty(OWLIndividual ind, OWLDataProperty prop, Object value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    public void removeProperties(OWLIndividual ind, OWLProperty prop) {
        this.baseOntology.removeProperties(ind, prop);
    }

    public void removeProperty(OWLIndividual theInd, OWLProperty theProp, OWLValue theValue) {
        this.baseOntology.removeProperty(theInd, theProp, theValue);
    }

    public void addProperty(OWLIndividual ind, OWLObjectProperty prop, OWLIndividual value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    public void setProperty(OWLIndividual ind, OWLObjectProperty prop, OWLIndividual value) {
        this.baseOntology.setProperty(ind, prop, value);
    }

    public void addType(OWLIndividual ind, OWLClass c) {
        this.baseOntology.addType(ind, c);
    }

    public void removeTypes(OWLIndividual ind) {
        this.baseOntology.removeTypes(ind);
    }

    public boolean getAutoConsistency() {
        return this.autoConsistency;
    }

    public void setAutoConsistency(boolean auto) {
        this.autoConsistency = auto;
    }

    public boolean getAutoTranslate() {
        return this.translator != null;
    }

    public void setAutoTranslate(boolean auto) {
        this.translator = auto ? OWLSFactory.createVersionTranslator() : null;
    }

    public OWLKnowledgeBase getTranslationSource() {
        return this.translationSource;
    }

    public Service readService(String uri) throws FileNotFoundException, URISyntaxException {
        return this.readService(new URI(uri));
    }

    public Service readService(URI uri) throws FileNotFoundException {
        List list = this.readAllServices(uri);
        return list == null || list.isEmpty() ? null : this.getCorrectService(list, uri);
    }

    public Service readService(Reader in, URI baseURI) {
        List list = this.readAllServices(in, baseURI);
        return list == null || list.isEmpty() ? null : this.getCorrectService(list, baseURI);
    }

    public Service readService(InputStream in, URI baseURI) {
        List list = this.readAllServices(in, baseURI);
        return list == null || list.isEmpty() ? null : this.getCorrectService(list, baseURI);
    }

    public List readAllServices(String uri) throws FileNotFoundException, URISyntaxException {
        return this.readAllServices(new URI(uri));
    }

    public List readAllServices(URI uri) throws FileNotFoundException {
        OWLOntology ont = this.read(uri);
        return ont == null ? null : this.getServices();
    }

    public List readAllServices(Reader in, URI baseURI) {
        OWLOntology ont = this.read(in, baseURI);
        return ont == null ? null : this.getServices();
    }

    public List readAllServices(InputStream in, URI baseURI) {
        OWLOntology ont = this.read(in, baseURI);
        return ont == null ? null : this.getServices();
    }

    public List getServices() {
        OWLIndividualList inds = OWLFactory.createIndividualList();
        inds.addAll(this.getInstances(OWLS_1_1.Service.Service));
        Iterator iter = this.getSubClasses(OWLS_1_1.Service.Service, false).iterator();
        while (iter.hasNext()) {
            inds.addAll(this.getInstances((OWLClass)iter.next()));
        }
        return OWLSFactory.wrapList(inds, Service.class);
    }

    private Service getCorrectService(List list, URI uri) {
        boolean strictSearch = false;
        String patternUri = uri.toString();
        int fragmentSignPos = uri.toString().lastIndexOf("#");
        if (fragmentSignPos > -1) {
            if (fragmentSignPos + 1 != patternUri.length()) {
                strictSearch = true;
            }
            patternUri = patternUri.substring(0, patternUri.length() - 1);
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Service service = (Service)iter.next();
            if (strictSearch && service.getURI().equals(uri)) {
                return service;
            }
            if (strictSearch || service.getURI().toString().indexOf(patternUri) == -1) continue;
            return service;
        }
        return (Service)list.get(0);
    }

    public OWLSOntology createOWLSOntology() {
        return (OWLSOntology)this.createOntology();
    }

    public OWLSOntology createOWLSOntology(URI uri) {
        return (OWLSOntology)this.createOntology(uri);
    }

    public OWLIndividual parseLiteral(String literal) {
        return this.getBaseOntology().parseLiteral(literal);
    }
}

