/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import impl.jena.OWLClassImpl;
import impl.jena.OWLDataPropertyImpl;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLIndividualImpl;
import impl.jena.OWLModelImpl;
import impl.jena.OWLObjectPropertyImpl;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mx.com.hp.hpl.jena.datatypes.RDFDatatype;
import mx.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.owls.OWLSOntology;
import org.mindswap.owls.service.Service;

public class OWLOntologyImpl
extends OWLModelImpl
implements OWLOntology,
OWLSOntology {
    private OWLKnowledgeBase kb;
    private OWLIndividual ontResource;
    private URI uri;
    private URI fileURI;
    private Map imports;
    private OWLOntology sourceOntology;

    public OWLOntologyImpl(OWLKnowledgeBase kb, URI uri, URI fileURI, Model jenaModel) {
        super(jenaModel);
        super.setBaseOntology(this);
        this.uri = uri;
        this.fileURI = fileURI;
        this.kb = kb;
        this.imports = new HashMap();
        this.sourceOntology = this;
    }

    public OWLKnowledgeBase getKB() {
        return this.kb;
    }

    public Set getImports() {
        return new HashSet(this.imports.values());
    }

    public Set getImports(boolean direct) {
        if (!direct) {
            LinkedHashSet<OWLOntology> importsClosure = new LinkedHashSet<OWLOntology>();
            ArrayList<OWLOntology> orderedList = new ArrayList<OWLOntology>();
            orderedList.add(this);
            for (int i = 0; i < orderedList.size(); ++i) {
                OWLOntology ont = (OWLOntology)orderedList.get(i);
                if (importsClosure.contains(ont)) continue;
                importsClosure.add(ont);
                Iterator it = ont.getImports().iterator();
                while (it.hasNext()) {
                    OWLOntology imported = (OWLOntology)it.next();
                    if (importsClosure.contains(imported)) continue;
                    orderedList.add(imported);
                }
            }
            return importsClosure;
        }
        return this.getImports();
    }

    public void addImport(OWLOntology ontology) {
        URI fileURI = ontology.getFileURI();
        if (fileURI != null && !this.imports.containsKey(fileURI)) {
            this.imports.put(fileURI, ontology);
        }
    }

    public void addImports(Set theImports) {
        Iterator aIter = theImports.iterator();
        while (aIter.hasNext()) {
            try {
                OWLOntology aOnt = (OWLOntology)aIter.next();
                this.addImport(aOnt);
            }
            catch (Exception exception) {}
        }
    }

    public OWLClass createClass(URI uri) {
        OWLClass c = this.getClass(uri);
        if (c == null) {
            Resource r = this.asResource(uri);
            this.ontModel.add(r, mx.com.hp.hpl.jena.vocabulary.RDF.type, (RDFNode)OWL.Class);
            this.kb.refresh();
            c = new OWLClassImpl(this, r);
        }
        return c;
    }

    public OWLObjectProperty createObjectProperty(URI uri) {
        OWLObjectProperty c = this.getObjectProperty(uri);
        if (c == null) {
            Property r = this.asProperty(uri);
            this.ontModel.add((Resource)r, mx.com.hp.hpl.jena.vocabulary.RDF.type, (RDFNode)OWL.ObjectProperty);
            this.kb.refresh();
            c = new OWLObjectPropertyImpl((OWLOntology)this, r);
        }
        return c;
    }

    public OWLDataProperty createDataProperty(URI uri) {
        OWLDataProperty c = this.getDataProperty(uri);
        if (c == null) {
            Property r = this.asProperty(uri);
            this.ontModel.add((Resource)r, mx.com.hp.hpl.jena.vocabulary.RDF.type, (RDFNode)OWL.DatatypeProperty);
            this.kb.refresh();
            c = new OWLDataPropertyImpl((OWLOntology)this, r);
        }
        return c;
    }

    public OWLIndividual createIndividual(URI uri) {
        OWLIndividual ind = this.getIndividual(uri);
        if (ind == null) {
            Resource r = this.asResource(uri);
            ind = new OWLIndividualImpl(this, r);
            this.kb.refresh();
        }
        return ind;
    }

    public OWLIndividual createInstance(OWLClass c) {
        Resource r = this.ontModel.createResource();
        this.ontModel.add(r, mx.com.hp.hpl.jena.vocabulary.RDF.type, (RDFNode)((Resource)c.getImplementation()));
        OWLIndividualImpl ind = new OWLIndividualImpl(this, r);
        this.kb.refresh();
        return ind;
    }

    public OWLIndividual createInstance(OWLClass c, URI uri) {
        Resource r = this.asResource(uri);
        this.ontModel.add(r, mx.com.hp.hpl.jena.vocabulary.RDF.type, (RDFNode)((Resource)c.getImplementation()));
        OWLIndividualImpl ind = new OWLIndividualImpl(this, r);
        this.kb.refresh();
        return ind;
    }

    public OWLDataValue createDataValue(String value) {
        return new OWLDataValueImpl(this.ontModel.createLiteral(value));
    }

    public OWLDataValue createDataValue(String value, String language) {
        return new OWLDataValueImpl(this.ontModel.createLiteral(value, language));
    }

    public OWLDataValue createDataValue(Object value, URI datatypeURI) {
        if (datatypeURI.equals(RDF.XMLLiteral)) {
            return new OWLDataValueImpl(this.ontModel.createLiteral(value.toString(), true));
        }
        return new OWLDataValueImpl(this.ontModel.createTypedLiteral(value, datatypeURI.toString()));
    }

    public OWLDataValue createDataValue(Object value) {
        if (value instanceof OWLDataValue) {
            return (OWLDataValue)value;
        }
        if (value instanceof URI) {
            return new OWLDataValueImpl(this.ontModel.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDanyURI));
        }
        return new OWLDataValueImpl(this.ontModel.createTypedLiteral(value));
    }

    public URI getURI() {
        return this.uri;
    }

    public URI getFileURI() {
        return this.fileURI;
    }

    public String debugString() {
        return "Ontology (" + this.uri + ")";
    }

    public OWLEntity getOntologyObject() {
        return this.ontResource;
    }

    public OWLKnowledgeBase asKB() {
        return this.asKB(true);
    }

    public OWLKnowledgeBase asKB(boolean withImports) {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.load(this, withImports);
        return kb;
    }

    protected OWLDataValue wrapDataValue(Literal l, OWLOntology ont) {
        return new OWLDataValueImpl(l);
    }

    protected OWLIndividual wrapIndividual(Resource r, OWLOntology ont) {
        return new OWLIndividualImpl(this, r);
    }

    protected OWLClass wrapClass(Resource r, OWLOntology ont) {
        return new OWLClassImpl(this, r);
    }

    protected OWLObjectProperty wrapObjectProperty(Property p, OWLOntology ont) {
        return new OWLObjectPropertyImpl((OWLOntology)this, p);
    }

    protected OWLDataProperty wrapDataProperty(Property p, OWLOntology ont) {
        return new OWLDataPropertyImpl((OWLOntology)this, p);
    }

    public String toString() {
        if (this.uri == null) {
            return "Ontology()";
        }
        return "Ontology(" + this.uri + ")";
    }

    public void setURI(URI uri) {
        this.uri = uri;
        if (uri != null) {
            this.ontResource = new OWLIndividualImpl(this, this.ontModel.getResource(uri.toString()));
        }
    }

    public void setFileURI(URI uri) {
        this.fileURI = uri;
    }

    public void refresh() {
        this.ontModel.rebind();
        this.kb.refresh();
    }

    public void setProperty(OWLIndividual ind, OWLDataProperty prop, String value) {
        this.setProperty(ind, prop, this.createDataValue(value));
    }

    public void setProperty(OWLIndividual ind, OWLDataProperty prop, Object value) {
        this.setProperty(ind, prop, this.createDataValue(value));
    }

    public void setProperty(OWLIndividual ind, OWLDataProperty prop, OWLDataValue value) {
        Resource subject = (Resource)ind.getImplementation();
        Property predicate = (Property)prop.getImplementation();
        Literal object = (Literal)value.getImplementation();
        this.ontModel.remove(this.ontModel.listStatements(subject, predicate, (RDFNode)((Literal)null)));
        this.ontModel.add(subject, predicate, (RDFNode)object);
        this.kb.refresh();
    }

    public void addProperty(OWLIndividual ind, OWLProperty prop, OWLValue value) {
        if (prop instanceof OWLObjectProperty && value instanceof OWLIndividual) {
            this.addProperty(ind, (OWLObjectProperty)prop, (OWLIndividual)value);
        } else if (prop instanceof OWLDataProperty && value instanceof OWLDataValue) {
            this.addProperty(ind, (OWLDataProperty)prop, (OWLDataValue)value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void addProperty(OWLIndividual ind, OWLDataProperty prop, OWLDataValue value) {
        this.ontModel.add((Resource)ind.getImplementation(), (Property)prop.getImplementation(), (RDFNode)((Literal)value.getImplementation()));
        this.kb.refresh();
    }

    public void addProperty(OWLIndividual ind, OWLDataProperty prop, String value) {
        this.addProperty(ind, prop, this.createDataValue(value));
    }

    public void addProperty(OWLIndividual ind, OWLDataProperty prop, Object value) {
        this.addProperty(ind, prop, this.createDataValue(value));
    }

    public void removeProperties(OWLIndividual ind, OWLProperty prop) {
        Resource subject = (Resource)ind.getImplementation();
        Property predicate = (Property)prop.getImplementation();
        this.ontModel.remove(this.ontModel.listStatements(subject, predicate, (RDFNode)((Resource)null)));
        this.kb.refresh();
    }

    public void removeProperty(OWLIndividual ind, OWLProperty prop, OWLValue value) {
        Resource subject = (Resource)ind.getImplementation();
        Property predicate = (Property)prop.getImplementation();
        RDFNode object = (RDFNode)value.getImplementation();
        Statement stmt = this.ontModel.createStatement(subject, predicate, object);
        this.ontModel.remove(stmt);
        this.refresh();
    }

    public void addProperty(OWLIndividual ind, OWLObjectProperty prop, OWLIndividual value) {
        this.ontModel.add((Resource)ind.getImplementation(), (Property)prop.getImplementation(), (RDFNode)((Resource)value.getImplementation()));
        this.kb.refresh();
    }

    public void setProperty(OWLIndividual ind, OWLObjectProperty prop, OWLIndividual value) {
        Resource subject = (Resource)ind.getImplementation();
        Property predicate = (Property)prop.getImplementation();
        Resource object = (Resource)value.getImplementation();
        this.ontModel.remove(this.ontModel.listStatements(subject, predicate, (RDFNode)((Resource)null)));
        this.ontModel.add(subject, predicate, (RDFNode)object);
        this.kb.refresh();
    }

    public void addType(OWLIndividual ind, OWLClass c) {
        this.ontModel.add((Resource)ind.getImplementation(), mx.com.hp.hpl.jena.vocabulary.RDF.type, (RDFNode)((Resource)c.getImplementation()));
        this.kb.refresh();
    }

    public void removeTypes(OWLIndividual ind) {
        Resource subject = (Resource)ind.getImplementation();
        this.ontModel.remove(this.ontModel.listStatements(subject, mx.com.hp.hpl.jena.vocabulary.RDF.type, (RDFNode)((Resource)null)));
        this.kb.refresh();
    }

    public OWLOntology getTranslationSource() {
        return this.sourceOntology;
    }

    public void setTranslationSource(OWLOntology ontology) {
        this.sourceOntology = ontology;
    }

    public Service getService() {
        List list = this.getServices();
        return list.isEmpty() ? null : (Service)list.get(0);
    }

    public OWLIndividual parseLiteral(String literal) {
        StringReader in = new StringReader(literal);
        OWLOntologyImpl ont = (OWLOntologyImpl)this.kb.read(in, this.uri);
        OWLIndividual res = null;
        int outCount = 0;
        OWLIndividualList instances = ont.getIndividuals();
        for (int i = 0; i < instances.size(); ++i) {
            OWLIndividual ind = (OWLIndividual)instances.get(i);
            if (ont.getIncomingProperties(ind).isEmpty()) {
                return ind;
            }
            if (res == null) {
                res = ind;
                outCount = ont.getProperties(ind).size();
                continue;
            }
            int newCount = ont.getProperties(ind).size();
            if (newCount <= outCount) continue;
            res = ind;
            outCount = newCount;
        }
        return res;
    }

    public OWLOntology union(OWLOntology ont) {
        OWLOntology newOnt = OWLFactory.createOntology();
        newOnt.add(this);
        newOnt.add(ont);
        return newOnt;
    }

    public void add(OWLOntology ont) {
        Model m1 = ((OntModel)this.getImplementation()).getBaseModel();
        Model m2 = ((OntModel)ont.getImplementation()).getBaseModel();
        m1.add(m2);
        this.kb.refresh();
    }

    public List getServices() {
        if (this.kb != null) {
            return this.kb.getServices();
        }
        return super.getServices();
    }
}

