/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLModelImpl;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.ontology.Ontology;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.RDFWriter;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFSyntax;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLWriter;

public class OWLWriterImpl
implements OWLWriter {
    private List prettyTypes = new ArrayList();
    private Map prefixMap = new HashMap();
    private boolean showXmlDeclaration = true;
    private Charset defaultCharset = Charset.forName("UTF8");

    public boolean isShowXmlDeclaration() {
        return this.showXmlDeclaration;
    }

    public void setShowXmlDeclaration(boolean showXmlDeclaration) {
        this.showXmlDeclaration = showXmlDeclaration;
    }

    private void writeInternal(OWLModel theOntology, Writer out, URI baseURI) {
        OntModel model = null;
        if (theOntology instanceof OWLKnowledgeBaseImpl) {
            model = ModelFactory.createOntologyModel();
            OWLKnowledgeBaseImpl aKB = (OWLKnowledgeBaseImpl)theOntology;
            Set onts = aKB.ontologies;
            Iterator iter = onts.iterator();
            Ontology aOntNode = null;
            if (baseURI == null) {
                Resource aRes = model.createResource();
                aRes.addProperty(RDF.type, (RDFNode)OWL.Ontology);
                aOntNode = (Ontology)aRes.as(Ontology.class);
            } else {
                aOntNode = model.getOntology(baseURI.toString());
            }
            while (iter.hasNext()) {
                OWLOntology aOnt = (OWLOntology)iter.next();
                if (aKB.notImported.contains(aOnt) || aKB.getBaseOntology().equals(aOnt)) {
                    model.add((Model)aOnt.getImplementation());
                    continue;
                }
                aOntNode.addImport(model.getResource(aOnt.getURI().toString()));
            }
        } else {
            model = ((OWLModelImpl)theOntology).getOntModel();
        }
        OntModel aOutModel = ModelFactory.createOntologyModel();
        aOutModel.add(model.getBaseModel());
        RDFWriter writer = aOutModel.getWriter("RDF/XML-ABBREV");
        writer.setProperty("blockRules", (Object)new Resource[]{RDFSyntax.propertyAttr, RDFSyntax.sectionListExpand});
        writer.setProperty("showXmlDeclaration", (Object)new Boolean(this.showXmlDeclaration));
        writer.setProperty("allowBadURIs", (Object)Boolean.TRUE);
        Iterator i = this.prefixMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            aOutModel.setNsPrefix(entry.getKey().toString(), entry.getValue().toString());
        }
        if (baseURI != null) {
            writer.setProperty("xmlbase", (Object)baseURI.toString());
            aOutModel.setNsPrefix("", baseURI.toString());
        }
        writer.setProperty("prettyTypes", (Object)this.prettyTypes.toArray(new Resource[this.prettyTypes.size()]));
        if (theOntology instanceof OWLOntology) {
            this.handleImports((OWLOntology)theOntology, aOutModel, baseURI);
        }
        writer.write(aOutModel.getBaseModel(), out, "");
    }

    private void handleImports(OWLOntology theOntology, OntModel theModel, URI theBaseURI) {
        Ontology aOntNode = null;
        Ontology aBlankOnt = theModel.getOntology("");
        if (aBlankOnt != null) {
            // empty if block
        }
        if (theOntology.getURI() != null) {
            Ontology aNamedOnt = null;
            if (theBaseURI != null) {
                aNamedOnt = theModel.getOntology(theBaseURI.toString());
            } else {
                theModel.getOntology(theOntology.getURI().toString());
            }
            if (aNamedOnt != null) {
                aOntNode = aNamedOnt;
            }
        }
        if (aOntNode == null && theOntology.getImports().size() > 0) {
            aOntNode = theModel.listSubjectsWithProperty(RDF.type, (RDFNode)OWL.Ontology).hasNext() ? (Ontology)theModel.listSubjectsWithProperty(RDF.type, (RDFNode)OWL.Ontology).nextResource().as(Ontology.class) : (theBaseURI != null ? theModel.createOntology(theBaseURI.toString()) : (theOntology.getURI() == null ? theModel.createOntology(null) : theModel.createOntology(theOntology.getURI().toString())));
        }
        Iterator aIter = theOntology.getImports().iterator();
        while (aIter.hasNext()) {
            OWLOntology aOnt = (OWLOntology)aIter.next();
            if (aOnt.getURI() == null) continue;
            aOntNode.addImport(theModel.getResource(aOnt.getURI().toString()));
        }
    }

    public void setNsPrefix(String prefix, String uri) {
        this.prefixMap.put(prefix, uri.toString());
    }

    public void addPrettyType(OWLClass c) {
        this.prettyTypes.add(c.getImplementation());
    }

    public void write(OWLModel ont, Writer writer) {
        this.writeInternal(ont, writer, null);
    }

    public void write(OWLModel ont, Writer writer, URI baseURI) {
        this.writeInternal(ont, writer, baseURI);
    }

    public void write(OWLModel ont, OutputStream out) {
        this.writeInternal(ont, new OutputStreamWriter(out, this.defaultCharset), null);
    }

    public void write(OWLModel ont, OutputStream out, URI baseURI) {
        this.writeInternal(ont, new OutputStreamWriter(out, this.defaultCharset), baseURI);
    }

    public static void main(String[] args) {
        OWLOntology aOnt = OWLFactory.createOntology(URI.create("http://www.mindswap.org/2004/owl-s/1.1/ZipCodeFinder.owl"));
        aOnt.addImport(OWLFactory.createOntology(URI.create("http://www.mindswap.org/2004/owl-s/1.1/Process.owl")));
        aOnt.write(System.err);
        ((Model)aOnt.getImplementation()).write((OutputStream)System.err);
    }
}

