/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.mindswap.owl.OWLCache;
import org.xml.sax.InputSource;

public class OWLCacheImpl
implements OWLCache {
    protected Properties cache = new Properties();
    protected String localCacheDirectory = null;
    protected boolean forced = true;

    public void setForced(boolean b) {
        this.forced = b;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setLocalCacheDirectory(String dir) {
        this.localCacheDirectory = dir;
        if (dir == null) {
            this.cache.clear();
            System.out.println("INFO: Local cache directory is disabled");
        } else {
            String indexFileName = this.localCacheDirectory + File.separator + "service.idx";
            try {
                File indexFile = new File(indexFileName);
                this.cache = new Properties();
                this.cache.load(new FileInputStream(indexFile));
                System.out.println("INFO: Cache has been initialized with " + this.cache.size() + " entries");
            }
            catch (FileNotFoundException e) {
                System.err.println("ERROR: Cache index file " + indexFileName + " cannot be found");
                this.localCacheDirectory = null;
            }
            catch (IOException e) {
                System.err.println("ERROR: Cache index file " + indexFileName + " has an invalid format");
                this.localCacheDirectory = null;
            }
        }
    }

    public String getLocalCacheDirectory() {
        return this.localCacheDirectory;
    }

    public InputSource getCachedFile(String fileURI) {
        InputSource in = null;
        try {
            String localFileName;
            if (this.cache == null) {
                return null;
            }
            if (fileURI.endsWith("#")) {
                fileURI = fileURI.substring(0, fileURI.length() - 1);
            }
            if ((localFileName = this.cache.getProperty(fileURI)) != null) {
                File file = new File(localFileName);
                if (!file.exists() && this.localCacheDirectory != null) {
                    file = new File(this.localCacheDirectory + File.separator + localFileName);
                }
                if (!file.exists()) {
                    System.out.println("WARNING: Cached file does not exist " + file);
                } else {
                    System.err.println("INFO: Using cached file " + file + " for URI " + fileURI);
                    in = new InputSource(new FileInputStream(file));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return in;
    }

    public void addCachedFile(String fileURI, File localFile) {
        this.cache.setProperty(fileURI, localFile.getName());
    }

    public void updateCachedFile(URI uri) {
    }

    public void updateIndexFile() {
        String indexFileName = this.getLocalCacheDirectory() + File.separator + "service.idx";
        try {
            this.cache.store(new FileOutputStream(indexFileName), "");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

