/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import org.mindswap.exceptions.ConversionException;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;

public abstract class OWLObjectImpl
implements OWLObject {
    private OWLObject next = this;

    public OWLObject getNextView() {
        return this.next;
    }

    public void setNextView(OWLObject nextView) {
        this.next = nextView;
    }

    private void addView(OWLObject newView) {
        newView.setNextView(this.next);
        this.next = newView;
    }

    private OWLObject findView(Class javaClass) {
        OWLObject obj = this;
        do {
            if (!javaClass.isInstance(obj)) continue;
            return obj;
        } while ((obj = obj.getNextView()) != this);
        return null;
    }

    public OWLObject castTo(Class javaClass) {
        OWLObject view = this.findView(javaClass);
        if (view == null) {
            OWLObjectConverter converter = OWLConfig.getConverter(javaClass);
            if (converter == null) {
                throw new ConversionException("No converter found for " + javaClass);
            }
            view = converter.cast(this);
            this.addView(view);
        }
        return view;
    }

    public boolean canCastTo(Class javaClass) {
        OWLObjectConverter converter = OWLConfig.getConverter(javaClass);
        return converter != null && converter.canCast(this);
    }

    public String debugString() {
        return this.getImplementation().toString();
    }

    public boolean equals(Object object) {
        if (object instanceof OWLObjectImpl) {
            return this.getImplementation().equals(((OWLObjectImpl)object).getImplementation());
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getImplementation().hashCode();
        return hash;
    }
}

