/*
 * Decompiled with CFR 0.152.
 */
package impl.owl.list;

import impl.owl.WrappedIndividual;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.mindswap.exceptions.InvalidListException;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.ListVocabulary;
import org.mindswap.owl.list.RDFList;
import org.mindswap.owl.vocabulary.RDF;

public class RDFListImpl
extends WrappedIndividual
implements RDFList {
    protected ListVocabulary vocabulary;

    public RDFListImpl(OWLIndividual ind) {
        super(ind);
        this.setVocabulary(RDF.ListVocabulary);
    }

    public RDFList getRest() {
        return (RDFList)this.getProperty(this.vocabulary.rest()).castTo(RDFList.class);
    }

    public void setRest(RDFList rest) {
        this.setProperty(this.vocabulary.rest(), rest);
    }

    public OWLIndividual getFirst() {
        return (OWLIndividual)this.getFirstValue();
    }

    public OWLValue getFirstValue() {
        OWLValue value = this.getProperty(this.vocabulary.firstD());
        if (value == null) {
            value = this.getProperty(this.vocabulary.first());
        }
        return value;
    }

    public void setFirst(OWLValue value) {
        if (this.isEmpty()) {
            throw new RuntimeException("Cannot modify empty list (list:nil)");
        }
        if (value instanceof OWLDataValue) {
            this.setProperty(this.vocabulary.firstD(), (OWLDataValue)value);
        } else {
            this.setProperty(this.vocabulary.first(), (OWLIndividual)value);
        }
    }

    public OWLIndividualList getAll() {
        OWLIndividualList result = OWLFactory.createIndividualList();
        RDFList list = this;
        while (!list.isEmpty()) {
            result.add(list.getFirst());
            list = list.getRest();
        }
        return result;
    }

    public List getAllValues() {
        ArrayList<OWLValue> result = new ArrayList<OWLValue>();
        RDFList list = this;
        while (!list.isEmpty()) {
            result.add(list.getFirstValue());
            list = list.getRest();
        }
        return result;
    }

    public OWLIndividual get(int index) {
        return (OWLIndividual)this.getValue(index);
    }

    public OWLValue getValue(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return index == 0 ? this.getFirstValue() : this.getRest().getValue(index - 1);
    }

    public RDFList add(OWLValue item) {
        if (this.isEmpty()) {
            return this.insert(item);
        }
        RDFList rest = this.getRest();
        if (rest.isEmpty()) {
            this.setRest(rest.insert(item));
        } else {
            rest.add(item);
        }
        return this;
    }

    public RDFList insert(OWLValue first) {
        RDFListImpl list = new RDFListImpl(this.getOntology().createInstance(this.vocabulary.List()));
        list.setVocabulary(this.vocabulary);
        list.setFirst(first);
        list.setRest(this);
        return list;
    }

    public RDFList insertAt(int index, OWLValue value) {
        if (index == 0) {
            return this.insert(value);
        }
        if (index < 0 || this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        RDFList rest = this.getRest();
        return rest.insertAt(index - 1, value);
    }

    public void set(int index, OWLValue value) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Cannot modify empty list (list:nil)");
        }
        int size = this.size();
        if (index > size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == size) {
            this.add(value);
        } else {
            RDFList list = this;
            for (int i = 0; i < index; ++i) {
                list = list.getRest();
            }
            list.setFirst(value);
        }
    }

    public Iterator iterator() {
        return new RDFListIterator(this);
    }

    public int size() {
        return this.isEmpty() ? 0 : 1 + this.getRest().size();
    }

    public boolean isEmpty() {
        return this.equals(this.vocabulary.nil());
    }

    public ListVocabulary getVocabulary() {
        return this.vocabulary;
    }

    public void setVocabulary(ListVocabulary vocabulary) {
        this.vocabulary = vocabulary;
    }

    private class RDFListIterator
    implements Iterator {
        private RDFList list;

        private RDFListIterator(RDFList list) {
            this.list = list;
        }

        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from ObjList iterator");
        }

        public boolean hasNext() {
            return !this.list.isEmpty();
        }

        public Object next() {
            if (this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            OWLIndividual result = this.list.getFirst();
            this.list = this.list.getRest();
            if (result == null || this.list == null) {
                throw new InvalidListException();
            }
            return result;
        }
    }
}

