/*
 * Decompiled with CFR 0.152.
 */
package impl.owls;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLDataValueList;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.list.RDFList;
import org.mindswap.owl.vocabulary.RDFS;
import org.mindswap.owls.OWLSVersionTranslator;
import org.mindswap.owls.generic.list.OWLSObjList;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.Conditional;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Iterate;
import org.mindswap.owls.process.MultiConditional;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.owls.vocabulary.OWLS_1_0;
import org.mindswap.owls.vocabulary.OWLS_1_1;

public class OWLSTranslator_1_0
implements OWLSVersionTranslator {
    public static boolean DEBUG = false;
    private OWLKnowledgeBase kb;
    private OWLOntology inputOnt;
    private OWLOntology outputOnt;
    private List profileInputURIs = new Vector();
    private Map translation;

    public String getVersion() {
        return "1.0";
    }

    public boolean canTranslate(OWLOntology ontology) {
        return ontology.getInstances(OWLS_1_0.Service.Service).size() > 0;
    }

    public OWLOntology translate(OWLOntology ont) {
        this.kb = OWLFactory.createKB();
        this.inputOnt = this.kb.load(ont);
        this.outputOnt = OWLFactory.createOntology(ont.getURI());
        this.translation = new HashMap();
        this.translateServices();
        this.translateProfiles();
        this.translateProcesses();
        this.translateGroundings();
        this.translateAtomicGroundings();
        Iterator i = ont.getImports().iterator();
        while (i.hasNext()) {
            OWLOntology imported = (OWLOntology)i.next();
            this.outputOnt.addImport(imported);
        }
        this.outputOnt.setTranslationSource(this.inputOnt);
        if (this.canTranslate(ont)) {
            this.outputOnt.addType(ont.getInstances(OWLS_1_0.Service.Service).individualAt(0), OWLS_1_0.Service.Service);
        }
        return this.outputOnt;
    }

    private void translateServices() {
        OWLIndividualList list = this.inputOnt.getInstances(OWLS_1_0.Service.Service);
        for (int i = 0; i < list.size(); ++i) {
            OWLIndividual serviceInfo = list.individualAt(i);
            this.createService(serviceInfo);
        }
    }

    private void translateProfiles() {
        OWLIndividualList list = this.inputOnt.getInstances(OWLS_1_0.Profile.Profile);
        for (int i = 0; i < list.size(); ++i) {
            OWLIndividual profileInfo = list.individualAt(i);
            this.createProfile(profileInfo);
        }
    }

    private void translateProcesses() {
        OWLClass[] processClass = new OWLClass[]{OWLS_1_0.Process.AtomicProcess, OWLS_1_0.Process.CompositeProcess, OWLS_1_0.Process.SimpleProcess};
        for (int i = 0; i < processClass.length; ++i) {
            OWLIndividualList list = this.inputOnt.getInstances(processClass[i]);
            for (int j = 0; j < list.size(); ++j) {
                OWLIndividual processInfo = list.individualAt(j);
                this.createProcess(processInfo);
            }
        }
    }

    private void translateGroundings() {
        OWLClass[] groundingClass = new OWLClass[]{OWLS_1_0.Grounding.WsdlGrounding, FLAServiceOnt.UPnPGrounding};
        for (int i = 0; i < groundingClass.length; ++i) {
            OWLIndividualList list = this.inputOnt.getInstances(groundingClass[i]);
            for (int j = 0; j < list.size(); ++j) {
                OWLIndividual groundingInfo = list.individualAt(j);
                this.createGrounding(groundingInfo);
            }
        }
    }

    private void translateAtomicGroundings() {
        OWLClass[] groundingClass = new OWLClass[]{OWLS_1_0.Grounding.WsdlAtomicProcessGrounding, FLAServiceOnt.UPnPAtomicProcessGrounding};
        for (int i = 0; i < groundingClass.length; ++i) {
            OWLIndividualList list = this.inputOnt.getInstances(groundingClass[i]);
            for (int j = 0; j < list.size(); ++j) {
                OWLIndividual groundingInfo = list.individualAt(j);
                this.createAPGrounding(groundingInfo);
            }
        }
    }

    private Perform getCachedPerform(Process process, OWLIndividual ind) {
        List components = ((CompositeProcess)process).getComposedOf().getConstructs();
        Iterator i = components.iterator();
        while (i.hasNext()) {
            ControlConstruct cc = (ControlConstruct)i.next();
            if (!(cc instanceof Perform) || !((Perform)cc).getProcess().equals(ind)) continue;
            return (Perform)cc;
        }
        return null;
    }

    private OWLIndividual translate(OWLIndividual ind, OWLClass owlClass) {
        OWLIndividual translated = (OWLIndividual)this.translation.get(ind);
        if (translated == null) {
            translated = ind.isAnon() ? this.outputOnt.createInstance(owlClass) : this.outputOnt.createInstance(owlClass, ind.getURI());
            if (owlClass != null) {
                translated.addType(owlClass);
            }
            this.translation.put(ind, translated);
        }
        return translated;
    }

    private OWLIndividual translate(OWLIndividual ind, Class javaClass, OWLClass owlClass) {
        OWLIndividual translated = (OWLIndividual)this.translation.get(ind);
        if (translated == null) {
            OWLIndividual newInd = ind.isAnon() ? this.outputOnt.createInstance(owlClass) : this.outputOnt.createInstance(owlClass, ind.getURI());
            translated = (OWLIndividual)newInd.castTo(javaClass);
            this.translation.put(ind, translated);
        }
        return translated;
    }

    private Service createService(OWLIndividual serviceInfo) {
        try {
            OWLIndividual translated = (OWLIndividual)this.translation.get(serviceInfo);
            if (translated != null) {
                return (Service)translated.castTo(Service.class);
            }
            Service service = (Service)this.translate(serviceInfo, Service.class, OWLS_1_1.Service.Service);
            OWLIndividual profileInfo = this.inputOnt.getProperty(serviceInfo, OWLS_1_0.Service.presents);
            OWLIndividual processModelInfo = this.inputOnt.getProperty(serviceInfo, OWLS_1_0.Service.describedBy);
            OWLIndividual groundingInfo = this.inputOnt.getProperty(serviceInfo, OWLS_1_0.Service.supports);
            Process process = this.createProcessModel(processModelInfo);
            Profile profile = this.createProfile(profileInfo);
            Grounding grounding = this.createGrounding(groundingInfo);
            service.setProcess(process);
            service.setProfile(profile);
            service.setGrounding(grounding);
            this.translateAll(serviceInfo);
            return service;
        }
        catch (RuntimeException e) {
            this.error("Invalid service description");
            e.printStackTrace();
            return null;
        }
    }

    private Process createProcessModel(OWLIndividual processModelInfo) {
        OWLIndividual processInfo = this.inputOnt.getProperty(processModelInfo, OWLS_1_0.Process.hasProcess);
        return this.createProcess(processInfo);
    }

    private Process createProcess(OWLIndividual processInfo) {
        try {
            OWLIndividual translated = (OWLIndividual)this.translation.get(processInfo);
            if (translated != null) {
                return (Process)translated.castTo(Process.class);
            }
            Process process = null;
            if (this.inputOnt.isType(processInfo, OWLS_1_0.Process.AtomicProcess)) {
                process = this.createAtomicProcess(processInfo);
            } else if (this.inputOnt.isType(processInfo, OWLS_1_0.Process.CompositeProcess)) {
                process = this.createCompositeProcess(processInfo);
            } else if (this.inputOnt.isType(processInfo, OWLS_1_0.Process.SimpleProcess)) {
                process = this.createSimpleProcess(processInfo);
            } else {
                this.error("Unknown process type " + processInfo);
                return null;
            }
            this.copyPropertyValues(processInfo, OWLS_1_0.Process.name, (OWLIndividual)process, OWLS_1_1.Process.name);
            this.createProcessParams(process, true, processInfo);
            this.createProcessParams(process, false, processInfo);
            this.createCondition(process, this.inputOnt.getProperties(processInfo, OWLS_1_0.Profile.hasPrecondition));
            this.createDataFlow(process, processInfo);
            return process;
        }
        catch (RuntimeException e) {
            this.error("Invalid process description");
            e.printStackTrace();
            return null;
        }
    }

    private AtomicProcess createAtomicProcess(OWLIndividual processInfo) {
        AtomicProcess process = (AtomicProcess)this.translate(processInfo, AtomicProcess.class, OWLS_1_1.Process.AtomicProcess);
        return process;
    }

    private SimpleProcess createSimpleProcess(OWLIndividual processInfo) {
        SimpleProcess process = (SimpleProcess)this.translate(processInfo, SimpleProcess.class, OWLS_1_1.Process.SimpleProcess);
        return process;
    }

    private CompositeProcess createCompositeProcess(OWLIndividual processInfo) {
        CompositeProcess process = (CompositeProcess)this.translate(processInfo, CompositeProcess.class, OWLS_1_1.Process.CompositeProcess);
        OWLIndividual composedInfo = this.inputOnt.getProperty(processInfo, OWLS_1_0.Process.composedOf);
        if (composedInfo == null) {
            this.error("Cannot find the components for composite process (\n      process: " + processInfo + ")");
        } else {
            ControlConstruct controlConstruct = this.createControlConstruct(composedInfo);
            process.setComposedOf(controlConstruct);
        }
        return process;
    }

    private boolean isProcess(OWLIndividual processInfo) {
        return this.inputOnt.isType(processInfo, OWLS_1_0.Process.AtomicProcess) || this.inputOnt.isType(processInfo, OWLS_1_0.Process.CompositeProcess) || this.inputOnt.isType(processInfo, OWLS_1_0.Process.SimpleProcess);
    }

    private ControlConstruct createControlConstruct(OWLIndividual ccInfo) {
        OWLClass ccType = ccInfo.getType();
        ControlConstruct cc = null;
        if (this.isProcess(ccInfo)) {
            cc = this.createPerform(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Sequence)) {
            cc = this.createSequence(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Sequence)) {
            cc = this.createSequence(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Split)) {
            cc = this.createSplit(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.SplitJoin)) {
            cc = this.createSplitJoin(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Unordered)) {
            cc = this.createAnyOrder(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.IfThenElse)) {
            cc = this.createIfThenElse(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Choice)) {
            cc = this.createChoice(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Iterate)) {
            cc = this.createIterate(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.RepeatUntil)) {
            cc = this.createRepeatUntil(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.RepeatWhile)) {
            cc = this.createRepeatWhile(ccInfo);
        } else {
            this.error("Don't know how to translate the control construct " + ccType);
        }
        return cc;
    }

    private Perform createPerform(OWLIndividual processInfo) {
        Perform perform = this.outputOnt.createPerform();
        Process process = this.createProcess(processInfo);
        perform.setProcess(process);
        return perform;
    }

    private Sequence createSequence(OWLIndividual sequenceInfo) {
        Sequence sequence = (Sequence)this.translate(sequenceInfo, Sequence.class, OWLS_1_1.Process.Sequence);
        this.createComponents(sequence, sequenceInfo);
        return sequence;
    }

    private IfThenElse createIfThenElse(OWLIndividual ifThenElseInfo) {
        IfThenElse ifThenElse = (IfThenElse)this.translate(ifThenElseInfo, IfThenElse.class, OWLS_1_1.Process.IfThenElse);
        if (this.inputOnt.hasProperty(ifThenElseInfo, OWLS_1_0.Process.ifCondition)) {
            this.createCondition(ifThenElse, this.inputOnt.getProperties(ifThenElseInfo, OWLS_1_0.Process.ifCondition));
        } else {
            this.error("If-Then-Else does not have a process:ifCondition associated with it (\n     ifThenElse: " + ifThenElseInfo + ")");
        }
        if (this.inputOnt.hasProperty(ifThenElseInfo, OWLS_1_0.Process.thenP)) {
            OWLIndividual thenComponentInfo = this.inputOnt.getProperty(ifThenElseInfo, OWLS_1_0.Process.thenP);
            ControlConstruct thenComponent = this.createControlConstruct(thenComponentInfo);
            if (thenComponent != null) {
                ifThenElse.setThen(thenComponent);
            } else {
                this.error("If-Then-Else has an invalid process:then associated with it (\n     ifThenElse: " + ifThenElseInfo + ")");
            }
        } else {
            this.error("If-Then-Else does not have a process:then associated with it (\n     ifThenElse: " + ifThenElseInfo + ")");
        }
        if (this.inputOnt.hasProperty(ifThenElseInfo, OWLS_1_0.Process.elseP)) {
            OWLIndividual elseComponentInfo = this.inputOnt.getProperty(ifThenElseInfo, OWLS_1_0.Process.elseP);
            ControlConstruct elseComponent = this.createControlConstruct(elseComponentInfo);
            if (elseComponent != null) {
                ifThenElse.setThen(elseComponent);
            } else {
                this.error("If-Then-Else has an invalid process:else associated with it (\n     ifThenElse: " + ifThenElseInfo + ")");
            }
        }
        return ifThenElse;
    }

    private Split createSplit(OWLIndividual splitInfo) {
        Split split = (Split)this.translate(splitInfo, Split.class, OWLS_1_1.Process.Split);
        this.createComponents(split, splitInfo);
        return split;
    }

    private SplitJoin createSplitJoin(OWLIndividual splitInfo) {
        SplitJoin split = (SplitJoin)this.translate(splitInfo, SplitJoin.class, OWLS_1_1.Process.SplitJoin);
        this.createComponents(split, splitInfo);
        return split;
    }

    private AnyOrder createAnyOrder(OWLIndividual anyOrderInfo) {
        AnyOrder unordered = (AnyOrder)this.translate(anyOrderInfo, AnyOrder.class, OWLS_1_1.Process.AnyOrder);
        this.createComponents(unordered, anyOrderInfo);
        return unordered;
    }

    private Iterate createIterate(OWLIndividual iterateInfo) {
        Iterate iterate = (Iterate)this.translate(iterateInfo, Iterate.class, OWLS_1_1.Process.Iterate);
        return iterate;
    }

    private RepeatUntil createRepeatUntil(OWLIndividual repeatInfo) {
        RepeatUntil repeat = (RepeatUntil)this.translate(repeatInfo, RepeatUntil.class, OWLS_1_1.Process.RepeatUntil);
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.untilCondition)) {
            this.createCondition(repeat, this.inputOnt.getProperties(repeatInfo, OWLS_1_0.Process.untilCondition));
        } else {
            this.error("RepeatUntil does not have a process:untilCondition associated with it (\n     RepeatUntil: " + repeat + ")");
        }
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.components)) {
            this.error("RepeatUntil cannot have a process:components property. Use process:untilProcess instead!");
        }
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.untilProcess)) {
            OWLIndividual untilComponentInfo = this.inputOnt.getProperty(repeatInfo, OWLS_1_0.Process.untilProcess);
            ControlConstruct untilComponent = this.createControlConstruct(untilComponentInfo);
            if (untilComponent != null) {
                repeat.setComponent(untilComponent);
            } else {
                this.error("RepeatUntil has an invalid process:untilProcess associated with it (\n     RepeatUntil: " + repeatInfo + ")");
            }
        } else {
            this.error("RepeatUntil does not have a process:untilProcess associated with it (\n     RepeatUntil: " + repeat + ")");
        }
        return repeat;
    }

    private RepeatWhile createRepeatWhile(OWLIndividual repeatInfo) {
        RepeatWhile repeat = (RepeatWhile)this.translate(repeatInfo, RepeatWhile.class, OWLS_1_1.Process.RepeatWhile);
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.whileCondition)) {
            this.createCondition(repeat, this.inputOnt.getProperties(repeatInfo, OWLS_1_0.Process.whileCondition));
        } else {
            this.error("RepeatUntil does not have a process:ifCondition associated with it (\n     RepeatWhile: " + repeat + ")");
        }
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.components)) {
            this.error("RepeatWhile cannot have a process:components property. Use process:untilProcess instead!");
        }
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.whileProcess)) {
            OWLIndividual whileComponentInfo = this.inputOnt.getProperty(repeatInfo, OWLS_1_0.Process.whileProcess);
            ControlConstruct whileComponent = this.createControlConstruct(whileComponentInfo);
            if (whileComponent != null) {
                repeat.setComponent(whileComponent);
            } else {
                this.error("RepeatWhile has an invalid process:whileProcess associated with it (\n     RepeatWhile: " + repeatInfo + ")");
            }
        } else {
            this.error("RepeatWhile does not have a process:whileProcess associated with it (\n     RepeatWhile: " + repeat + ")");
        }
        return repeat;
    }

    private Choice createChoice(OWLIndividual choiceInfo) {
        Choice choice = (Choice)this.translate(choiceInfo, Choice.class, OWLS_1_1.Process.Choice);
        this.createComponents(choice, choiceInfo);
        return choice;
    }

    private void createComponents(ControlConstruct cc, OWLIndividual ccInfo) {
        OWLIndividual componentsInfo = this.inputOnt.getProperty(ccInfo, OWLS_1_0.Process.components);
        if (componentsInfo == null) {
            this.error(cc.getConstructName() + " construct does not have any components associated with it (" + "\n     Construct: " + ccInfo + ")");
            return;
        }
        OWLSObjList list = (OWLSObjList)componentsInfo.castTo(RDFList.class);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            OWLIndividual componentInfo = (OWLIndividual)i.next();
            ControlConstruct component = this.createControlConstruct(componentInfo);
            if (component == null) {
                this.warning("There is an invalid component description for " + cc);
                continue;
            }
            if (cc instanceof Sequence) {
                ((Sequence)cc).addComponent(component);
                continue;
            }
            if (cc instanceof AnyOrder) {
                ((AnyOrder)cc).addComponent(component);
                continue;
            }
            if (cc instanceof Choice) {
                ((Choice)cc).addComponent(component);
                continue;
            }
            if (cc instanceof Split) {
                ((Split)cc).addComponent(component);
                continue;
            }
            if (cc instanceof SplitJoin) {
                ((SplitJoin)cc).addComponent(component);
                continue;
            }
            throw new RuntimeException("Invalid control construct!");
        }
    }

    private void createDataFlow(Process process, OWLIndividual processComponentInfo) {
        try {
            OWLIndividualList list = this.inputOnt.getProperties(processComponentInfo, OWLS_1_0.Process.sameValues);
            for (int i = 0; i < list.size(); ++i) {
                Result result;
                Perform perform;
                OWLSObjList sameValuesList = (OWLSObjList)list.individualAt(i).castTo(class$org$mindswap$owl$list$RDFList == null ? OWLSTranslator_1_0.class$("org.mindswap.owl.list.RDFList") : class$org$mindswap$owl$list$RDFList);
                OWLIndividual value1 = sameValuesList.get(0);
                OWLIndividual value2 = sameValuesList.get(1);
                OWLIndividual p1 = this.inputOnt.getProperty(value1, OWLS_1_0.Process.theParameter);
                OWLIndividual p2 = this.inputOnt.getProperty(value2, OWLS_1_0.Process.theParameter);
                Parameter param1 = (Parameter)this.translation.get(p1);
                Parameter param2 = (Parameter)this.translation.get(p2);
                OWLIndividual process1 = this.inputOnt.getProperty(value1, OWLS_1_0.Process.atProcess);
                OWLIndividual process2 = this.inputOnt.getProperty(value2, OWLS_1_0.Process.atProcess);
                if (process1.equals(process) && process2.equals(process)) {
                    this.error("Same process used twice in the ValueOf!");
                    continue;
                }
                if (process1.equals(process)) {
                    perform = this.getCachedPerform(process, process2);
                    if (param1 instanceof Input) {
                        perform.addBinding((Input)param1, Perform.TheParentPerform, (Input)param2);
                        continue;
                    }
                    result = process.getResult();
                    if (result == null) {
                        result = this.outputOnt.createResult();
                        process.setResult(result);
                    }
                    result.addBinding((Output)param1, perform, (Output)param2);
                    continue;
                }
                if (process2.equals(process)) {
                    perform = this.getCachedPerform(process, process1);
                    if (param2 instanceof Input) {
                        perform.addBinding((Input)param2, Perform.TheParentPerform, (Input)param1);
                        continue;
                    }
                    result = process.getResult();
                    if (result == null) {
                        result = this.outputOnt.createResult();
                        process.setResult(result);
                    }
                    result.addBinding((Output)param2, perform, (Output)param1);
                    continue;
                }
                Perform perform1 = this.getCachedPerform(process, process1);
                Perform perform2 = this.getCachedPerform(process, process2);
                if (param1 instanceof Input) {
                    perform1.addBinding((Input)param1, perform2, (Output)param2);
                    continue;
                }
                perform2.addBinding((Input)param2, perform1, (Output)param1);
            }
        }
        catch (Exception e) {
            this.error("Invalid data flow specification ");
            e.printStackTrace();
        }
    }

    private Parameter createParam(OWLIndividual paramInfo) {
        OWLIndividual translated = (OWLIndividual)this.translation.get(paramInfo);
        if (translated != null) {
            return (Parameter)translated.castTo(Parameter.class);
        }
        Parameter param = null;
        if (this.inputOnt.isType(paramInfo, OWLS_1_0.Process.Input)) {
            param = (Parameter)this.translate(paramInfo, Input.class, OWLS_1_1.Process.Input);
        } else if (this.inputOnt.isType(paramInfo, OWLS_1_0.Process.Output)) {
            param = (Parameter)this.translate(paramInfo, Output.class, OWLS_1_1.Process.Output);
        } else {
            this.error("Unknown parameter type " + paramInfo);
            return null;
        }
        if (this.inputOnt.hasProperty(paramInfo, OWLS_1_0.Process.parameterType)) {
            URI typeURI = this.inputOnt.getProperty(paramInfo, OWLS_1_0.Process.parameterType).getURI();
            if (typeURI != null) {
                OWLType type = this.inputOnt.getType(typeURI);
                if (type == null) {
                    type = this.outputOnt.createClass(typeURI);
                }
                param.setParamType(type);
            }
        } else {
            this.error("Cannot find the type for the process parameter (\n    parameter: " + param + ")");
        }
        this.keepFLAProperties(paramInfo);
        if (this.inputOnt.isType(paramInfo, OWLS_1_0.Process.Input)) {
            try {
                if (!this.profileInputURIs.contains(param.getURI()) && paramInfo.getProperties().size() <= 1) {
                    param.addProperty(FLAServiceOnt.useRandomInput, "true");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return param;
    }

    private void createProcessParams(Process process, boolean isInput, OWLIndividual processInfo) {
        OWLObjectProperty prop = isInput ? OWLS_1_0.Process.hasInput : OWLS_1_0.Process.hasOutput;
        OWLIndividualList list = this.inputOnt.getProperties(processInfo, prop);
        for (int i = 0; i < list.size(); ++i) {
            OWLIndividual p = list.individualAt(i);
            Parameter param = null;
            if (isInput) {
                param = this.createParam(p);
                process.addInput((Input)param);
            } else {
                param = this.createParam(p);
                process.addOutput((Output)param);
            }
            this.copyPropertyValues(p, RDFS.label, (OWLIndividual)param, RDFS.label);
            if (!DEBUG) continue;
            System.out.println("  Process   " + process.getURI() + "\n" + (isInput ? "  Input     " : "  Output    ") + param.getURI() + "\n" + "  Type      " + param.getParamType() + "\n");
        }
    }

    private Profile createProfile(OWLIndividual profileInfo) {
        try {
            OWLIndividual translated = (OWLIndividual)this.translation.get(profileInfo);
            if (translated != null) {
                return (Profile)translated.castTo(Profile.class);
            }
            Profile profile = (Profile)this.translate(profileInfo, Profile.class, OWLS_1_1.Profile.Profile);
            this.copyPropertyValues(profileInfo, OWLS_1_0.Profile.serviceName, (OWLIndividual)profile, OWLS_1_1.Profile.serviceName);
            this.copyPropertyValues(profileInfo, RDFS.label, (OWLIndividual)profile, RDFS.label);
            this.copyPropertyValues(profileInfo, OWLS_1_0.Profile.textDescription, (OWLIndividual)profile, OWLS_1_1.Profile.textDescription);
            this.createProfileParams(profile, true, profileInfo);
            this.createProfileParams(profile, false, profileInfo);
            this.createCondition(profile, this.inputOnt.getProperties(profileInfo, OWLS_1_0.Profile.hasPrecondition));
            this.createServiceParameters(profile, profileInfo);
            this.translateAll(profileInfo);
            this.keepFLAProperties(profileInfo);
            return profile;
        }
        catch (RuntimeException e) {
            this.error("Invalid profile description");
            e.printStackTrace();
            return null;
        }
    }

    private void createServiceParameters(Profile profile, OWLIndividual profileInfo) {
        Set set = this.kb.getSubProperties(OWLS_1_0.Profile.serviceParameter);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            OWLObjectProperty prop = (OWLObjectProperty)it.next();
            OWLIndividualList list = profileInfo.getProperties(prop);
            for (int i = 0; i < list.size(); ++i) {
                OWLIndividual serviceParamInfo = list.individualAt(i);
                OWLIndividual serviceParam = this.translate(serviceParamInfo, serviceParamInfo.getType());
                OWLIndividual serviceParamValue = serviceParamInfo.getProperty(OWLS_1_0.Profile.sParameter);
                serviceParamValue = this.translateAll(serviceParamValue);
                profile.addProperty(prop, serviceParam);
                serviceParam.addProperty(OWLS_1_1.Profile.sParameter, serviceParamValue);
                this.copyPropertyValues(serviceParamInfo, OWLS_1_0.Profile.serviceParameterName, serviceParam, OWLS_1_1.Profile.serviceParameterName);
            }
        }
    }

    private OWLIndividual translateAll(OWLIndividual ind) {
        OWLIndividual translated = (OWLIndividual)this.translation.get(ind);
        if (translated == null) {
            if (this.isProcess(ind)) {
                return this.createProcess(ind);
            }
            translated = this.translate(ind, ind.getType());
            Map map = this.kb.getProperties(ind);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                OWLProperty prop = (OWLProperty)it.next();
                this.copyPropertyValues(ind, RDFS.label, translated, RDFS.label);
                if (prop instanceof OWLDataProperty) {
                    this.copyPropertyValues(ind, (OWLDataProperty)prop, translated, (OWLDataProperty)prop);
                    continue;
                }
                OWLObjectProperty objProp = (OWLObjectProperty)prop;
                OWLIndividualList list = this.inputOnt.getProperties(ind, objProp);
                for (int i = 0; i < list.size(); ++i) {
                    OWLIndividual value = list.individualAt(i);
                    value = this.translate(value, value.getType());
                    translated.addProperty(objProp, value);
                }
            }
        }
        return translated;
    }

    private void createProfileParams(Profile profile, boolean isInput, OWLIndividual profileInfo) {
        OWLObjectProperty prop = isInput ? OWLS_1_0.Profile.hasInput : OWLS_1_0.Profile.hasOutput;
        OWLIndividualList list = this.inputOnt.getProperties(profileInfo, prop);
        for (int i = 0; i < list.size(); ++i) {
            OWLIndividual p = list.individualAt(i);
            Parameter refersTo = (Parameter)this.translation.get(p);
            if (refersTo == null) {
                this.error("The parameter defined in profile does not exist in the process model (\n    parameter: " + p + ", " + "\n   in profile: " + profile.getURI() + ")");
                continue;
            }
            if (isInput) {
                profile.addInput((Input)refersTo);
                if (refersTo.getURI() != null) {
                    this.profileInputURIs.add(refersTo.getURI());
                }
            } else {
                profile.addOutput((Output)refersTo);
            }
            if (!DEBUG) continue;
            System.out.println("  Profile   " + profile.getURI() + "\n" + (isInput ? "  Input     " : "  Output    ") + p.getURI() + "\n" + "  Refers to " + refersTo + "\n");
        }
    }

    private void createCondition(Conditional conditional, OWLIndividualList list) {
        if (list.size() == 0) {
            return;
        }
        OWLIndividual conditionInfo = list.individualAt(0);
        Condition condition = (Condition)this.translate(conditionInfo, Condition.class, OWLS_1_1.Expression.Condition);
        conditional.setCondition(condition);
        if (list.size() > 1) {
            this.error("Multiple conditions defined for " + conditional);
        }
    }

    private void createCondition(MultiConditional conditional, OWLIndividualList list) {
        for (int i = 0; i < list.size(); ++i) {
            OWLIndividual conditionInfo = list.individualAt(i);
            Condition condition = (Condition)this.translate(conditionInfo, class$org$mindswap$owls$process$Condition == null ? OWLSTranslator_1_0.class$("org.mindswap.owls.process.Condition") : class$org$mindswap$owls$process$Condition, OWLS_1_1.Expression.Condition);
            conditional.addCondition(condition);
        }
    }

    private Grounding createGrounding(OWLIndividual groundingInfo) {
        AtomicGrounding apGrounding;
        OWLIndividual apGroundingInfo;
        int i;
        OWLIndividual translated = (OWLIndividual)this.translation.get(groundingInfo);
        if (translated != null) {
            return (Grounding)translated.castTo(Grounding.class);
        }
        Grounding grounding = (Grounding)this.translate(groundingInfo, Grounding.class, OWLS_1_1.Grounding.WsdlGrounding);
        OWLIndividualList list = this.inputOnt.getProperties(groundingInfo, OWLS_1_0.Grounding.hasAtomicProcessGrounding);
        for (i = 0; i < list.size(); ++i) {
            apGroundingInfo = list.individualAt(i);
            apGrounding = this.createAPGrounding(apGroundingInfo);
            if (apGrounding != null) {
                grounding.addGrounding(apGrounding);
                continue;
            }
            this.error("Invalid AtomicProcess grounding " + apGroundingInfo);
        }
        list = this.inputOnt.getProperties(groundingInfo, FLAServiceOnt.hasUPnPAtomicProcessGrounding);
        for (i = 0; i < list.size(); ++i) {
            apGroundingInfo = list.individualAt(i);
            apGrounding = this.createAPGrounding(apGroundingInfo);
            if (apGrounding != null) {
                grounding.addGrounding(apGrounding);
                continue;
            }
            this.error("Invalid AtomicProcess grounding " + apGroundingInfo);
        }
        if (grounding.getAtomicGroundings().size() == 0) {
            this.warning("The grounding of the service is empty (\n  grounding " + grounding.getURI() + ")");
        }
        return grounding;
    }

    private AtomicGrounding createAPGrounding(OWLIndividual groundingInfo) {
        try {
            OWLIndividual translated = (OWLIndividual)this.translation.get(groundingInfo);
            if (translated != null) {
                return (AtomicGrounding)translated.castTo(AtomicGrounding.class);
            }
            AtomicGrounding grounding = null;
            if (this.inputOnt.isType(groundingInfo, OWLS_1_0.Grounding.WsdlAtomicProcessGrounding)) {
                grounding = this.createWSDLGrounding(groundingInfo);
            } else if (this.inputOnt.isType(groundingInfo, FLAServiceOnt.UPnPAtomicProcessGrounding)) {
                grounding = this.createUPnPGrounding(groundingInfo);
            }
            return grounding;
        }
        catch (RuntimeException e) {
            this.error("Invalid profile description");
            e.printStackTrace();
            return null;
        }
    }

    private URI getGroundingURI(OWLIndividual groundingInfo, OWLDataProperty p) {
        OWLDataValue value = this.inputOnt.getProperty(groundingInfo, p);
        if (value == null) {
            this.error(groundingInfo + " does not have a grounding:" + p.getURI().getFragment() + " property");
        }
        try {
            return new URI(value.getLexicalValue().trim());
        }
        catch (Exception e) {
            this.error("The value of grounding:" + p.getURI().getFragment() + " property (" + value.getLexicalValue() + ") in " + groundingInfo + " is not a valid URI literal");
            return null;
        }
    }

    private AtomicProcess getGroundingProcess(OWLIndividual groundingInfo) {
        OWLIndividual processInfo = this.inputOnt.getProperty(groundingInfo, OWLS_1_0.Grounding.owlsProcess);
        if (!this.inputOnt.hasProperty(groundingInfo, OWLS_1_0.Grounding.owlsProcess)) {
            this.error(groundingInfo + " does not have a grounding:owlsProcess property");
            return null;
        }
        AtomicProcess process = (AtomicProcess)this.createProcess(processInfo);
        if (process == null) {
            this.error("The process specified in the grounding cannot be found (\n    grounding: " + groundingInfo + ", " + "\n      process: " + processInfo + ")");
            return null;
        }
        return process;
    }

    private AtomicGrounding createWSDLGrounding(OWLIndividual groundingInfo) {
        AtomicProcess process = this.getGroundingProcess(groundingInfo);
        URI wsdlLoc = this.getGroundingURI(groundingInfo, OWLS_1_0.Grounding.wsdlDocument);
        OWLIndividual operationInfo = this.inputOnt.getProperty(groundingInfo, OWLS_1_0.Grounding.wsdlOperation);
        URI opName = this.getGroundingURI(operationInfo, OWLS_1_0.Grounding.operation);
        URI portType = this.getGroundingURI(operationInfo, OWLS_1_0.Grounding.portType);
        WSDLAtomicGrounding g = (WSDLAtomicGrounding)this.translate(groundingInfo, WSDLAtomicGrounding.class, OWLS_1_1.Grounding.WsdlAtomicProcessGrounding);
        g.setWSDL(wsdlLoc);
        g.setOperation(opName);
        g.setPortType(portType);
        if (this.inputOnt.hasProperty(groundingInfo, OWLS_1_0.Grounding.wsdlInputMessage)) {
            g.setInputMessage(this.getGroundingURI(groundingInfo, OWLS_1_0.Grounding.wsdlInputMessage));
        }
        if (this.inputOnt.hasProperty(groundingInfo, OWLS_1_0.Grounding.wsdlOutputMessage)) {
            g.setOutputMessage(this.getGroundingURI(groundingInfo, OWLS_1_0.Grounding.wsdlOutputMessage));
        }
        if (process != null) {
            g.setProcess(process);
            this.createMessageMapList(g, groundingInfo, true);
            this.createMessageMapList(g, groundingInfo, false);
        } else {
            this.error("No OWL-S parameter defined for AtomicProcessGrounding " + groundingInfo);
        }
        if (DEBUG) {
            System.out.println("  Process   " + process.getURI() + "\n" + "  WSDL file " + wsdlLoc + "\n" + "  Operation " + opName + "\n");
        }
        return g;
    }

    private AtomicGrounding createUPnPGrounding(OWLIndividual groundingInfo) {
        OWLIndividual processInfo = this.inputOnt.getProperty(groundingInfo, OWLS_1_0.Grounding.owlsProcess);
        String upnpDevice = this.inputOnt.getProperty(groundingInfo, FLAServiceOnt.upnpDeviceURL).toString();
        String upnpService = this.inputOnt.getProperty(groundingInfo, FLAServiceOnt.upnpServiceID).toString();
        String upnpAction = this.inputOnt.getProperty(groundingInfo, FLAServiceOnt.upnpCommand).toString();
        AtomicProcess process = (AtomicProcess)this.createProcess(processInfo);
        UPnPAtomicGrounding g = (UPnPAtomicGrounding)this.translate(groundingInfo, UPnPAtomicGrounding.class, FLAServiceOnt.UPnPAtomicProcessGrounding);
        g.setProcess(process);
        g.setUPnPDescription(upnpDevice);
        g.setUPnPService(upnpService);
        g.setUPnPAction(upnpAction);
        this.createMessageMapList(g, groundingInfo, true);
        this.createMessageMapList(g, groundingInfo, false);
        if (DEBUG) {
            System.out.println("  Process " + process.getURI() + "\n" + "  Device  " + upnpDevice + "\n" + "  Service " + upnpService + "\n" + "  Action  " + upnpAction + "\n");
        }
        return g;
    }

    private void createMessageMapList(AtomicGrounding g, OWLIndividual groundingInfo, boolean isInput) {
        AtomicProcess process = g.getProcess();
        OWLObjectProperty messageParts = null;
        OWLObjectProperty olderMessageParts = null;
        OWLDataProperty messagePart = null;
        if (g instanceof UPnPAtomicGrounding) {
            messageParts = isInput ? FLAServiceOnt.upnpInputMapping : FLAServiceOnt.upnpOutputMapping;
            olderMessageParts = null;
            messagePart = FLAServiceOnt.upnpParameter;
        } else if (g instanceof WSDLAtomicGrounding) {
            messageParts = isInput ? OWLS_1_0.Grounding.wsdlInputs : OWLS_1_0.Grounding.wsdlOutputs;
            olderMessageParts = isInput ? OWLS_1_0.Grounding.wsdlInputMessageParts : OWLS_1_0.Grounding.wsdlOutputMessageParts;
            messagePart = OWLS_1_0.Grounding.wsdlMessagePart;
        }
        OWLIndividual messageMaps = this.inputOnt.getProperty(groundingInfo, messageParts);
        if (messageMaps == null && olderMessageParts != null && (messageMaps = this.inputOnt.getProperty(groundingInfo, olderMessageParts)) != null) {
            this.warning("Using deprecated property " + olderMessageParts + " instead of " + messageParts);
        }
        if (messageMaps == null) {
            ParameterList params;
            ParameterList parameterList = params = isInput ? process.getInputs() : process.getOutputs();
            if (!params.isEmpty()) {
                this.warning("No mapping defined for parameters (\n parameters: " + params + "\n    process: " + process + ")");
            }
            return;
        }
        RDFList messageMapList = (RDFList)messageMaps.castTo(RDFList.class);
        Iterator i = messageMapList.iterator();
        while (i.hasNext()) {
            OWLIndividual messageMap = (OWLIndividual)i.next();
            URI owlsParameterInfo = this.inputOnt.getProperty(messageMap, OWLS_1_0.Grounding.owlsParameter).getURI();
            Parameter owlsParameter = isInput ? process.getInputs().getParameter(owlsParameterInfo) : process.getOutputs().getParameter(owlsParameterInfo);
            String wsdlMessagePartInfo = this.inputOnt.getProperty(messageMap, messagePart).toString().trim();
            String transformation = null;
            if (this.inputOnt.hasProperty(messageMap, OWLS_1_0.Grounding.xsltTransformation)) {
                transformation = this.inputOnt.getProperty(messageMap, OWLS_1_0.Grounding.xsltTransformation).toString();
            }
            if (owlsParameter == null) {
                this.error("Cannot find the target of message map for " + (isInput ? "input" : "output") + " parameter (" + "\n   wsdl parameter: " + wsdlMessagePartInfo + ", " + "\n       in process: " + process.getURI() + ", " + "\n        mapped to: " + owlsParameterInfo + ")");
            } else {
                g.addMessageMap(owlsParameter, wsdlMessagePartInfo, transformation);
            }
            if (!DEBUG) continue;
            System.out.println("  Process   " + process.getURI() + "\n" + "  Param     " + owlsParameterInfo + "\n" + "  Grounding " + wsdlMessagePartInfo + "\n" + "  Transform " + transformation + "\n");
        }
    }

    private void copyPropertyValues(OWLIndividual src, OWLDataProperty srcProp, OWLIndividual target, OWLDataProperty targetProp) {
        OWLDataValueList list = this.inputOnt.getProperties(src, srcProp);
        for (int i = 0; i < list.size(); ++i) {
            target.addProperty(targetProp, list.valueAt(i));
        }
    }

    private void copyPropertyValues(OWLIndividual src, URI srcProp, OWLIndividual target, URI targetProp) {
        OWLDataValueList list = src.getAnnotations(srcProp);
        for (int i = 0; i < list.size(); ++i) {
            target.addAnnotation(targetProp, list.valueAt(i));
        }
    }

    private void warning(String string) {
        System.out.println("WARNING: " + string);
    }

    private void error(String string) {
        System.out.println("ERROR: " + string);
    }

    private OWLIndividual keepFLAProperties(OWLIndividual ind) {
        OWLIndividual translated = this.translateAll(ind);
        if (translated != null) {
            Map map = ind.getProperties();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                OWLIndividual serviceParamInfo;
                int i;
                OWLIndividualList list;
                OWLProperty prop = (OWLProperty)it.next();
                if (prop instanceof OWLDataProperty) {
                    if (!FLAServiceOnt.flaDataProperties.contains(prop)) continue;
                    this.copyPropertyValues(ind, (OWLDataProperty)prop, translated, (OWLDataProperty)prop);
                    continue;
                }
                OWLObjectProperty objProp = (OWLObjectProperty)prop;
                if (FLAServiceOnt.flaObjectPropertiesToDataProperties.containsKey(prop)) {
                    list = this.inputOnt.getProperties(ind, objProp);
                    for (i = 0; i < list.size(); ++i) {
                        serviceParamInfo = list.individualAt(i);
                        translated.addProperty((OWLDataProperty)FLAServiceOnt.flaObjectPropertiesToDataProperties.get(prop), (Object)serviceParamInfo);
                    }
                    continue;
                }
                if (!FLAServiceOnt.flaObjectProperties.containsKey(prop)) continue;
                list = this.inputOnt.getProperties(ind, objProp);
                for (i = 0; i < list.size(); ++i) {
                    serviceParamInfo = list.individualAt(i);
                    OWLIndividual serviceParam = this.translate(serviceParamInfo, serviceParamInfo.getType());
                    OWLIndividual serviceParamValue = serviceParamInfo.getProperty(OWLS_1_0.Profile.sParameter);
                    serviceParamValue = this.translate(serviceParamValue, (OWLClass)FLAServiceOnt.flaObjectProperties.get(objProp));
                    translated.addProperty(objProp, serviceParam);
                    serviceParam.addProperty(OWLS_1_1.Profile.sParameter, serviceParamValue);
                }
            }
        }
        return translated;
    }
}

