/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import impl.owls.grounding.AtomicGroundingImpl;
import impl.owls.process.execution.ProcessExecutionEngineImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.ServiceNotAvailableException;
import org.mindswap.owl.EntityFactory;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLOperationRef;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputList;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.URIUtils;
import org.mindswap.utils.Utils;
import org.mindswap.utils.XSLTEngine;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;

public class WSDLAtomicGroundingImpl
extends AtomicGroundingImpl
implements WSDLAtomicGrounding {
    public WSDLAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    public void setWSDL(URI wsdlLoc) {
        this.setProperty(OWLS_1_1.Grounding.wsdlDocument, wsdlLoc);
    }

    public URI getWSDL() {
        return this.getPropertyAsURI(OWLS_1_1.Grounding.wsdlDocument);
    }

    public void setOperation(URI operation) {
        WSDLOperationRef opRef = this.getOperationRef();
        if (opRef == null) {
            opRef = this.getOntology().createWSDLOperationRef();
            this.setOperationRef(opRef);
        }
        opRef.setOperation(operation);
    }

    public URI getOperation() {
        return this.getOperationRef().getOperation();
    }

    public void setPortType(URI port) {
        WSDLOperationRef opRef = this.getOperationRef();
        if (opRef == null) {
            opRef = this.getOntology().createWSDLOperationRef();
            this.setOperationRef(opRef);
        }
        opRef.setPortType(port);
    }

    public URI getPortType() {
        return this.getOperationRef().getPortType();
    }

    public ValueMap invoke(ValueMap values) throws ExecutionException {
        return this.invoke(values, OWLFactory.createKB());
    }

    public ValueMap invoke(ValueMap values, OWLKnowledgeBase env) throws ExecutionException {
        ValueMap results = new ValueMap();
        String operation = this.getOperation().toString();
        WSDLService s = null;
        try {
            URI wsdlLoc = this.getWSDL();
            s = WSDLService.createService(wsdlLoc);
        }
        catch (Exception e1) {
            throw new ServiceNotAvailableException(this.getProcess(), e1);
        }
        WSDLOperation op = s.getOperation(operation);
        if (op == null) {
            op = s.getOperation(URIUtils.getLocalName(operation));
        }
        if (op == null) {
            throw new ExecutionException("Operation " + operation + " cannot be found in the WSDL description");
        }
        MessageMapList inputMapList = this.getInputMap();
        for (int i = 0; i < op.getInputs().size(); ++i) {
            WSDLParameter in = op.getInput(i);
            MessageMap mp = inputMapList.getMessageMap(in.getName());
            if (mp == null) continue;
            Parameter param = mp.getOWLSParameter();
            OWLValue value = values.getValue(param);
            if (value == null) {
                value = param.getConstantValue();
            }
            if (value == null) {
                throw new ExecutionException("Value of input parameter '" + param + "' is not set!");
            }
            Object inputValue = value;
            String xslt = mp.getTransformation();
            if (xslt != null) {
                if (value instanceof OWLIndividual) {
                    String rdf = ((OWLIndividual)value).toRDF();
                    String xsltResult = XSLTEngine.transform(rdf, xslt, values);
                    inputValue = Utils.getAsNode(xsltResult);
                    if (inputValue == null) {
                        inputValue = xsltResult.trim();
                    }
                } else {
                    throw new ExecutionException("Cannot apply XSLT transformation to data value '" + value + "' for input parameter '" + param + "'");
                }
            }
            in.setValue(inputValue);
        }
        try {
            op.invoke();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExecutionException(e.toString());
        }
        AtomicProcess process = this.getProcess();
        OutputList outputs = process.getOutputs();
        MessageMapList outputMapList = this.getOutputMap();
        for (int i = 0; i < outputs.size(); ++i) {
            Output param = outputs.outputAt(i);
            MessageMap mp = outputMapList.getMessageMap(param);
            WSDLParameter out = op.getOutput(mp.getGroundingParameter());
            String xslt = mp.getTransformation();
            if (out == null) {
                throw new ExecutionException("Parameter '" + mp.getGroundingParameter() + "' is not found in the WSDL file!");
            }
            Object outputValue = out.getValue();
            if (outputValue == null) {
                throw new ExecutionException("Value of output parameter '" + out + "' is not set by the WSDL operation!");
            }
            if (xslt != null) {
                String xml = out.getTextValue();
                if (xml.startsWith("<dwmlOut")) {
                    xml = outputValue.toString();
                }
                if (ProcessExecutionEngineImpl.DEBUG) {
                    System.out.println("XML: \n" + xml);
                    System.out.println("XSL: \n" + xslt);
                }
                outputValue = XSLTEngine.transform(xml, xslt);
                if (ProcessExecutionEngineImpl.DEBUG) {
                    System.out.println("RDF: \n" + outputValue);
                }
                if (outputValue == null) {
                    throw new ExecutionException("An error occurred when applying xsltTransformtion to output parameter '" + param + "'");
                }
            }
            if (param.getParamType().isDataType()) {
                results.setValue(param, EntityFactory.createDataValue(outputValue));
                continue;
            }
            results.setValue(param, env.getBaseOntology().parseLiteral(outputValue.toString()));
        }
        return results;
    }

    public URL getDescriptionURL() {
        try {
            return this.getWSDL().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URI getInputMessage() {
        return this.getPropertyAsURI(OWLS_1_1.Grounding.wsdlInputMessage);
    }

    public void setInputMessage(URI inputMessage) {
        this.setProperty(OWLS_1_1.Grounding.wsdlInputMessage, inputMessage);
    }

    public URI getOutputMessage() {
        return this.getPropertyAsURI(OWLS_1_1.Grounding.wsdlOutputMessage);
    }

    public void setOutputMessage(URI outputMessage) {
        this.setProperty(OWLS_1_1.Grounding.wsdlOutputMessage, outputMessage);
    }

    public MessageMapList getInputMap() {
        return OWLSFactory.createMessageMapList(this.getProperties(OWLS_1_1.Grounding.wsdlInput));
    }

    public MessageMapList getOutputMap() {
        return OWLSFactory.createMessageMapList(this.getProperties(OWLS_1_1.Grounding.wsdlOutput));
    }

    public WSDLOperationRef getOperationRef() {
        return (WSDLOperationRef)this.getPropertyAs(OWLS_1_1.Grounding.wsdlOperation, WSDLOperationRef.class);
    }

    public void setOperationRef(WSDLOperationRef operationRef) {
        this.setProperty(OWLS_1_1.Grounding.wsdlOperation, operationRef);
    }

    public void addMessageMap(Parameter owlsParameter, String groundingParameter, String xsltTransformation) {
        MessageMap map = null;
        if (owlsParameter instanceof Input) {
            map = this.getOntology().createWSDLInputMessageMap();
        } else if (owlsParameter instanceof Output) {
            map = this.getOntology().createWSDLOutputMessageMap();
        } else {
            throw new IllegalArgumentException("OWL-S parameter in the MessageMap is neither an Input nor Output!");
        }
        map.setOWLSParameter(owlsParameter);
        map.setGroundingParameter(groundingParameter);
        if (xsltTransformation != null && xsltTransformation.length() > 0) {
            map.setTransformation(xsltTransformation);
        }
        this.addMessageMap(map);
    }
}

