/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.execution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.MultipleSatisfiedPreconditionException;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.exceptions.UnsatisfiedPreconditionException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.RDFList;
import org.mindswap.owls.generic.list.OWLSObjList;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Binding;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructBag;
import org.mindswap.owls.process.ControlConstructList;
import org.mindswap.owls.process.ForEach;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.InputBindingList;
import org.mindswap.owls.process.Local;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputBinding;
import org.mindswap.owls.process.OutputBindingList;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.ParameterValue;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.ValueData;
import org.mindswap.owls.process.ValueOf;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.execution.ProcessExecutionListener;
import org.mindswap.owls.process.execution.ProcessMonitor;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.AtomList;

public class ProcessExecutionEngineImpl
implements ProcessExecutionEngine {
    public static boolean DEBUG = false;
    protected List executionListeners = new ArrayList();
    protected List monitors = new ArrayList();
    protected OWLKnowledgeBase env;
    protected OWLKnowledgeBase kb;
    protected boolean checkPreconditions = true;
    protected boolean allowMultipleSatisifedPreconditions = true;
    protected Map performResults;

    public void setKB(OWLKnowledgeBase kb) {
        this.kb = kb;
    }

    public OWLKnowledgeBase getKB() {
        return this.kb;
    }

    public void setPreconditionCheck(boolean checkPreconditions) {
        this.checkPreconditions = checkPreconditions;
    }

    public boolean isPreconditionCheck() {
        return this.checkPreconditions;
    }

    public boolean isAllowMultipleSatisifedPreconditions() {
        return this.allowMultipleSatisifedPreconditions;
    }

    public void setAllowMultipleSatisifedPreconditions(boolean allowMultipleSatisifedPreconditions) {
        this.allowMultipleSatisifedPreconditions = allowMultipleSatisifedPreconditions;
    }

    protected void notifyListeners(String msg) {
        Iterator i = this.executionListeners.iterator();
        while (i.hasNext()) {
            ProcessExecutionListener l = (ProcessExecutionListener)i.next();
            l.printMessage(msg);
        }
    }

    protected void setCurrentExecuteService(Process p) {
        Iterator i = this.executionListeners.iterator();
        while (i.hasNext()) {
            ProcessExecutionListener l = (ProcessExecutionListener)i.next();
            l.setCurrentExecuteService(p);
        }
    }

    protected void finishExecution(int retCode) {
        Iterator i = this.executionListeners.iterator();
        while (i.hasNext()) {
            ProcessExecutionListener l = (ProcessExecutionListener)i.next();
            l.finishExecution(retCode);
        }
    }

    public void addExecutionListener(ProcessExecutionListener listener) {
        this.executionListeners.add(listener);
    }

    public void addMonitor(ProcessMonitor monitor) {
        this.monitors.add(monitor);
    }

    protected void executionFailed(String msg) {
        this.executionFailed(new ExecutionException(msg));
    }

    protected void executionFailed(Exception e) {
        this.executionFailed(new ExecutionException(e));
    }

    protected void executionFailed(ExecutionException e) {
        Iterator i = this.monitors.iterator();
        while (i.hasNext()) {
            ProcessMonitor monitor = (ProcessMonitor)i.next();
            monitor.executionFailed(e);
        }
        throw e;
    }

    protected boolean passFilter(ProcessMonitor monitor, Process process) {
        int processType = 7;
        processType = process instanceof AtomicProcess ? 1 : (process instanceof CompositeProcess ? 2 : 4);
        return (processType & monitor.getMonitorFilter()) != 0;
    }

    protected void executionStarted(Process process, ValueMap inputs) {
        Iterator i = this.monitors.iterator();
        while (i.hasNext()) {
            ProcessMonitor monitor = (ProcessMonitor)i.next();
            if (!this.passFilter(monitor, process)) continue;
            monitor.executionStarted(process, inputs);
        }
    }

    protected void executionFinished(Process process, ValueMap inputs, ValueMap outputs) {
        Iterator i = this.monitors.iterator();
        while (i.hasNext()) {
            ProcessMonitor monitor = (ProcessMonitor)i.next();
            if (!this.passFilter(monitor, process)) continue;
            monitor.executionFinished(process, inputs, outputs);
        }
    }

    protected void executionStarted() {
        Iterator i = this.monitors.iterator();
        while (i.hasNext()) {
            ProcessMonitor monitor = (ProcessMonitor)i.next();
            monitor.executionStarted();
        }
    }

    protected void executionFinished() {
        Iterator i = this.monitors.iterator();
        while (i.hasNext()) {
            ProcessMonitor monitor = (ProcessMonitor)i.next();
            monitor.executionFinished();
        }
    }

    protected void initEnv(OWLKnowledgeBase defaultKB) {
        this.env = this.kb != null ? this.kb : defaultKB;
        this.performResults = new HashMap();
    }

    public ValueMap execute(Process p) {
        ValueMap result = this.execute(p, new ValueMap());
        return result;
    }

    public ValueMap execute(Process p, ValueMap values) {
        this.initEnv(p.getKB());
        this.executionStarted();
        ValueMap result = null;
        try {
            result = this.executeProcess(p, values);
        }
        catch (ExecutionException e) {
            this.executionFailed(e);
        }
        this.notifyListeners("[DONE]");
        this.finishExecution(-1);
        this.executionFinished();
        return result;
    }

    public ValueMap execute(Perform p) {
        this.initEnv(p.getKB());
        this.executionStarted();
        ValueMap result = null;
        try {
            result = this.executePerform(p);
        }
        catch (ExecutionException e) {
            this.executionFailed(e);
        }
        this.notifyListeners("[DONE]");
        this.finishExecution(-1);
        this.executionFinished();
        return result;
    }

    protected ValueMap executeProcess(Process process, ValueMap inputs) {
        ValueMap result = null;
        this.executionStarted(process, inputs);
        this.setCurrentExecuteService(process);
        if (this.checkPreconditions) {
            this.checkPreconditions(process, inputs);
        }
        if (process instanceof AtomicProcess) {
            result = this.executeAtomicProcess((AtomicProcess)process, inputs);
        } else if (process instanceof CompositeProcess) {
            result = this.executeCompositeProcess((CompositeProcess)process, inputs);
        } else if (process instanceof SimpleProcess) {
            this.executionFailed(new NotImplementedException("Executing simple processes is not implemented!"));
        } else {
            this.executionFailed("Unknown process type " + process);
        }
        if (result == null) {
            this.executionFailed("Null result after executng process " + process + "!");
        } else {
            this.executionFinished(process, inputs, result);
        }
        return result;
    }

    protected ValueMap executeAtomicProcess(AtomicProcess process, ValueMap values) {
        AtomicGrounding grounding;
        if (DEBUG) {
            System.out.println("Executing AtomicProcess " + process + "\nInputs:\n" + values.debugString());
        }
        if ((grounding = process.getGrounding()) == null) {
            throw new ExecutionException("No grounding for " + process);
        }
        if (DEBUG) {
            System.out.println("Invoking " + grounding.getDescriptionURL());
        }
        ValueMap result = grounding.invoke(values, this.env);
        result.addMap(values);
        if (DEBUG) {
            System.out.println("Result:\n" + result.debugString() + "\n");
        }
        if (!this.env.isConsistent()) {
            throw new ExecutionException("Invalid value returned from the process " + process);
        }
        return result;
    }

    protected ValueMap executeCompositeProcess(CompositeProcess process, ValueMap values) {
        ValueMap prevParentPerform = (ValueMap)this.performResults.get(OWLS_1_1.Process.TheParentPerform);
        this.performResults.put(OWLS_1_1.Process.TheParentPerform, values);
        this.executeConstruct(process.getComposedOf());
        Result result = process.getResult();
        if (result != null) {
            OutputBindingList bindings = result.getBindings();
            for (int i = 0; i < bindings.size(); ++i) {
                OutputBinding binding = bindings.outputBindingAt(i);
                Output output = binding.getOutput();
                OWLValue value = null;
                ParameterValue paramValue = binding.getValue();
                if (paramValue instanceof ValueOf) {
                    ValueOf valueOf = (ValueOf)paramValue;
                    Perform perform = valueOf.getPerform();
                    Parameter param = valueOf.getParameter();
                    ValueMap performResult = (ValueMap)this.performResults.get(perform);
                    if (performResult == null) {
                        this.executionFailed("Perform " + perform + " cannot be found!");
                    }
                    value = performResult.getValue(param);
                } else {
                    this.executionFailed(new NotImplementedException("Only ValueOf construct in Bindings is supported!"));
                }
                values.setValue(output, value);
            }
        }
        this.performResults.put(OWLS_1_1.Process.TheParentPerform, prevParentPerform);
        return values;
    }

    protected ValueMap executePerform(Perform p) {
        Process process = p.getProcess();
        if (process == null) {
            this.executionFailed("Perform " + p + " does not have a process");
        }
        ValueMap values = new ValueMap();
        ValueMap selfBinding = new ValueMap();
        ValueMap prevThisPerform = (ValueMap)this.performResults.get(OWLS_1_1.Process.ThisPerform);
        this.performResults.put(OWLS_1_1.Process.ThisPerform, values);
        InputBindingList bindings = p.getBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            OWLValue value;
            Binding binding = bindings.bindingAt(i);
            Parameter param = binding.getParameter();
            ParameterValue paramValue = binding.getValue();
            if (paramValue instanceof ValueData) {
                values.setValue(param, ((ValueData)paramValue).getData());
                continue;
            }
            if (!(paramValue instanceof ValueOf)) continue;
            ValueOf valueOf = (ValueOf)paramValue;
            Perform otherPerform = valueOf.getPerform();
            Parameter otherParam = valueOf.getParameter();
            ValueMap performResult = (ValueMap)this.performResults.get(otherPerform);
            if (performResult == null) {
                this.executionFailed("Perform " + otherPerform + " cannot be found!");
            }
            if ((value = performResult.getValue(otherParam)) == null) {
                if (otherPerform.equals(Perform.ThisPerform)) {
                    selfBinding.setValue(param, otherParam);
                    continue;
                }
                this.executionFailed("There is no value for " + param + " (bound to Perform: " + otherPerform + " Parameter: " + otherParam + ")");
                continue;
            }
            values.setValue(param, value);
        }
        Iterator i = selfBinding.getVariables().iterator();
        while (i.hasNext()) {
            Parameter param = (Parameter)i.next();
            Parameter otherParam = (Parameter)selfBinding.getValue(param);
            OWLValue value = values.getValue(otherParam);
            if (value == null) {
                this.executionFailed("There is no value for " + param + " (bound to Perform: ThisPerform Parameter: " + otherParam + ")");
            }
            values.setValue(param, value);
        }
        values = this.executeProcess(process, values);
        this.performResults.put(p, values);
        this.performResults.put(OWLS_1_1.Process.ThisPerform, prevThisPerform);
        return values;
    }

    protected void executeProduce(Produce produce) {
        ValueMap values = (ValueMap)this.performResults.get(OWLS_1_1.Process.ThisPerform);
        OutputBindingList bindings = produce.getBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            OutputBinding binding = bindings.outputBindingAt(i);
            Output output = binding.getOutput();
            ParameterValue paramValue = binding.getValue();
            if (paramValue instanceof ValueData) {
                values.setValue(output, ((ValueData)paramValue).getData());
                continue;
            }
            if (!(paramValue instanceof ValueOf)) continue;
            ValueOf valueOf = (ValueOf)paramValue;
            Perform otherPerform = valueOf.getPerform();
            Parameter otherParam = valueOf.getParameter();
            ValueMap performResult = (ValueMap)this.performResults.get(otherPerform);
            if (performResult == null) {
                this.executionFailed("Perform " + otherPerform + " cannot be found!");
            }
            values.setValue(output, performResult.getValue(otherParam));
        }
    }

    protected void executeConstruct(ControlConstruct cc) {
        if (cc instanceof Perform) {
            this.executePerform((Perform)cc);
        } else if (cc instanceof Sequence) {
            this.executeSequence((Sequence)cc);
        } else if (cc instanceof AnyOrder) {
            this.executeAnyOrder((AnyOrder)cc);
        } else if (cc instanceof Choice) {
            this.executeChoice((Choice)cc);
        } else if (cc instanceof IfThenElse) {
            this.executeIfThenElse((IfThenElse)cc);
        } else if (cc instanceof RepeatWhile) {
            this.executeRepeatWhile((RepeatWhile)cc);
        } else if (cc instanceof RepeatUntil) {
            this.executeRepeatUntil((RepeatUntil)cc);
        } else if (cc instanceof Split) {
            this.executeParallel(((Split)cc).getComponents(), false);
        } else if (cc instanceof SplitJoin) {
            this.executeParallel(((SplitJoin)cc).getComponents(), true);
        } else if (cc instanceof Produce) {
            this.executeProduce((Produce)cc);
        } else if (cc instanceof ForEach) {
            this.executeForEach((ForEach)cc);
        } else {
            this.executionFailed("Unknown control construct " + cc.getConstructName() + "!");
        }
    }

    protected void executeSequence(Sequence cc) {
        ControlConstructList ccList = cc.getComponents();
        for (int i = 0; i < ccList.size(); ++i) {
            ControlConstruct component = ccList.constructAt(i);
            this.executeConstruct(component);
        }
    }

    protected void executeAnyOrder(AnyOrder cc) {
        ControlConstructBag ccList = cc.getComponents();
        OWLIndividualList list = ccList.getAll();
        for (int i = 0; i < list.size(); ++i) {
            ControlConstruct component = (ControlConstruct)list.individualAt(i);
            this.executeConstruct(component);
        }
    }

    protected void executeChoice(Choice choice) {
        ControlConstructBag ccList = choice.getComponents();
        int size = ccList.size();
        int index = new Random().nextInt(size);
        ControlConstruct component = ccList.constructAt(index);
        this.executeConstruct(component);
    }

    protected void executeIfThenElse(IfThenElse ifThenElse) {
        Condition ifCondition = ifThenElse.getCondition();
        ControlConstruct thenCC = ifThenElse.getThen();
        ControlConstruct elseCC = ifThenElse.getElse();
        if (this.isTrue(ifCondition)) {
            this.executeConstruct(thenCC);
        } else if (elseCC != null) {
            this.executeConstruct(elseCC);
        }
    }

    protected void executeRepeatWhile(RepeatWhile cc) {
        Condition whileCondition = cc.getCondition();
        ControlConstruct loopBody = cc.getComponent();
        while (this.isTrue(whileCondition)) {
            this.executeConstruct(loopBody);
        }
    }

    protected void executeRepeatUntil(RepeatUntil cc) {
        Condition repeatCondition = cc.getCondition();
        ControlConstruct loopBody = cc.getComponent();
        do {
            this.executeConstruct(loopBody);
        } while (!this.isTrue(repeatCondition));
    }

    protected void executeForEach(ForEach cc) {
        ValueMap parentValues = (ValueMap)this.performResults.get(OWLS_1_1.Process.TheParentPerform);
        ControlConstruct loopBody = cc.getComponent();
        Local loopVar = cc.getLoopVar();
        ValueOf valueOf = cc.getListValue();
        Perform otherPerform = valueOf.getPerform();
        Parameter otherParam = valueOf.getParameter();
        ValueMap performResult = (ValueMap)this.performResults.get(otherPerform);
        if (performResult == null) {
            this.executionFailed("Perform " + otherPerform + " cannot be found!");
        }
        OWLIndividual ind = performResult.getIndividualValue(otherParam);
        RDFList list = (RDFList)ind.castTo(OWLSObjList.class);
        while (!list.isEmpty()) {
            OWLIndividual value = list.getFirst();
            parentValues.setValue(loopVar, value);
            this.executeConstruct(loopBody);
            list = list.getRest();
        }
    }

    protected void checkPreconditions(Process process, ValueMap values) {
        ParameterList locals = process.getLocals();
        Iterator i = process.getConditions().iterator();
        while (i.hasNext()) {
            Condition cond = (Condition)i.next();
            if (DEBUG) {
                System.out.println("Values=" + values);
            }
            AtomList atoms = cond.getBody();
            if (DEBUG) {
                System.out.println("Atoms = " + atoms);
            }
            if (atoms == null) continue;
            atoms = atoms.apply(values);
            if (DEBUG) {
                System.out.println("Atoms = " + atoms);
            }
            ABoxQuery query = atoms.toQuery(locals);
            if (DEBUG) {
                System.out.println("Query = " + query);
            }
            List results = this.env.query(query);
            if (DEBUG) {
                System.out.println("Query Results = " + results);
            }
            if (results.isEmpty()) {
                this.executionFailed(new UnsatisfiedPreconditionException(process, cond));
            } else if (results.size() > 1 && !this.allowMultipleSatisifedPreconditions) {
                this.executionFailed(new MultipleSatisfiedPreconditionException(process, cond));
            }
            ValueMap result = (ValueMap)results.get(0);
            values.addMap(result);
        }
    }

    protected boolean isTrue(Condition condition) {
        ValueMap binding = (ValueMap)this.performResults.get(OWLS_1_1.Process.TheParentPerform);
        return condition.isTrue(this.env, binding);
    }

    protected boolean isTrue(Condition condition, ValueMap binding) {
        return condition.isTrue(this.env, binding);
    }

    protected void executeParallel(ControlConstructBag ccList, boolean join) {
        int i;
        ProcessExecutionThread[] threads = new ProcessExecutionThread[ccList.size()];
        for (i = 0; i < ccList.size(); ++i) {
            ControlConstruct construct = ccList.constructAt(i);
            threads[i] = new ProcessExecutionThread(construct);
            if (DEBUG) {
                System.out.println("Starting " + construct + "...");
            }
            threads[i].start();
        }
        if (join) {
            for (i = 0; i < threads.length; ++i) {
                try {
                    if (DEBUG) {
                        System.out.println("Waiting " + threads[i].cc + " to finish...");
                    }
                    threads[i].join();
                    if (!DEBUG) continue;
                    System.out.println(threads[i].cc + " finished");
                    continue;
                }
                catch (InterruptedException e) {
                    this.notifyListeners("[ERROR]\n");
                    this.notifyListeners("Execution Stopped\n");
                    this.finishExecution(-2);
                    this.executionFailed(e);
                }
            }
        }
    }

    class ProcessExecutionThread
    extends Thread {
        ControlConstruct cc;

        ProcessExecutionThread(ControlConstruct cc) {
            this.cc = cc;
        }

        public void run() {
            ProcessExecutionEngineImpl.this.executeConstruct(this.cc);
        }
    }
}

