/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.execution;

import impl.owls.process.execution.ProcessExecutionEngineImpl;
import java.util.Iterator;
import java.util.Vector;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.list.RDFList;
import org.mindswap.owls.generic.list.OWLSObjList;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructBag;
import org.mindswap.owls.process.ControlConstructList;
import org.mindswap.owls.process.ForEach;
import org.mindswap.owls.process.Local;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.ValueOf;
import org.mindswap.owls.process.execution.ThreadedProcessExecutionEngine;
import org.mindswap.owls.process.execution.ThreadedProcessExecutionListener;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.query.ValueMap;

public class ThreadedProcessExecutionEngineImpl
extends ProcessExecutionEngineImpl
implements Runnable,
ThreadedProcessExecutionEngine {
    private static final int DEFAULT_INTERVAL = 5000;
    private boolean resultReady = false;
    private boolean interrupted = false;
    private int interval = 5000;
    private Process process = null;
    private ValueMap values = null;
    private ValueMap resultMap = null;
    private String processName;
    private Vector execListener = new Vector();

    public void run() {
        this.executionHasStarted();
        this.setResultMap(super.execute(this.process, this.values));
    }

    public void executeThreaded(Process p, ValueMap values) {
        this.process = p;
        this.processName = p.getName();
        if (this.processName == null) {
            this.processName = p.getLocalName();
        }
        this.values = values;
        this.execAsynchronous();
    }

    public void execAsynchronous() {
        this.setResultReady(false);
        Thread threadedExec = new Thread(this);
        threadedExec.start();
    }

    protected void executeSequence(Sequence cc) {
        ControlConstructList ccList = cc.getComponents();
        for (int i = 0; i < ccList.size(); ++i) {
            ControlConstruct component = ccList.constructAt(i);
            if (this.isInterrupted()) {
                this.processInterruption();
            }
            this.executeConstruct(component);
        }
    }

    protected void executeAnyOrder(AnyOrder cc) {
        ControlConstructBag ccList = cc.getComponents();
        OWLIndividualList list = ccList.getAll();
        for (int i = 0; i < list.size(); ++i) {
            ControlConstruct component = (ControlConstruct)list.individualAt(i);
            if (this.isInterrupted()) {
                this.processInterruption();
            }
            this.executeConstruct(component);
        }
    }

    protected void executeForEach(ForEach cc) {
        ValueMap parentValues = (ValueMap)this.performResults.get(OWLS_1_1.Process.TheParentPerform);
        ControlConstruct loopBody = cc.getComponent();
        Local loopVar = cc.getLoopVar();
        ValueOf valueOf = cc.getListValue();
        Perform otherPerform = valueOf.getPerform();
        Parameter otherParam = valueOf.getParameter();
        ValueMap performResult = (ValueMap)this.performResults.get(otherPerform);
        if (performResult == null) {
            throw new ExecutionException("Perform " + otherPerform + " cannot be found!");
        }
        OWLIndividual ind = performResult.getIndividualValue(otherParam);
        RDFList list = (RDFList)ind.castTo(OWLSObjList.class);
        while (!list.isEmpty()) {
            OWLIndividual value = list.getFirst();
            parentValues.setValue(loopVar, value);
            if (this.isInterrupted()) {
                this.processInterruption();
            }
            this.executeConstruct(loopBody);
            list = list.getRest();
        }
    }

    protected void executeRepeatUntil(RepeatUntil cc) {
        Condition whileCondition = cc.getCondition();
        ControlConstruct loopBody = cc.getComponent();
        do {
            if (this.isInterrupted()) {
                this.processInterruption();
            }
            this.executeConstruct(loopBody);
        } while (this.isTrue(whileCondition));
    }

    protected void executeRepeatWhile(RepeatWhile cc) {
        Condition whileCondition = cc.getCondition();
        ControlConstruct loopBody = cc.getComponent();
        while (this.isTrue(whileCondition)) {
            if (this.isInterrupted()) {
                this.processInterruption();
            }
            this.executeConstruct(loopBody);
        }
    }

    protected ValueMap executeAtomicProcess(AtomicProcess process, ValueMap values) {
        this.atomicProcessStarted(process);
        ValueMap result = super.executeAtomicProcess(process, values);
        this.atomicProcessEnded(process);
        return result;
    }

    protected ValueMap executePerform(Perform p) {
        ValueMap values = super.executePerform(p);
        Iterator iter = values.getVariables().iterator();
        while (iter.hasNext()) {
            Parameter param = (Parameter)iter.next();
            if (!param.isIndividual()) continue;
            this.parameterValueSet(param, values.getStringValue(param));
        }
        return values;
    }

    public void continueExec() {
        this.setInterrupted(false);
        this.executionContinued();
    }

    public void interruptExec() {
        this.interruptExec(5000);
    }

    public void interruptExec(int millisToSleep) {
        this.setInterrupted(true);
        this.setInterval(millisToSleep);
        this.executionInterrupted();
    }

    protected boolean isInterrupted() {
        return this.interrupted;
    }

    protected void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    protected void setResultMap(ValueMap results) {
        if (results != null) {
            this.resultMap = results;
            this.setResultReady(true);
        }
    }

    public ValueMap getResultMap() {
        this.setResultReady(false);
        return this.resultMap;
    }

    public boolean isResultReady() {
        return this.resultReady;
    }

    public void setResultReady(boolean resultState) {
        this.resultReady = resultState;
        if (resultState) {
            this.executionHasFinished();
        }
    }

    private void processInterruption() {
        while (this.isInterrupted()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void executionInterrupted() {
        Object[] listeners = this.execListener.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ThreadedProcessExecutionListener)listeners[i]).executionInterrupted(this.process);
        }
    }

    protected void executionContinued() {
        Object[] listeners = this.execListener.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ThreadedProcessExecutionListener)listeners[i]).executionContinued(this.process);
        }
    }

    protected void atomicProcessStarted(AtomicProcess atomicProcess) {
        Object[] listeners = this.execListener.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ThreadedProcessExecutionListener)listeners[i]).atomicProcessStarted(atomicProcess);
        }
    }

    protected void atomicProcessEnded(AtomicProcess atomicProcess) {
        Object[] listeners = this.execListener.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ThreadedProcessExecutionListener)listeners[i]).atomicProcessEnded(atomicProcess);
        }
    }

    protected void parameterValueSet(Parameter param, String value) {
        Object[] listeners = this.execListener.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ThreadedProcessExecutionListener)listeners[i]).parameterValueSet(this.process, param, value);
        }
    }

    protected void executionHasFinished() {
        Object[] listeners = this.execListener.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ThreadedProcessExecutionListener)listeners[i]).executionFinished(this.process);
        }
    }

    protected void executionHasStarted() {
        Object[] listeners = this.execListener.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ThreadedProcessExecutionListener)listeners[i]).executionStarted(this.process);
        }
    }

    public synchronized void addExecutionListener(ThreadedProcessExecutionListener listener) {
        this.execListener.add(listener);
    }

    public synchronized void removeExecutionListener(ThreadedProcessExecutionListener listener) {
        this.execListener.remove(listener);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String getProcessName() {
        return this.processName;
    }
}

