/*
 * Decompiled with CFR 0.152.
 */
package impl.swrl;

import impl.swrl.AtomImpl;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.RDFList;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLObject;

public class BuiltinAtomImpl
extends AtomImpl
implements BuiltinAtom {
    private static final Set THREE_ARGS = new HashSet();

    public BuiltinAtomImpl(OWLIndividual ind) {
        super(ind);
    }

    public OWLIndividual getBuiltin() {
        return this.getProperty(SWRL.builtin);
    }

    public void setBuiltin(OWLIndividual builtin) {
        this.setProperty(SWRL.builtin, builtin);
    }

    public int getArgumentCount() {
        if (THREE_ARGS.contains(this.getBuiltin())) {
            return 3;
        }
        return 2;
    }

    private RDFList getArguments() {
        OWLIndividual args = this.getProperty(SWRL.arguments);
        return args == null ? null : (RDFList)args.castTo(RDFList.class);
    }

    public SWRLObject getArgument(int index) {
        RDFList args = this.getArguments();
        if (args == null) {
            return null;
        }
        OWLValue arg = args.getValue(index);
        if (arg == null) {
            return null;
        }
        return (SWRLDataObject)arg.castTo(SWRLDataObject.class);
    }

    public void addArgument(SWRLObject arg) {
        if (!(arg instanceof SWRLDataObject)) {
            throw new IllegalArgumentException("BuiltinAtom argument should be a SWRLDataObject");
        }
        RDFList args = this.getArguments();
        if (args == null) {
            RDFList nil = this.getOntology().createList(RDF.ListVocabulary);
            args = nil.insert(arg);
            this.setProperty(SWRL.arguments, args);
        } else {
            args.add(arg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setArgument(int index, SWRLObject arg) {
        if (!(arg instanceof SWRLDataObject)) {
            throw new IllegalArgumentException("BuiltinAtom argument should be a SWRLDataObject");
        }
        RDFList args = this.getArguments();
        if (args == null) {
            if (index != 0) throw new IndexOutOfBoundsException();
            RDFList nil = this.getOntology().createList(RDF.ListVocabulary);
            args = nil.insert(arg);
            this.setProperty(SWRL.arguments, args);
            return;
        } else {
            args.set(index, arg);
        }
    }

    public String toString() {
        OWLIndividual builtin = this.getBuiltin();
        if (builtin == null) {
            return "Missing_class_predicate";
        }
        StringBuffer str = new StringBuffer();
        if (builtin.equals(SWRLB.equal)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" = ");
            str.append(this.getArgument(1));
            str.append(")");
        } else if (builtin.equals(SWRLB.lessThan)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" < ");
            str.append(this.getArgument(1));
            str.append(")");
        } else if (builtin.equals(SWRLB.greaterThan)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" > ");
            str.append(this.getArgument(1));
            str.append(")");
        } else if (builtin.equals(SWRLB.add)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" = ");
            str.append(this.getArgument(1));
            str.append(" + ");
            str.append(this.getArgument(2));
            str.append(")");
        } else if (builtin.equals(SWRLB.subtract)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" = ");
            str.append(this.getArgument(1));
            str.append(" - ");
            str.append(this.getArgument(2));
            str.append(")");
        } else {
            str.append(builtin.getLocalName()).append("(");
            for (int i = 0; i < this.getArgumentCount(); ++i) {
                SWRLObject arg = this.getArgument(i);
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arg);
            }
            str.append(")");
        }
        return str.toString();
    }

    static {
        THREE_ARGS.add(SWRLB.add);
        THREE_ARGS.add(SWRLB.subtract);
        THREE_ARGS.add(SWRLB.multiply);
        THREE_ARGS.add(SWRLB.divide);
    }
}

