/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl;

import java.net.URI;
import java.util.Map;
import org.mindswap.owl.OWLDataValueList;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.OWLWriter;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.query.ABoxQueryParser;

public class OWLFactory {
    private static OWLKnowledgeBase kb;
    private static OWLOntology owlsService;
    private static OWLOntology owlsProfile;
    private static OWLOntology owlsGrounding;
    private static OWLOntology owlsProcess;
    private static String[] implementations;
    private static Interface factory;

    private static Interface createFactory() {
        for (int i = 0; factory == null && i < implementations.length; ++i) {
            try {
                Class<?> impl = Class.forName(implementations[i]);
                factory = (Interface)impl.newInstance();
                continue;
            }
            catch (Exception e) {
                System.err.println("Cannot create OWLFactory!");
                e.printStackTrace();
            }
        }
        return factory;
    }

    public static OWLKnowledgeBase createKB() {
        return factory.createKB();
    }

    public static OWLOntology createOntology() {
        return OWLFactory.createOntology(false);
    }

    public static OWLOntology createOntology(URI uri) {
        return OWLFactory.createOntology(uri, false);
    }

    public static OWLOntology createOntology(boolean importOWLS) {
        OWLOntology ont = factory.createOntology();
        if (importOWLS) {
            OWLFactory.addOWLSImports(ont);
        }
        return ont;
    }

    public static OWLOntology createOntology(URI uri, boolean importOWLS) {
        OWLOntology ont = factory.createOntology(uri);
        if (importOWLS) {
            OWLFactory.addOWLSImports(ont);
        }
        return ont;
    }

    public static void addOWLSImports(OWLOntology ont) {
        OWLFactory.loadOWLSOntologies();
        ont.addImport(owlsService);
        ont.addImport(owlsProfile);
        ont.addImport(owlsProcess);
        ont.addImport(owlsGrounding);
    }

    private static void loadOWLSOntologies() {
        if (kb == null) {
            kb = OWLFactory.createKB();
            try {
                owlsService = kb.read(OWLS_1_1.Service.URI);
                owlsProfile = kb.read(OWLS_1_1.Profile.URI);
                owlsProcess = kb.read(OWLS_1_1.Process.URI);
                owlsGrounding = kb.read(OWLS_1_1.Grounding.URI);
            }
            catch (Exception e) {
                owlsService = kb.createOntology(URI.create(OWLS_1_1.Service.URI));
                owlsProfile = kb.createOntology(URI.create(OWLS_1_1.Profile.URI));
                owlsProcess = kb.createOntology(URI.create(OWLS_1_1.Process.URI));
                owlsGrounding = kb.createOntology(URI.create(OWLS_1_1.Grounding.URI));
            }
        }
    }

    public static OWLReader createReader() {
        return factory.createReader();
    }

    public static OWLWriter createWriter() {
        return factory.createWriter();
    }

    public static OWLDataValueList createDataValueList() {
        return factory.createDataValueList();
    }

    public static OWLIndividualList createIndividualList() {
        return factory.createIndividualList();
    }

    public static Map getReasoners() {
        return factory.getReasoners();
    }

    public static Object getReasoner(String reasonerName) {
        return factory.getReasoner(reasonerName);
    }

    public static ABoxQueryParser createRDQLParser(OWLModel model) {
        return factory.createRDQLParser(model);
    }

    public static Map getDefaultConverters() {
        return factory.getDefaultConverters();
    }

    static {
        implementations = new String[]{"impl.jena.JenaOWLFactory"};
        factory = OWLFactory.createFactory();
    }

    public static interface Interface {
        public Map getReasoners();

        public Object getReasoner(String var1);

        public OWLKnowledgeBase createKB();

        public OWLOntology createOntology();

        public OWLOntology createOntology(URI var1);

        public OWLReader createReader();

        public OWLWriter createWriter();

        public OWLDataValueList createDataValueList();

        public OWLIndividualList createIndividualList();

        public ABoxQueryParser createRDQLParser(OWLModel var1);

        public Map getDefaultConverters();
    }
}

