/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls;

import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owls.grounding.AtomicGroundingList;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.process.BindingList;
import org.mindswap.owls.process.ConditionList;
import org.mindswap.owls.process.InputBindingList;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.OutputBindingList;
import org.mindswap.owls.process.OutputList;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.ProcessList;
import org.mindswap.owls.process.ResultList;

public class OWLSListFactory {
    private static String[] implementations = new String[]{"impl.owls.OWLSListFactoryImpl"};
    private static Interface factory = OWLSListFactory.createFactory();

    private static Interface createFactory() {
        for (int i = 0; factory == null && i < implementations.length; ++i) {
            try {
                Class<?> impl = Class.forName(implementations[i]);
                factory = (Interface)impl.newInstance();
                continue;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return factory;
    }

    public static AtomicGroundingList createAtomicGroundingList() {
        return factory.createAtomicGroundingList();
    }

    public static AtomicGroundingList createAtomicGroundingList(OWLIndividualList list) {
        return factory.createAtomicGroundingList(list);
    }

    public static BindingList createBindingList() {
        return factory.createBindingList();
    }

    public static BindingList createBindingList(OWLIndividualList list) {
        return factory.createBindingList(list);
    }

    public static ConditionList createConditionList() {
        return factory.createConditionList();
    }

    public static ConditionList createConditionList(OWLIndividualList list) {
        return factory.createConditionList(list);
    }

    public static InputBindingList createInputBindingList() {
        return factory.createInputBindingList();
    }

    public static InputBindingList createInputBindingList(OWLIndividualList list) {
        return factory.createInputBindingList(list);
    }

    public static InputList createInputList() {
        return factory.createInputList();
    }

    public static InputList createInputList(OWLIndividualList list) {
        return factory.createInputList(list);
    }

    public static MessageMapList createMessageMapList() {
        return factory.createMessageMapList();
    }

    public static MessageMapList createMessageMapList(OWLIndividualList list) {
        return factory.createMessageMapList(list);
    }

    public static OutputBindingList createOutputBindingList() {
        return factory.createOutputBindingList();
    }

    public static OutputBindingList createOutputBindingList(OWLIndividualList list) {
        return factory.createOutputBindingList(list);
    }

    public static OutputList createOutputList() {
        return factory.createOutputList();
    }

    public static OutputList createOutputList(OWLIndividualList list) {
        return factory.createOutputList(list);
    }

    public static ParameterList createParameterList() {
        return factory.createParameterList();
    }

    public static ParameterList createParameterList(OWLIndividualList list) {
        return factory.createParameterList(list);
    }

    public static ProcessList createProcessList() {
        return factory.createProcessList();
    }

    public static ProcessList createProcessList(OWLIndividualList list) {
        return factory.createProcessList(list);
    }

    public static ResultList createResultList() {
        return factory.createResultList();
    }

    public static ResultList createResultList(OWLIndividualList list) {
        return factory.createResultList(list);
    }

    public static OWLIndividualList wrapList(OWLIndividualList list, Class castTarget) {
        return factory.wrapList(list, castTarget);
    }

    public static interface Interface {
        public AtomicGroundingList createAtomicGroundingList();

        public AtomicGroundingList createAtomicGroundingList(OWLIndividualList var1);

        public BindingList createBindingList();

        public BindingList createBindingList(OWLIndividualList var1);

        public ConditionList createConditionList();

        public ConditionList createConditionList(OWLIndividualList var1);

        public InputBindingList createInputBindingList();

        public InputBindingList createInputBindingList(OWLIndividualList var1);

        public InputList createInputList();

        public InputList createInputList(OWLIndividualList var1);

        public MessageMapList createMessageMapList();

        public MessageMapList createMessageMapList(OWLIndividualList var1);

        public OutputBindingList createOutputBindingList();

        public OutputBindingList createOutputBindingList(OWLIndividualList var1);

        public OutputList createOutputList();

        public OutputList createOutputList(OWLIndividualList var1);

        public ParameterList createParameterList();

        public ParameterList createParameterList(OWLIndividualList var1);

        public ProcessList createProcessList();

        public ProcessList createProcessList(OWLIndividualList var1);

        public ResultList createResultList();

        public ResultList createResultList(OWLIndividualList var1);

        public OWLIndividualList wrapList(OWLIndividualList var1, Class var2);
    }
}

