/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.owls.io.BaseExpressionWriter;
import org.mindswap.owls.io.ExpressionWriter;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SameIndividualAtom;

public class PresentationSyntaxExpressionWriter
extends BaseExpressionWriter
implements ExpressionWriter {
    static final Map SYMBOLS = new HashMap();

    public void write(AtomList atoms) {
        if (atoms == null) {
            this.out.print("<No-Condition-Specified>");
            return;
        }
        boolean first = true;
        Iterator it = atoms.iterator();
        while (it.hasNext()) {
            if (!first || this.firstLineIndent) {
                this.out.print(this.indent);
            } else {
                first = false;
            }
            this.write((Atom)it.next());
            if (!it.hasNext()) continue;
            this.out.println(" &");
        }
    }

    public void write(ClassAtom atom) {
        this.print(atom.getClassPredicate());
        this.out.print("(");
        this.print(atom.getArgument1());
        this.out.print(")");
    }

    public void write(IndividualPropertyAtom atom) {
        this.print(atom.getPropertyPredicate());
        this.out.print("(");
        this.print(atom.getArgument1());
        this.out.print(", ");
        this.print(atom.getArgument2());
        this.out.print(")");
    }

    public void write(DataPropertyAtom atom) {
        this.print(atom.getPropertyPredicate());
        this.out.print("(");
        this.print(atom.getArgument1());
        this.out.print(", ");
        this.print(atom.getArgument2());
        this.out.print(")");
    }

    public void write(SameIndividualAtom atom) {
        this.out.print("(");
        this.print(atom.getArgument1());
        this.out.print(" = ");
        this.print(atom.getArgument2());
        this.out.print(")");
    }

    public void write(DifferentIndividualsAtom atom) {
        this.out.print("~(");
        this.print(atom.getArgument1());
        this.out.print(" = ");
        this.print(atom.getArgument2());
        this.out.print(")");
    }

    public void write(BuiltinAtom atom) {
        OWLIndividual builtin = atom.getBuiltin();
        int count = atom.getArgumentCount();
        String[] symbols = (String[])SYMBOLS.get(builtin);
        if (symbols != null) {
            int extra = 0;
            if (symbols.length == count) {
                this.out.print(symbols[0]);
                extra = 1;
            }
            this.out.print("(");
            for (int i = 0; i < count; ++i) {
                this.out.print(atom.getArgument(i));
                if (i >= count - 1) continue;
                this.out.print(" " + symbols[i + extra] + " ");
            }
            this.out.print(")");
        } else {
            this.print(builtin);
            this.out.print("(");
            for (int i = 0; i < atom.getArgumentCount(); ++i) {
                if (i > 0) {
                    this.out.print(", ");
                }
                this.print(atom.getArgument(0));
            }
            this.out.print(")");
        }
    }

    static {
        SYMBOLS.put(SWRLB.add, new String[]{"=", "+"});
        SYMBOLS.put(SWRLB.subtract, new String[]{"=", "-"});
        SYMBOLS.put(SWRLB.divide, new String[]{"=", "+"});
        SYMBOLS.put(SWRLB.multiply, new String[]{"=", "*"});
        SYMBOLS.put(SWRLB.lessThan, new String[]{"<"});
        SYMBOLS.put(SWRLB.lessThanOrEqual, new String[]{"<="});
        SYMBOLS.put(SWRLB.greaterThan, new String[]{">"});
        SYMBOLS.put(SWRLB.greaterThanOrEqual, new String[]{">="});
        SYMBOLS.put(SWRLB.equal, new String[]{"="});
        SYMBOLS.put(SWRLB.notEqual, new String[]{"~", "="});
    }
}

