/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.vocabulary.XSD;
import org.mindswap.owls.generic.expression.Expression;
import org.mindswap.owls.generic.list.OWLSObjList;
import org.mindswap.owls.io.ExpressionWriter;
import org.mindswap.owls.io.PresentationSyntaxExpressionWriter;
import org.mindswap.owls.io.ProcessWriter;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Binding;
import org.mindswap.owls.process.BindingList;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ConditionList;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.InputBindingList;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputBindingList;
import org.mindswap.owls.process.OutputList;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.ParameterValue;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.ResultList;
import org.mindswap.owls.process.ResultVar;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.ValueData;
import org.mindswap.owls.process.ValueOf;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.swrl.AtomList;
import org.mindswap.utils.QNameProvider;

public class PresentationSyntaxWriter
implements ProcessWriter {
    private static final String INDENT = "   ";
    private String indent = "";
    private QNameProvider qnames = new QNameProvider();
    private PrintWriter out;
    private Writer writer;
    private PresentationSyntaxExpressionWriter exprWriter;
    private String defaultNS;

    public PresentationSyntaxWriter() {
        this.init();
    }

    public String getDefaultNS() {
        return this.defaultNS;
    }

    public void setDefaultNS(String defaultNS) {
        this.defaultNS = defaultNS.endsWith("#") ? defaultNS : defaultNS + "#";
    }

    public void init() {
        this.exprWriter = new PresentationSyntaxExpressionWriter();
    }

    private String qname(OWLEntity entity) {
        if (entity.isAnon()) {
            return "<< Anonymous " + (entity instanceof OWLClass ? "Class" : "Individual") + " >>";
        }
        return this.qnames.shortForm(entity.getURI());
    }

    private String qname(URI uri) {
        try {
            return this.qnames.shortForm(uri);
        }
        catch (Exception e) {
            return "<< Invalid URI >>";
        }
    }

    private void indent(boolean left) {
        this.indent = left ? this.indent + INDENT : this.indent.substring(INDENT.length());
    }

    private void printIndented() {
        this.out.print(this.indent);
    }

    private void printIndented(String str) {
        this.printIndented();
        this.out.print(str);
    }

    private void printlnIndented(String str) {
        this.printIndented();
        this.out.println(str);
    }

    private String repeat(char c, int n) {
        char[] chars = new char[n];
        Arrays.fill(chars, c);
        return String.copyValueOf(chars);
    }

    private void block(boolean start) {
        if (start) {
            this.printlnIndented("{");
            this.indent(true);
        } else {
            this.indent(false);
            this.printIndented("}");
        }
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(OutputStream stream) {
        this.setWriter(new OutputStreamWriter(stream));
    }

    public void write(Process process, OutputStream stream) {
        this.setWriter(stream);
        this.write(process);
    }

    public void write(Process process, Writer writer) {
        this.setWriter(writer);
        this.write(process);
    }

    public void write(Process process) {
        this.write(Collections.singleton(process));
    }

    public void write(Collection processes) {
        if (this.defaultNS != null) {
            this.qnames.setMapping("", this.defaultNS);
        }
        StringWriter buffer = new StringWriter();
        this.out = new PrintWriter(buffer);
        this.exprWriter.setWriter(this.out);
        this.exprWriter.setIndent("");
        this.exprWriter.setQNames(this.qnames);
        this.indent(true);
        Iterator i = processes.iterator();
        while (i.hasNext()) {
            Process process = (Process)i.next();
            this.writeProcess(process);
        }
        this.indent(false);
        this.out.flush();
        this.out = new PrintWriter(this.writer);
        this.writeHeader();
        this.out.println(buffer.toString());
        this.writeFooter();
        this.out.flush();
    }

    public void writeHeader() {
        this.out.println("with_namespaces");
        HashSet prefixSet = new HashSet(this.qnames.getPrefixSet());
        String defaultNS = this.qnames.getURI("");
        if (defaultNS != null) {
            this.out.println("  (uri\"" + defaultNS + "\",");
            prefixSet.remove("");
        }
        Iterator i = prefixSet.iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = this.qnames.getURI(prefix);
            this.out.print(INDENT + prefix + ":  \"" + uri + "\"");
            if (i.hasNext()) {
                this.out.println(",");
                continue;
            }
            this.out.println(")");
        }
        this.out.println("{");
        this.out.println();
    }

    public void writeFooter() {
        this.out.println("}");
    }

    private boolean emptyProcess(Process process) {
        return process.getInputs().isEmpty() && process.getLocals().isEmpty() && process.getOutputs().isEmpty() && process.getConditions().isEmpty() && process.getResults().isEmpty();
    }

    private void writeProcess(Process process) {
        if (process instanceof AtomicProcess) {
            this.writeProcess((AtomicProcess)process);
        } else if (process instanceof CompositeProcess) {
            this.writeProcess((CompositeProcess)process);
        } else {
            throw new RuntimeException("Only writing Atomic and Composite process implemented yet");
        }
        this.out.println();
    }

    private void writeProcess(CompositeProcess process) {
        this.printIndented("define composite process ");
        this.out.print(process.getLocalName() + "(");
        if (!this.emptyProcess(process)) {
            this.out.println();
            this.writeIO(process);
            this.writePreconditions(process);
            this.writeResults(process);
        }
        this.out.println(")");
        ControlConstruct cc = process.getComposedOf();
        if (cc != null) {
            this.writeConstruct(cc, true);
        }
        this.out.println();
    }

    private void writeIO(Process process) {
        OutputList outputs;
        ParameterList locals;
        this.indent(true);
        InputList inputs = process.getInputs();
        if (inputs.size() > 0) {
            this.printIndented("inputs: (");
            for (int i = 0; i < inputs.size(); ++i) {
                Input input = (Input)inputs.get(i);
                OWLType type = input.getParamType();
                this.out.print(this.qname(input));
                this.out.print(" - " + this.qname(type.getURI()));
                if (i < inputs.size() - 1) {
                    this.out.println();
                    this.printIndented("         ");
                    continue;
                }
                this.out.print(")");
            }
        }
        if ((locals = process.getLocals()).size() > 0) {
            this.out.println(",");
            this.printIndented("locals: (");
            for (int i = 0; i < locals.size(); ++i) {
                Parameter local = (Parameter)locals.get(i);
                OWLType type = local.getParamType();
                this.out.print(this.qname(local));
                this.out.print(" - " + this.qname(type.getURI()));
                if (i < locals.size() - 1) {
                    this.out.println();
                    this.printIndented("         ");
                    continue;
                }
                this.out.print(")");
            }
        }
        if ((outputs = process.getOutputs()).size() > 0) {
            this.out.println(",");
            this.printIndented("outputs: (");
            for (int i = 0; i < outputs.size(); ++i) {
                Output output = (Output)outputs.get(i);
                OWLType type = output.getParamType();
                this.out.print(this.qname(output));
                this.out.print(" - " + this.qname(type.getURI()));
                if (i < outputs.size() - 1) {
                    this.out.println();
                    this.printIndented("          ");
                    continue;
                }
                this.out.print(")");
            }
        }
        this.indent(false);
    }

    private void writePerform(Perform perform) {
        Process process = perform.getProcess();
        String str = this.qname(perform) + " :: perform " + this.qname(process) + "(";
        this.printIndented(str);
        InputBindingList bindings = perform.getBindings();
        this.writeBindings(bindings, str.length());
        this.out.print(")");
    }

    private void writeBindings(BindingList bindings, int extraIndent) {
        String pad = this.repeat(' ', extraIndent);
        for (int i = 0; i < bindings.size(); ++i) {
            Binding binding = bindings.bindingAt(i);
            Parameter param = binding.getParameter();
            String mappedValue = "";
            ParameterValue mappedParamValue = binding.getValue();
            if (mappedParamValue instanceof ValueOf) {
                ValueOf valueOf = (ValueOf)mappedParamValue;
                Perform otherPerform = valueOf.getPerform();
                Parameter otherParam = valueOf.getParameter();
                if (!otherPerform.equals(Perform.TheParentPerform)) {
                    mappedValue = this.qname(otherPerform) + ".";
                }
                mappedValue = mappedValue + this.qname(otherParam);
            } else if (mappedParamValue instanceof ValueData) {
                OWLValue value = ((ValueData)mappedParamValue).getData();
                if (value.isDataValue()) {
                    URI datatypeURI = ((OWLDataValue)value).getDatatypeURI();
                    boolean quote = datatypeURI == null || !datatypeURI.equals(XSD.xsdBoolean) && !datatypeURI.equals(XSD.integer) && !datatypeURI.equals(XSD.xsdInt) && !datatypeURI.equals(XSD.decimal) && !datatypeURI.equals(XSD.xsdDouble);
                    mappedValue = ((OWLDataValue)value).toString();
                    if (quote) {
                        mappedValue = "\"" + mappedValue + "\"";
                        if (datatypeURI != null) {
                            mappedValue = mappedValue + "^^" + this.qname(datatypeURI);
                        }
                    }
                } else {
                    mappedValue = this.qname((OWLIndividual)value);
                }
            } else {
                mappedValue = "<< Unknown Binding Type >>";
            }
            this.out.print(this.qname(param) + " <= " + mappedValue);
            if (i >= bindings.size() - 1) continue;
            this.out.print(", ");
            if (bindings.size() <= 1) continue;
            this.out.println();
            this.printIndented();
            this.out.print(pad);
        }
    }

    private void writeConstruct(ControlConstruct cc, boolean block) {
        if (cc instanceof Perform) {
            if (block) {
                this.block(true);
            }
            this.writePerform((Perform)cc);
            if (block) {
                this.out.println();
                this.block(false);
            }
        } else if (cc instanceof Sequence) {
            this.writeComponents(((Sequence)cc).getComponents(), ";");
        } else if (cc instanceof AnyOrder) {
            this.writeComponents(((AnyOrder)cc).getComponents(), "||;");
        } else if (cc instanceof Choice) {
            this.writeComponents(((Choice)cc).getComponents(), ";?");
        } else if (cc instanceof Split) {
            this.writeComponents(((Split)cc).getComponents(), "||<");
        } else if (cc instanceof SplitJoin) {
            this.writeComponents(((SplitJoin)cc).getComponents(), "||>");
        } else if (cc instanceof IfThenElse) {
            if (block) {
                this.block(true);
            }
            this.writeIfThenElse((IfThenElse)cc);
            if (block) {
                this.out.println();
                this.block(false);
            }
        } else if (cc instanceof Produce) {
            if (block) {
                this.block(true);
            }
            this.writeProduce((Produce)cc);
            if (block) {
                this.out.println();
                this.block(false);
            }
        } else {
            this.out.println("<< Unknown Control Construct " + cc.getConstructName() + " >>");
        }
    }

    private void writeComponents(OWLSObjList components, String delim) {
        this.block(true);
        Iterator i = components.iterator();
        while (i.hasNext()) {
            ControlConstruct cc = (ControlConstruct)i.next();
            this.writeConstruct(cc, false);
            if (i.hasNext()) {
                this.out.println(delim);
                continue;
            }
            this.out.println();
        }
        this.block(false);
    }

    private void writeIfThenElse(IfThenElse ifThenElse) {
        Condition condition = ifThenElse.getCondition();
        ControlConstruct thenP = ifThenElse.getThen();
        ControlConstruct elseP = ifThenElse.getElse();
        this.printIndented("if( ");
        this.exprWriter.setIndent(this.indent + "    ");
        this.exprWriter.write(condition.getBody());
        this.out.println(" )");
        this.printlnIndented("then");
        this.writeConstruct(thenP, true);
        if (elseP != null) {
            this.out.println();
            this.printlnIndented("else");
            this.writeConstruct(elseP, true);
        }
    }

    private void writeProduce(Produce produce) {
        OutputBindingList bindings = produce.getBindings();
        if (!bindings.isEmpty()) {
            String str = "produce(";
            this.printIndented(str);
            this.writeBindings(bindings, str.length());
            this.out.print(")");
        }
    }

    private void writeProcess(AtomicProcess process) {
        this.printIndented("define atomic process " + process.getLocalName() + "(");
        if (!this.emptyProcess(process)) {
            this.out.println();
            this.writeIO(process);
            this.writePreconditions(process);
            this.writeResults(process);
        }
        this.out.println(")");
    }

    private void writePreconditions(Process process) {
        this.indent(true);
        ConditionList conditions = process.getConditions();
        for (int i = 0; i < conditions.size(); ++i) {
            this.out.println(",");
            this.printIndented("precondition: (");
            this.exprWriter.setIndent(this.indent + "               ");
            Condition condition = conditions.conditionAt(i);
            AtomList atoms = condition.getBody();
            this.exprWriter.write(atoms);
            this.out.print(")");
        }
        this.indent(false);
    }

    private void writeResults(Process process) {
        this.indent(true);
        ResultList results = process.getResults();
        for (int r = 0; r < results.size(); ++r) {
            Expression effect;
            OutputBindingList bindings;
            Condition condition;
            Result result = results.resultAt(r);
            this.out.println(",");
            this.printIndented("result: (");
            ParameterList resultVars = result.getParameters();
            if (!resultVars.isEmpty()) {
                this.out.print("forall (");
                for (int i = 0; i < resultVars.size(); ++i) {
                    ResultVar resultVar = (ResultVar)resultVars.get(i);
                    OWLType type = resultVar.getParamType();
                    this.out.print(this.qname(resultVar));
                    this.out.print(" - " + this.qname(type.getURI()));
                    if (i < resultVars.size() - 1) {
                        this.out.println();
                        this.printIndented("                 ");
                        continue;
                    }
                    this.out.println(")");
                }
                this.printIndented("         ");
            }
            if ((condition = result.getCondition()) != null && !condition.equals(OWLS_1_1.Expression.AlwaysTrue)) {
                AtomList atoms = condition.getBody();
                this.exprWriter.setIndent("               ");
                this.exprWriter.write(atoms);
                this.out.println();
                this.printlnIndented("         |->");
                this.printIndented("         ");
            }
            if (!(bindings = result.getBindings()).isEmpty()) {
                this.out.print("output(");
                int pad = "result: (".length() + "output(".length();
                this.writeBindings(bindings, pad);
                this.out.print(")");
            }
            if ((effect = result.getEffect()) != null) {
                if (!bindings.isEmpty()) {
                    this.out.println(" & ");
                    this.printIndented("         ");
                }
                AtomList atoms = effect.getBody();
                this.exprWriter.setIndent("               ");
                this.exprWriter.write(atoms);
            }
            this.out.print(")");
        }
        this.indent(false);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public ExpressionWriter getExpressionWriter() {
        return this.exprWriter;
    }

    public void write(Collection processes, Writer out) {
        this.setWriter(out);
        this.write(processes);
    }

    public void write(Collection processes, OutputStream out) {
        this.setWriter(out);
        this.write(processes);
    }

    public QNameProvider getQNames() {
        return this.qnames;
    }

    public void setQNames(QNameProvider qnames) {
        this.qnames = qnames;
    }

    public static void main(String[] args) throws URISyntaxException, IOException {
        OWLConfig.setStrictConversion(false);
        String uri = null;
        uri = "http://www.daml.org/services/owl-s/1.2/CongoProcess.owl";
        PresentationSyntaxWriter writer = new PresentationSyntaxWriter();
        writer.setDefaultNS(uri);
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.read(uri);
        ArrayList processes = new ArrayList();
        processes.addAll(kb.getProcesses(1));
        processes.addAll(kb.getProcesses(2));
        if (processes.isEmpty()) {
            System.err.println("No processes found in the URI");
        } else {
            writer.write(processes, (OutputStream)System.out);
        }
    }
}

