/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.process.execution;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.execution.ProcessMonitor;
import org.mindswap.query.ValueMap;

public class DefaultProcessMonitor
implements ProcessMonitor {
    private PrintWriter out;
    private int monitorFilter = 7;

    public DefaultProcessMonitor() {
        this(new PrintWriter(System.out));
    }

    public DefaultProcessMonitor(Writer writer) {
        this.setWriter(writer);
    }

    public void setWriter(Writer writer) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void executionStarted() {
        this.out.println();
        this.out.flush();
    }

    public void executionFinished() {
        this.out.println();
        this.out.flush();
    }

    public void executionStarted(Process process, ValueMap inputs) {
        this.out.println("Start executing process " + process);
        this.out.println("Inputs: ");
        Iterator i = process.getInputs().iterator();
        while (i.hasNext()) {
            Input input = (Input)i.next();
            this.out.print(input.toPrettyString() + " =  ");
            OWLValue value = inputs.getValue(input);
            if (value == null) {
                value = input.getConstantValue();
            }
            if (value == null) {
                this.out.println("<< NO VALUE >>");
                continue;
            }
            if (value.isDataValue()) {
                this.out.println(value);
                continue;
            }
            OWLIndividual ind = (OWLIndividual)value;
            if (ind.isAnon()) {
                this.out.println(ind.toRDF(false));
                continue;
            }
            this.out.println(value);
        }
        this.out.flush();
    }

    public void executionFinished(Process process, ValueMap inputs, ValueMap outputs) {
        this.out.println("Execution finished for " + process);
        this.out.println("Outputs: ");
        Iterator i = process.getOutputs().iterator();
        while (i.hasNext()) {
            Output output = (Output)i.next();
            this.out.print(output.toPrettyString() + " =  ");
            OWLValue value = outputs.getValue(output);
            if (value == null) {
                this.out.println("<< NO VALUE >>");
                continue;
            }
            if (value.isDataValue()) {
                this.out.println(value);
                continue;
            }
            OWLIndividual ind = (OWLIndividual)value;
            if (ind.isAnon()) {
                this.out.println(ind.toRDF(false));
                continue;
            }
            this.out.println(value);
        }
        this.out.flush();
    }

    public void executionFailed(ExecutionException e) {
        this.out.println("Execution failed: ");
        this.out.println(e);
        this.out.flush();
    }

    public void setMonitorFilter(int processType) {
        this.monitorFilter = processType;
    }

    public int getMonitorFilter() {
        return this.monitorFilter;
    }
}

