/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.process.execution;

import java.io.PrintWriter;
import java.io.Writer;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.execution.ProcessMonitor;
import org.mindswap.query.ValueMap;

public class SimpleProcessMonitor
implements ProcessMonitor {
    private PrintWriter out;
    private int monitorFilter = 7;

    public SimpleProcessMonitor() {
        this(new PrintWriter(System.out));
    }

    public SimpleProcessMonitor(Writer writer) {
        this.setWriter(writer);
    }

    public void setWriter(Writer writer) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void executionStarted() {
        this.out.println();
        this.out.flush();
    }

    public void executionFinished() {
        this.out.println();
        this.out.flush();
    }

    public void executionStarted(Process process, ValueMap inputs) {
        this.out.println("Start executing process " + process);
        this.out.flush();
    }

    public void executionFinished(Process process, ValueMap inputs, ValueMap outputs) {
        this.out.println("Execution finished for " + process);
        this.out.flush();
    }

    public void executionFailed(ExecutionException e) {
        this.out.println("Execution failed: ");
        this.out.println(e);
        this.out.flush();
    }

    public void setMonitorFilter(int processType) {
        this.monitorFilter = processType;
    }

    public int getMonitorFilter() {
        return this.monitorFilter;
    }
}

