/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.shop;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructList;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.OutputList;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.service.Service;
import org.mindswap.utils.QNameProvider;

public class SHOPTranslator {
    private QNameProvider qnames = new QNameProvider();
    private PrintWriter out;
    private List processes;
    private Set written;

    private String getSHOPAbbr(OWLIndividual resource) {
        String s = this.qnames.shortForm(resource.getURI());
        if (resource instanceof AtomicProcess) {
            s = s + "!";
        }
        return s;
    }

    public void write(Service service, OutputStream out) throws IOException {
        this.write(service, new OutputStreamWriter(out, "UTF8"));
    }

    public void write(Service service, Writer writer) {
        this.out = new PrintWriter(writer);
        this.written = new HashSet();
        this.processes = new ArrayList();
        this.processes.add(service.getProcess());
        for (int i = 0; i < this.processes.size(); ++i) {
            this.writeProcess((Process)this.processes.get(i));
        }
    }

    private void writeProcess(Process process) {
        if (process instanceof AtomicProcess) {
            this.writeAtomicProcess((AtomicProcess)process);
        } else if (process instanceof CompositeProcess) {
            this.writeCompositeProcess((CompositeProcess)process);
        }
    }

    private void writeCompositeProcess(CompositeProcess process) {
        ControlConstruct construct = process.getComposedOf();
        if (construct instanceof Sequence) {
            this.writeSequenceProcess(process);
        }
    }

    private Map createValueMap(Process process) {
        HashMap<Parameter, String> valueMap = new HashMap<Parameter, String>();
        InputList inputs = process.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Parameter p = inputs.parameterAt(i);
            valueMap.put(p, this.getSHOPAbbr(p));
        }
        OutputList outputs = process.getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            Parameter p = outputs.parameterAt(i);
            valueMap.put(p, this.getSHOPAbbr(p));
        }
        return valueMap;
    }

    private void writeTask(Process process) {
        this.writeTask(process, new HashMap());
    }

    private void writeTask(Process process, Map valueMap) {
        this.out.print("(" + this.getSHOPAbbr(process) + " ");
        InputList inputs = process.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Parameter p = inputs.parameterAt(i);
            String mappedValue = (String)valueMap.get(p);
            this.out.print(mappedValue + " ");
        }
        OutputList outputs = process.getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            Parameter p = outputs.parameterAt(i);
            String mappedValue = (String)valueMap.get(p);
            this.out.print(mappedValue + " ");
        }
        this.out.println(")");
    }

    private void writeSequenceProcess(CompositeProcess process) {
        this.out.print("(:method");
        this.writeTask(process);
        this.writePreconditions(process);
        Map valueMap = this.createValueMap(process);
        this.out.println("(:ordered");
        Sequence sequence = (Sequence)process.getComposedOf();
        ControlConstructList components = sequence.getComponents();
        for (int i = 0; i < components.size(); ++i) {
            ControlConstruct p = components.constructAt(i);
            if (!(p instanceof Process)) {
                throw new RuntimeException("Cannot handle nested control constructs inside a sequence!");
            }
            this.writeTask((Process)((Object)p), valueMap);
        }
    }

    private void writeAtomicProcess(AtomicProcess process) {
        this.out.print("(");
        this.writeTask(process);
        this.writePreconditions(process);
        this.writeEffects(process);
    }

    private void writePreconditions(Process process) {
        this.out.println("()");
    }

    private void writeEffects(Process process) {
        this.out.println("()");
    }
}

