/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.utils.URIUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Utils {
    public static boolean DEBUG = false;

    public static Object getHashtableKey(Hashtable h, Object value) {
        Iterator e = h.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void printTime(String msg) {
        System.out.println("Time: (" + System.currentTimeMillis() + ") " + msg);
    }

    public static String toString(Object[] array) {
        String s = "[Array ";
        if (array != null && array.length > 0) {
            s = s + array[0];
            for (int i = 1; i < array.length; ++i) {
                s = s + "," + array[i];
            }
        }
        s = s + "]";
        return s;
    }

    public static Node getAsNode(String in) {
        try {
            DOMParser parser = new DOMParser();
            parser.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) {
                    if (DEBUG) {
                        System.err.println(exception);
                    }
                }

                public void error(SAXParseException exception) {
                    if (DEBUG) {
                        System.err.println(exception);
                    }
                }

                public void fatalError(SAXParseException exception) {
                    if (DEBUG) {
                        System.err.println(exception);
                    }
                }
            });
            parser.parse(new InputSource(new StringReader(in)));
            return parser.getDocument().getDocumentElement();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean getBoolean(String str) {
        return str == null ? false : str.toLowerCase().equals("true") || str.equals("1");
    }

    public static String toString(boolean b) {
        return b ? "true" : "false";
    }

    public static String readURL(URL fileURL) throws IOException {
        return Utils.readAll(new InputStreamReader(fileURL.openStream()));
    }

    public static String readFile(String fileName) throws FileNotFoundException, IOException {
        return Utils.readAll(new FileReader(fileName));
    }

    public static String readAll(Reader reader) throws IOException {
        int ch;
        StringBuffer buffer = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        while ((ch = in.read()) > -1) {
            buffer.append((char)ch);
        }
        in.close();
        return buffer.toString();
    }

    public static String formatXML(Node node) {
        try {
            StringWriter out = new StringWriter();
            Document doc = node.getOwnerDocument();
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            format.setLineWidth(0);
            format.setPreserveSpace(false);
            format.setOmitXMLDeclaration(false);
            XMLSerializer serial = new XMLSerializer((Writer)out, format);
            serial.asDOMSerializer();
            serial.serialize(doc);
            return out.toString();
        }
        catch (IOException e) {
            System.err.println("Problem serializing node " + e);
            return "Problem serializing node " + e;
        }
    }

    public static String formatRDF(String rdf) {
        Node node = Utils.getAsNode(rdf);
        if (node == null) {
            return rdf;
        }
        return Utils.formatNode(node, " ").substring(System.getProperty("line.separator").length());
    }

    public static String formatNode(Node node, String indent) {
        String str = "";
        short type = node.getNodeType();
        if (type == 3) {
            str = node.getNodeValue().trim();
        } else if (type == 1) {
            Node rdfResource;
            NodeList children;
            if (!(node.getParentNode() instanceof Document)) {
                str = System.getProperty("line.separator") + indent + node.getLocalName() + ": ";
            }
            int len = (children = node.getChildNodes()) != null ? children.getLength() : 0;
            for (int i = 0; i < len; ++i) {
                str = str + Utils.formatNode(children.item(i), indent + "  ");
            }
            if (len == 0 && (rdfResource = node.getAttributes().getNamedItemNS(RDF.getURI().toString(), "resource")) instanceof Attr) {
                str = str + URIUtils.getLocalName(((Attr)rdfResource).getValue());
            }
        }
        return str;
    }
}

