/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.mindswap.owls.process.Parameter;
import org.mindswap.query.ValueMap;

public class XSLTEngine {
    static final boolean DEBUG = false;
    static final String header = "<?xml";

    public static String transform(String input, String xsltStylesheet) {
        return XSLTEngine.transform(input, xsltStylesheet, new ValueMap());
    }

    public static String transform(String input, String xsltStylesheet, ValueMap parameters) {
        String output = null;
        try {
            StringWriter result = new StringWriter();
            if (xsltStylesheet == null) {
                return input;
            }
            xsltStylesheet = xsltStylesheet.trim();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(new StringReader(xsltStylesheet)));
            Iterator i = parameters.getVariables().iterator();
            while (i.hasNext()) {
                Parameter param = (Parameter)i.next();
                String value = parameters.getStringValue(param);
                transformer.setParameter(param.getLocalName(), value);
                transformer.setParameter(param.getURI().toString(), value);
            }
            transformer.transform(new StreamSource(new StringReader(input)), new StreamResult(result));
            output = result.toString().trim();
            if (output.startsWith(header)) {
                int split = output.indexOf(62) + 1;
                output = output.substring(split);
            }
        }
        catch (Exception e) {
            System.out.println("XSLT Engine cannot apply transformation " + e);
            System.out.println("Input " + input);
            System.out.println("XSLT  " + xsltStylesheet);
        }
        return output;
    }
}

