/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.test;

import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import edu.unika.aifb.rdf.api.syntax.RDFParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.semanticweb.owl.io.ParserException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.man.cs.img.owl.test.OWLTest;
import uk.ac.man.cs.img.owl.test.OWLTestConsumer;
import uk.ac.man.cs.img.owl.test.OWLTestVocabularyAdapter;

public class OWLTestParser {
    public OWLTest parseTest(URI uri) throws ParserException {
        OWLTest test = new OWLTest();
        test.setURI(uri.toString());
        try {
            RDFParser parser = new RDFParser();
            InputSource source = new InputSource(new InputStreamReader(uri.toURL().openStream()));
            source.setSystemId(uri.toString());
            OWLTestConsumer consumer = new OWLTestConsumer(test);
            parser.parse(source, (RDFConsumer)consumer);
        }
        catch (SAXException e) {
            throw new ParserException("Parsing failed due to malformed XML", (Exception)e);
        }
        catch (MalformedURLException e) {
            throw new ParserException("URI is not a valid URL", (Exception)e);
        }
        catch (IOException e) {
            throw new ParserException("Parsing failed due to IO Errors", (Exception)e);
        }
        catch (Exception e) {
            throw new ParserException("Parsing failed due to Errors", e);
        }
        return test;
    }

    public OWLTest parseTest(String base, Reader reader) throws ParserException {
        OWLTest test = new OWLTest();
        try {
            RDFParser parser = new RDFParser();
            InputSource source = new InputSource(reader);
            source.setSystemId(base);
            OWLTestConsumer consumer = new OWLTestConsumer(test);
            parser.parse(source, (RDFConsumer)consumer);
        }
        catch (SAXException e) {
            throw new ParserException("Parsing failed due to malformed XML", (Exception)e);
        }
        catch (MalformedURLException e) {
            throw new ParserException("URI is not a valid URL", (Exception)e);
        }
        catch (IOException e) {
            throw new ParserException("Parsing failed due to IO Errors", (Exception)e);
        }
        catch (Exception e) {
            throw new ParserException("Parsing failed due to Errors", e);
        }
        return test;
    }

    public static void main(String[] args) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(args[0]).openStream()));
            String f = null;
            while ((f = br.readLine()) != null) {
                URI uri;
                OWLTestParser parser;
                OWLTest test;
                if (f.startsWith("#") || !(test = (parser = new OWLTestParser()).parseTest(uri = new URI(f))).getType().equals(OWLTestVocabularyAdapter.INSTANCE.getInconsistencyTest()) || test.getDocumentLevels().get(test.getURI()).equals(OWLTestVocabularyAdapter.INSTANCE.getOWLFull())) continue;
                Iterator it = test.getDocuments().iterator();
                while (it.hasNext()) {
                    Object doc = it.next();
                    if (!test.getDocumentRoles().get(doc).equals(OWLTestVocabularyAdapter.INSTANCE.getInputDocument())) continue;
                    System.out.println(doc);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

