/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import java.math.BigInteger;
import org.mindswap.pellet.datatypes.AbstractDateTimeValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;
import org.relaxng.datatype.DatatypeException;

public class XSDDay
extends BaseXSDAtomicType
implements AtomicDatatype,
XSDAtomicType {
    private static XSDatatype dt = null;
    private static IDateTimeValueType min = null;
    private static IDateTimeValueType max = null;
    private static final ValueSpace DAY_VALUE_SPACE;
    public static XSDDay instance;

    protected XSDDay(ATermAppl name) {
        super(name, DAY_VALUE_SPACE);
    }

    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDDay type = new XSDDay(null);
        type.values = intervals;
        return type;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"gDay");
            min = (IDateTimeValueType)dt.createValue("---01", null);
            max = (IDateTimeValueType)dt.createValue("---31", null);
        }
        catch (DatatypeException e) {
            e.printStackTrace();
        }
        DAY_VALUE_SPACE = new DayValueSpace();
        instance = new XSDDay(ATermUtils.makeTermAppl((String)"http://www.w3.org/2001/XMLSchema#gDay"));
    }

    private static class DayValueSpace
    extends AbstractDateTimeValueSpace
    implements ValueSpace {
        public DayValueSpace() {
            super(min, max, dt);
        }

        public int count(Object start, Object end) {
            BigDateTimeValueType calendarStart = ((IDateTimeValueType)start).getBigValue();
            BigDateTimeValueType calendarEnd = ((IDateTimeValueType)end).getBigValue();
            return calendarEnd.getDay() - calendarStart.getDay() + 1;
        }

        public Object succ(Object value, int n) {
            BigInteger bigN = new BigInteger(String.valueOf(n));
            BigTimeDurationValueType nDays = new BigTimeDurationValueType(NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, bigN, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.DECIMAL_ZERO);
            IDateTimeValueType s = ((IDateTimeValueType)value).add((ITimeDurationValueType)nDays);
            return s;
        }
    }
}

