/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.mindswap.pellet.datatypes.AbstractValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;
import org.relaxng.datatype.DatatypeException;

public class XSDFloat
extends BaseXSDAtomicType
implements AtomicDatatype {
    private static XSDatatype dt = null;
    private static final Object min;
    private static final Object zero;
    private static final Object max;
    private static final ValueSpace FLOAT_VALUE_SPACE;
    public static XSDFloat instance;

    protected XSDFloat(ATermAppl name) {
        super(name, FLOAT_VALUE_SPACE);
    }

    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDFloat type = new XSDFloat(null);
        type.values = intervals;
        return type;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"float");
        }
        catch (DatatypeException e) {
            e.printStackTrace();
        }
        min = Float.valueOf(Float.NEGATIVE_INFINITY);
        zero = Float.valueOf(0.0f);
        max = Float.valueOf(Float.POSITIVE_INFINITY);
        FLOAT_VALUE_SPACE = new FloatValueSpace();
        instance = new XSDFloat(ATermUtils.makeTermAppl((String)"http://www.w3.org/2001/XMLSchema#float"));
    }

    private static class FloatValueSpace
    extends AbstractValueSpace
    implements ValueSpace {
        public FloatValueSpace() {
            super(min, zero, max, true);
        }

        public boolean isValid(Object value) {
            return value instanceof Float;
        }

        public Object getValue(String literal) {
            return dt.createValue(literal, null);
        }

        public String getLexicalForm(Object value) {
            return dt.convertToLexicalValue(value, null);
        }

        public int compare(Object a, Object b) {
            Integer cmp = this.compareInternal(a, b);
            if (cmp != null) {
                return cmp;
            }
            return NumberUtils.compare((Number)((Number)a), (Number)((Number)b));
        }

        public int count(Object start, Object end) {
            Integer cmp = this.countInternal(start, end);
            if (cmp != null) {
                return cmp;
            }
            Float endFloat = Float.valueOf(((Float)end).floatValue());
            Float startFloat = Float.valueOf(((Float)start).floatValue());
            if (endFloat.floatValue() < startFloat.floatValue()) {
                return 0;
            }
            int endBits = Float.floatToRawIntBits(endFloat.floatValue());
            int startBits = Float.floatToRawIntBits(startFloat.floatValue());
            long count = startFloat.floatValue() < 0.0f ? (endFloat.floatValue() < 0.0f ? (long)((startBits & Integer.MAX_VALUE) - (endBits & Integer.MAX_VALUE) + 1) : (long)((startBits & Integer.MAX_VALUE) + (endBits & Integer.MAX_VALUE) + 2)) : (long)((endBits & Integer.MAX_VALUE) - (startBits & Integer.MAX_VALUE) + 1);
            return count > Integer.MAX_VALUE ? -1 : (int)count;
        }

        public Object succ(Object start, int n) {
            if (this.isInfinite(start)) {
                throw new IllegalArgumentException("Cannot handle infinite values");
            }
            return NumberUtils.add((Number)((Number)start), (int)n);
        }
    }
}

