/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.abstract_syntax;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.io.ShortFormProvider;
import org.semanticweb.owl.io.abstract_syntax.Renderer;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataEnumeration;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyInstance;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualTypeAssertion;
import org.semanticweb.owl.model.OWLInverseFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLInversePropertyAxiom;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyInstance;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.OWLSymmetricPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitivePropertyAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;

public class RenderingVisitor
extends OWLObjectVisitorAdapter {
    ShortFormProvider shortForms;
    StringWriter sw;
    PrintWriter pw;
    int level;
    boolean indenting = true;
    OWLOntology ontology;

    public RenderingVisitor(ShortFormProvider shortForms, OWLOntology ontology) {
        this.shortForms = shortForms;
        this.ontology = ontology;
        this.reset();
    }

    public String result() {
        return this.sw.toString();
    }

    public void reset() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public void visit(OWLClass clazz) throws OWLException {
        this.pw.print(this.shortForms.shortForm(clazz.getURI()));
    }

    public void visit(OWLIndividual ind) throws OWLException {
        RenderingVisitor visitor = new RenderingVisitor(this.shortForms, this.ontology);
        if (ind.isAnonymous()) {
            this.pw.print("Individual(_");
            if (ind.getTypes(this.ontology).isEmpty() && ind.getObjectPropertyValues(this.ontology).keySet().isEmpty() && ind.getDataPropertyValues(this.ontology).keySet().isEmpty()) {
                this.pw.print(")");
            } else {
                Iterator it = ind.getTypes(this.ontology).iterator();
                while (it.hasNext()) {
                    OWLDescription eq = (OWLDescription)it.next();
                    visitor.reset();
                    eq.accept((OWLObjectVisitor)visitor);
                    this.pw.print(" type(" + visitor.result() + ")");
                }
                Map propertyValues = ind.getObjectPropertyValues(this.ontology);
                Iterator it2 = propertyValues.keySet().iterator();
                while (it2.hasNext()) {
                    OWLObjectProperty prop = (OWLObjectProperty)it2.next();
                    Set vals = (Set)propertyValues.get(prop);
                    Iterator valIt = vals.iterator();
                    while (valIt.hasNext()) {
                        OWLIndividual oi = (OWLIndividual)valIt.next();
                        visitor.reset();
                        oi.accept((OWLObjectVisitor)visitor);
                        this.pw.print(" value(" + this.shortForms.shortForm(prop.getURI()) + " " + visitor.result() + ")");
                    }
                }
                Map dataValues = ind.getDataPropertyValues(this.ontology);
                Iterator it3 = dataValues.keySet().iterator();
                while (it3.hasNext()) {
                    OWLDataProperty prop = (OWLDataProperty)it3.next();
                    Set vals = (Set)dataValues.get(prop);
                    Iterator valIt = vals.iterator();
                    while (valIt.hasNext()) {
                        OWLDataValue dtv = (OWLDataValue)valIt.next();
                        visitor.reset();
                        dtv.accept((OWLObjectVisitor)visitor);
                        this.pw.print("value(" + this.shortForms.shortForm(prop.getURI()) + " " + visitor.result() + ")");
                        if (!it3.hasNext()) continue;
                        this.pw.print(" ");
                    }
                }
                this.pw.print(")");
            }
        } else {
            this.pw.print(this.shortForms.shortForm(ind.getURI()));
        }
    }

    public void visit(OWLObjectProperty prop) throws OWLException {
        this.pw.print(this.shortForms.shortForm(prop.getURI()));
    }

    public void visit(OWLDataProperty prop) throws OWLException {
        this.pw.print(this.shortForms.shortForm(prop.getURI()));
    }

    public void visit(OWLDataValue cd) throws OWLException {
        this.pw.print("\"" + Renderer.escape(cd.getValue()) + "\"");
        URI dvdt = cd.getURI();
        String dvlang = cd.getLang();
        if (dvdt != null) {
            this.pw.print("^^<" + dvdt.toString() + ">");
        } else if (dvlang != null) {
            this.pw.print("@" + dvlang);
        }
    }

    public void visit(OWLAnd and) throws OWLException {
        this.pw.print("intersectionOf(");
        Iterator it = and.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLOr or) throws OWLException {
        this.pw.print("unionOf(");
        Iterator it = or.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLNot not) throws OWLException {
        this.pw.print("complementOf(");
        OWLDescription desc = not.getOperand();
        desc.accept((OWLObjectVisitor)this);
        this.pw.print(")");
    }

    public void visit(OWLEnumeration enumeration) throws OWLException {
        this.pw.print("oneOf(");
        Iterator it = enumeration.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLObjectSomeRestriction restriction) throws OWLException {
        this.pw.print("restriction(");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" someValuesFrom(");
        restriction.getDescription().accept((OWLObjectVisitor)this);
        this.pw.print("))");
    }

    public void visit(OWLObjectAllRestriction restriction) throws OWLException {
        this.pw.print("restriction(");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" allValuesFrom(");
        restriction.getDescription().accept((OWLObjectVisitor)this);
        this.pw.print("))");
    }

    public void visit(OWLObjectValueRestriction restriction) throws OWLException {
        this.pw.print("restriction(");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" value (");
        restriction.getIndividual().accept((OWLObjectVisitor)this);
        this.pw.print("))");
    }

    public void visit(OWLDataSomeRestriction restriction) throws OWLException {
        this.pw.print("restriction(");
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" someValuesFrom (");
        restriction.getDataType().accept((OWLObjectVisitor)this);
        this.pw.print("))");
    }

    public void visit(OWLDataAllRestriction restriction) throws OWLException {
        this.pw.print("restriction(");
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" allValuesFrom(");
        restriction.getDataType().accept((OWLObjectVisitor)this);
        this.pw.print("))");
    }

    public void visit(OWLObjectCardinalityRestriction restriction) throws OWLException {
        this.pw.print("restriction(");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        if (restriction.isExactly()) {
            this.pw.print(" cardinality(" + restriction.getAtLeast() + "))");
        } else if (restriction.isAtMost()) {
            this.pw.print(" maxCardinality(" + restriction.getAtMost() + "))");
        } else if (restriction.isAtLeast()) {
            this.pw.print(" minCardinality(" + restriction.getAtLeast() + "))");
        }
    }

    public void visit(OWLDataCardinalityRestriction restriction) throws OWLException {
        this.pw.print("restriction(");
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        if (restriction.isExactly()) {
            this.pw.print(" cardinality(" + restriction.getAtLeast() + "))");
        } else if (restriction.isAtMost()) {
            this.pw.print(" maxCardinality(" + restriction.getAtMost() + "))");
        } else if (restriction.isAtLeast()) {
            this.pw.print(" minCardinality(" + restriction.getAtLeast() + "))");
        }
    }

    public void visit(OWLDataValueRestriction restriction) throws OWLException {
        this.pw.print("restriction(");
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" value (");
        restriction.getValue().accept((OWLObjectVisitor)this);
        this.pw.print("))");
    }

    public void visit(OWLEquivalentClassesAxiom axiom) throws OWLException {
        this.pw.print("EquivalentClasses(");
        Iterator it = axiom.getEquivalentClasses().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLDisjointClassesAxiom axiom) throws OWLException {
        this.pw.print("DisjointClasses(");
        Iterator it = axiom.getDisjointClasses().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLSubClassAxiom axiom) throws OWLException {
        this.pw.print("SubClassOf(");
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.pw.print(" ");
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.pw.print(")");
    }

    public void visit(OWLEquivalentPropertiesAxiom axiom) throws OWLException {
        this.pw.print("EquivalentProperties(");
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            OWLProperty prop = (OWLProperty)it.next();
            prop.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLSubPropertyAxiom axiom) throws OWLException {
        this.pw.print("SubPropertyOf(");
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" ");
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.pw.print(")");
    }

    public void visit(OWLDifferentIndividualsAxiom ax) throws OWLException {
        this.pw.print("DifferentIndividuals(");
        Iterator it = ax.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLSameIndividualsAxiom ax) throws OWLException {
        this.pw.print("SameIndividual(");
        Iterator it = ax.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLDataType ocdt) throws OWLException {
        this.pw.print(this.shortForms.shortForm(ocdt.getURI()));
    }

    public void visit(OWLDataEnumeration enumeration) throws OWLException {
        this.pw.print("oneOf(");
        Iterator it = enumeration.getValues().iterator();
        while (it.hasNext()) {
            OWLDataValue desc = (OWLDataValue)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInverseFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLTransitivePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLSymmetricPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInversePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLPropertyDomainAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLDataPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyInstance node) throws OWLException {
    }

    public void visit(OWLDataPropertyInstance node) throws OWLException {
    }

    public void visit(OWLIndividualTypeAssertion node) throws OWLException {
    }
}

