/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.dig1_0;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.XMLSchemaSimpleDatatypeVocabulary;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.helper.OntologyHelper;
import uk.ac.man.cs.img.owl.io.dig1_0.RenderingVisitor;

public class Renderer
implements org.semanticweb.owl.io.Renderer {
    private PrintWriter pw;
    private RenderingVisitor visitor = new RenderingVisitor();
    private List anonymousIndividuals;

    public void setOptions(Map map) {
    }

    public Map getOptions() {
        return null;
    }

    public void renderOntology(OWLOntology ontology, Writer writer) throws RendererException {
        try {
            this.pw = new PrintWriter(writer);
            this.pw.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            this.pw.println("<tells xmlns=\"http://dl.kr.org/dig/lang\"");
            this.pw.println("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            this.pw.println("       xsi:schemaLocation=\"http://dl.kr.org/dig/lang dig.xsd\">");
            this.pw.println("<defconcept name=\"" + OWLVocabularyAdapter.INSTANCE.getThing() + "\"/>");
            this.pw.println("<equalc>");
            this.pw.println("  <catom name=\"" + OWLVocabularyAdapter.INSTANCE.getThing() + "\"/>");
            this.pw.println("  <top/>");
            this.pw.println("</equalc>");
            this.pw.println("<defconcept name=\"" + OWLVocabularyAdapter.INSTANCE.getNothing() + "\"/>");
            this.pw.println("<equalc>");
            this.pw.println("  <catom name=\"" + OWLVocabularyAdapter.INSTANCE.getNothing() + "\"/>");
            this.pw.println("  <bottom/>");
            this.pw.println("</equalc>");
            Set allOntologies = OntologyHelper.importClosure((OWLOntology)ontology);
            Iterator allIt = allOntologies.iterator();
            while (allIt.hasNext()) {
                OWLOntology ontologyToProcess = (OWLOntology)allIt.next();
                Iterator it = Renderer.orderedEntities(ontologyToProcess.getClasses()).iterator();
                while (it.hasNext()) {
                    this.renderClass(ontologyToProcess, (OWLClass)it.next());
                }
                this.pw.println();
                it = Renderer.orderedEntities(ontologyToProcess.getObjectProperties()).iterator();
                while (it.hasNext()) {
                    this.renderObjectProperty(ontologyToProcess, (OWLObjectProperty)it.next());
                }
                this.pw.println();
                it = Renderer.orderedEntities(ontologyToProcess.getDataProperties()).iterator();
                while (it.hasNext()) {
                    this.renderDataProperty(ontologyToProcess, (OWLDataProperty)it.next());
                }
                this.pw.println();
                it = Renderer.orderedEntities(ontologyToProcess.getIndividuals()).iterator();
                while (it.hasNext()) {
                    this.renderIndividual(ontologyToProcess, (OWLIndividual)it.next());
                }
                this.pw.println();
                it = Renderer.orderedEntities(ontologyToProcess.getDatatypes()).iterator();
                while (it.hasNext()) {
                    this.renderDataType(ontologyToProcess, (OWLDataType)it.next());
                }
                this.pw.println();
                it = Renderer.orderedEntities(ontologyToProcess.getClassAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderClassAxiom((OWLClassAxiom)it.next());
                }
                this.pw.println();
                it = Renderer.orderedEntities(ontologyToProcess.getPropertyAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderPropertyAxiom((OWLPropertyAxiom)it.next());
                }
                this.pw.println();
                it = Renderer.orderedEntities(ontologyToProcess.getIndividualAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderIndividualAxiom((OWLIndividualAxiom)it.next());
                }
            }
            this.pw.println("</tells>");
        }
        catch (OWLException ex) {
            throw new RendererException(ex.getMessage());
        }
    }

    private void renderClass(OWLOntology ontology, OWLClass clazz) throws OWLException {
        OWLDescription eq;
        this.pw.println("<defconcept name=\"" + clazz.getURI() + "\"/>");
        Iterator it = clazz.getEquivalentClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.println("<equalc>");
            this.pw.println("  <catom name=\"" + clazz.getURI() + "\"/>");
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  " + this.visitor.result());
            this.pw.println("</equalc>");
        }
        it = clazz.getSuperClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.println("<impliesc>");
            this.pw.println("  <catom name=\"" + clazz.getURI() + "\"/>");
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  " + this.visitor.result());
            this.pw.println("</impliesc>");
        }
        it = clazz.getEnumerations(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.println("<equalc>");
            this.pw.println("  <catom name=\"" + clazz.getURI() + "\"/>");
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  " + this.visitor.result());
            this.pw.println("</equalc>");
        }
    }

    private void renderIndividual(OWLOntology ontology, OWLIndividual ind) throws OWLException {
        Map m;
        if (ind.isAnonymous() && !(m = ind.getIncomingObjectPropertyValues(ontology)).isEmpty()) {
            return;
        }
        String indReference = "";
        indReference = ind.isAnonymous() ? "anon-" + ind.hashCode() : ind.getURI().toString();
        this.pw.println("<defindividual name=\"" + indReference + "\"/>");
        Iterator it = ind.getTypes(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println();
            OWLDescription eq = (OWLDescription)it.next();
            this.pw.println("<instanceof>");
            this.pw.println("  <individual name=\"" + indReference + "\"/>");
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  " + this.visitor.result());
            this.pw.println("</instanceof>");
        }
        Map propertyValues = ind.getObjectPropertyValues(ontology);
        Iterator it2 = propertyValues.keySet().iterator();
        while (it2.hasNext()) {
            OWLObjectProperty prop = (OWLObjectProperty)it2.next();
            Set vals = (Set)propertyValues.get(prop);
            Iterator valIt = vals.iterator();
            while (valIt.hasNext()) {
                this.pw.println("<related>");
                this.pw.println("  <individual name=\"" + indReference + "\"/>");
                this.pw.println("   <ratom name=\"" + prop.getURI() + "\"/>");
                OWLIndividual oi = (OWLIndividual)valIt.next();
                if (oi.isAnonymous()) {
                    this.pw.println("  <individual name=\"anon-" + oi.hashCode() + "\"/>");
                } else {
                    this.pw.println("  <individual name=\"" + oi.getURI() + "\"/>");
                }
                this.pw.println("</related>");
            }
        }
        Map dataValues = ind.getDataPropertyValues(ontology);
        Iterator it3 = dataValues.keySet().iterator();
        while (it3.hasNext()) {
            OWLDataProperty prop = (OWLDataProperty)it3.next();
            Set vals = (Set)dataValues.get(prop);
            Iterator valIt = vals.iterator();
            while (valIt.hasNext()) {
                boolean isString = false;
                boolean isInteger = false;
                OWLDataValue dv = (OWLDataValue)valIt.next();
                boolean bl = isString = dv.getURI() == null;
                if (!isString) {
                    if (dv.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getString())) {
                        isString = true;
                    } else if (dv.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInteger())) {
                        isInteger = true;
                    } else if (dv.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getPositiveInteger())) {
                        isInteger = true;
                    } else if (dv.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getNegativeInteger())) {
                        isInteger = true;
                    } else if (dv.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getNonNegativeInteger())) {
                        isInteger = true;
                    } else if (dv.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getNonPositiveInteger())) {
                        isInteger = true;
                    }
                }
                if (!isString && !isInteger) {
                    throw new RendererException("Unknown Datatype: " + dv.getURI());
                }
                this.pw.println("<value>");
                this.pw.println("  <individual name=\"" + indReference + "\"/>");
                this.pw.println("   <attribute name=\"" + prop.getURI() + "\"/>");
                if (isInteger) {
                    this.pw.println("   <ival>" + dv.getValue() + "</ival>");
                }
                if (isString) {
                    this.pw.println("   <sval>" + dv.getValue() + "</sval>");
                }
                this.pw.println("</value>");
            }
        }
    }

    private void renderObjectProperty(OWLOntology ontology, OWLObjectProperty prop) throws OWLException {
        this.pw.println("<defrole name=\"" + prop.getURI() + "\"/>");
        if (prop.isTransitive(ontology)) {
            this.pw.println(" <transitive>");
            this.pw.println("  <ratom name=\"" + prop.getURI() + "\"/>");
            this.pw.println(" </transitive>");
        }
        if (prop.isFunctional(ontology)) {
            this.pw.println(" <functional>");
            this.pw.println("  <ratom name=\"" + prop.getURI() + "\"/>");
            this.pw.println(" </functional>");
        }
        if (prop.isInverseFunctional(ontology)) {
            // empty if block
        }
        if (prop.isSymmetric(ontology)) {
            // empty if block
        }
        Iterator it = prop.getInverses(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println("<equalr>");
            this.pw.println(" <ratom name=\"" + prop.getURI() + "\"/>");
            OWLObjectProperty inv = (OWLObjectProperty)it.next();
            this.pw.println(" <inverse>");
            this.pw.println("  <ratom name=\"" + inv.getURI() + "\"/>");
            this.pw.println(" </inverse>");
            this.pw.println("</equalr>");
        }
        it = prop.getSuperProperties(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println("<impliesr>");
            this.pw.println(" <ratom name=\"" + prop.getURI() + "\"/>");
            OWLObjectProperty sup = (OWLObjectProperty)it.next();
            this.pw.println(" <ratom name=\"" + sup.getURI() + "\"/>");
            this.pw.println("</impliesr>");
        }
        it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println("<domain>");
            this.pw.println(" <ratom name=\"" + prop.getURI() + "\"/>");
            OWLDescription dom = (OWLDescription)it.next();
            this.visitor.reset();
            dom.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  " + this.visitor.result());
            this.pw.println("</domain>");
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println("<range>");
            this.pw.println(" <ratom name=\"" + prop.getURI() + "\"/>");
            OWLDescription ran = (OWLDescription)it.next();
            this.visitor.reset();
            ran.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  " + this.visitor.result());
            this.pw.println("</range>");
        }
    }

    private void renderDataProperty(OWLOntology ontology, OWLDataProperty prop) throws OWLException {
        this.pw.println("<defattribute name=\"" + prop.getURI() + "\"/>");
        if (prop.isFunctional(ontology)) {
            // empty if block
        }
        Iterator it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println("<domain>");
            this.pw.println(" <attribute name=\"" + prop.getURI() + "\"/>");
            OWLDescription dom = (OWLDescription)it.next();
            this.visitor.reset();
            dom.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  " + this.visitor.result());
            this.pw.println("</domain>");
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println();
            try {
                OWLDataType ran = (OWLDataType)it.next();
                if (ran.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInteger()) || ran.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInt())) {
                    this.pw.println("<rangeint>");
                    this.pw.println(" <attribute name=\"" + prop.getURI() + "\"/>");
                    this.pw.println("</rangeint>");
                    continue;
                }
                if (ran.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getString())) {
                    this.pw.println("<rangestring>");
                    this.pw.println(" <attribute name=\"" + prop.getURI() + "\"/>");
                    this.pw.println("</rangestring>");
                    continue;
                }
                throw new RendererException("Unsupported range: " + prop.getURI() + "\n\t" + ran.getURI());
            }
            catch (ClassCastException ex) {
                throw new RendererException("Unsupported range: " + prop.getURI());
            }
        }
    }

    private void renderDataType(OWLOntology ontology, OWLDataType datatype) throws OWLException {
    }

    private void renderClassAxiom(OWLClassAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
    }

    private void renderPropertyAxiom(OWLPropertyAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
    }

    private void renderIndividualAxiom(OWLIndividualAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
    }

    public static SortedSet orderedEntities(Set entities) {
        TreeSet ss = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((OWLEntity)o1).getURI().toString().compareTo(((OWLEntity)o2).getURI().toString());
                }
                catch (Exception ex) {
                    return o1.toString().compareTo(o2.toString());
                }
            }
        });
        ss.addAll(entities);
        return ss;
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            URI uri = new URI(args[0]);
            OWLOntology onto = OntologyHelper.getOntology((URI)uri);
            Renderer renderer = new Renderer();
            StringWriter writer = new StringWriter();
            renderer.renderOntology(onto, writer);
            System.out.println(((Object)writer).toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

