/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.dig1_1;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;
import org.kr.dl.dig.v1_1.ConceptPair;
import org.kr.dl.dig.v1_1.InstanceofDocument;
import org.kr.dl.dig.v1_1.RelatedDocument;
import org.kr.dl.dig.v1_1.RoleConceptPair;
import org.kr.dl.dig.v1_1.RolePair;
import org.kr.dl.dig.v1_1.TellsDocument;
import org.kr.dl.dig.v1_1.ValueDocument;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.XMLSchemaSimpleDatatypeVocabulary;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLClassAxiomVisitor;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.OWLPropertyAxiomVisitor;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import uk.ac.man.cs.img.owl.io.dig1_1.ClassAxiomRenderingVisitor;
import uk.ac.man.cs.img.owl.io.dig1_1.ConceptPairRenderingVisitor;
import uk.ac.man.cs.img.owl.io.dig1_1.InstanceofRenderingVisitor;
import uk.ac.man.cs.img.owl.io.dig1_1.NotExpressableInDIGException;
import uk.ac.man.cs.img.owl.io.dig1_1.PropertyAxiomRenderingVisitor;
import uk.ac.man.cs.img.owl.io.dig1_1.RoleConceptPairRenderingVisitor;

public class Renderer
implements org.semanticweb.owl.io.Renderer {
    public static final String ANONYMOUS_INDIV = "urn:anonymous#";
    public static final Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$io$dig1_1$Renderer == null ? (class$uk$ac$man$cs$img$owl$io$dig1_1$Renderer = Renderer.class$("uk.ac.man.cs.img.owl.io.dig1_1.Renderer")) : class$uk$ac$man$cs$img$owl$io$dig1_1$Renderer));
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$io$dig1_1$Renderer;

    public void setOptions(Map map) {
    }

    public Map getOptions() {
        return null;
    }

    public TellsDocument renderOntology(OWLOntology ontology) throws NotExpressableInDIGException, RendererException {
        try {
            TellsDocument tellsDoc = TellsDocument.Factory.newInstance();
            TellsDocument.Tells tells = tellsDoc.addNewTells();
            Iterator it = uk.ac.man.cs.img.owl.io.dig1_0.Renderer.orderedEntities(ontology.getClasses()).iterator();
            while (it.hasNext()) {
                this.renderClass(ontology, (OWLClass)it.next(), tells);
            }
            it = uk.ac.man.cs.img.owl.io.dig1_0.Renderer.orderedEntities(ontology.getObjectProperties()).iterator();
            while (it.hasNext()) {
                this.renderObjectProperty(ontology, (OWLObjectProperty)it.next(), tells);
            }
            it = uk.ac.man.cs.img.owl.io.dig1_0.Renderer.orderedEntities(ontology.getDataProperties()).iterator();
            while (it.hasNext()) {
                this.renderDataProperty(ontology, (OWLDataProperty)it.next(), tells);
            }
            it = uk.ac.man.cs.img.owl.io.dig1_0.Renderer.orderedEntities(ontology.getIndividuals()).iterator();
            while (it.hasNext()) {
                this.renderIndividual(ontology, (OWLIndividual)it.next(), tells);
            }
            it = uk.ac.man.cs.img.owl.io.dig1_0.Renderer.orderedEntities(ontology.getDatatypes()).iterator();
            while (it.hasNext()) {
                this.renderDataType(ontology, (OWLDataType)it.next(), tells);
            }
            it = uk.ac.man.cs.img.owl.io.dig1_0.Renderer.orderedEntities(ontology.getClassAxioms()).iterator();
            while (it.hasNext()) {
                this.renderClassAxiom((OWLClassAxiom)it.next(), tells);
            }
            it = uk.ac.man.cs.img.owl.io.dig1_0.Renderer.orderedEntities(ontology.getPropertyAxioms()).iterator();
            while (it.hasNext()) {
                this.renderPropertyAxiom((OWLPropertyAxiom)it.next(), tells);
            }
            it = uk.ac.man.cs.img.owl.io.dig1_0.Renderer.orderedEntities(ontology.getIndividualAxioms()).iterator();
            while (it.hasNext()) {
                this.renderIndividualAxiom((OWLIndividualAxiom)it.next(), tells);
            }
            return tellsDoc;
        }
        catch (OWLException ex) {
            logger.error((Object)ex);
            throw new RendererException(ex.getMessage());
        }
    }

    public void renderOntology(OWLOntology ontology, Writer writer) throws NotExpressableInDIGException, RendererException {
        try {
            TellsDocument tellsDoc = this.renderOntology(ontology);
            tellsDoc.save(writer, Renderer.prettyPrintOptions());
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new RendererException(e.getMessage());
        }
    }

    void renderClass(OWLOntology ontology, OWLClass owlClass, TellsDocument.Tells tells) throws OWLException {
        ConceptPairRenderingVisitor nextVisitor;
        ConceptPair nextConceptPair;
        OWLDescription nextDescription;
        String className = owlClass.getURI().toString();
        if (className.equals(OWLVocabularyAdapter.INSTANCE.getThing())) {
            return;
        }
        if (className.equals(OWLVocabularyAdapter.INSTANCE.getNothing())) {
            return;
        }
        tells.addNewDefconcept().setName(owlClass.getURI().toString());
        Iterator it = owlClass.getEquivalentClasses(ontology).iterator();
        while (it.hasNext()) {
            nextDescription = (OWLDescription)it.next();
            nextConceptPair = tells.addNewEqualc();
            nextConceptPair.addNewCatom().setName(owlClass.getURI().toString());
            nextVisitor = new ConceptPairRenderingVisitor(nextConceptPair);
            nextDescription.accept((OWLDescriptionVisitor)nextVisitor);
        }
        it = owlClass.getSuperClasses(ontology).iterator();
        while (it.hasNext()) {
            nextDescription = (OWLDescription)it.next();
            nextConceptPair = tells.addNewImpliesc();
            nextConceptPair.addNewCatom().setName(owlClass.getURI().toString());
            nextVisitor = new ConceptPairRenderingVisitor(nextConceptPair);
            nextDescription.accept((OWLDescriptionVisitor)nextVisitor);
        }
        Iterator it2 = owlClass.getEnumerations(ontology).iterator();
        while (it2.hasNext()) {
            nextDescription = (OWLDescription)it2.next();
            nextConceptPair = tells.addNewEqualc();
            nextConceptPair.addNewCatom().setName(owlClass.getURI().toString());
            nextVisitor = new ConceptPairRenderingVisitor(nextConceptPair);
            nextDescription.accept((OWLDescriptionVisitor)nextVisitor);
        }
    }

    void renderIndividual(OWLOntology ontology, OWLIndividual ind, TellsDocument.Tells tells) throws OWLException {
        Set vals;
        Map m;
        if (ind.isAnonymous() && !(m = ind.getIncomingObjectPropertyValues(ontology)).isEmpty()) {
            return;
        }
        String indReference = null;
        indReference = ind.isAnonymous() ? Renderer.anonymIndividual(ind) : ind.getURI().toString();
        tells.addNewDefindividual().setName(indReference);
        Iterator it = ind.getTypes(ontology).iterator();
        while (it.hasNext()) {
            OWLDescription nextDescription = (OWLDescription)it.next();
            InstanceofDocument.Instanceof inst = tells.addNewInstanceof();
            inst.addNewIndividual().setName(indReference);
            nextDescription.accept((OWLDescriptionVisitor)new InstanceofRenderingVisitor(inst));
        }
        Map propertyValues = ind.getObjectPropertyValues(ontology);
        Iterator it2 = propertyValues.keySet().iterator();
        while (it2.hasNext()) {
            OWLObjectProperty nextProperty = (OWLObjectProperty)it2.next();
            vals = (Set)propertyValues.get(nextProperty);
            Iterator valIt = vals.iterator();
            while (valIt.hasNext()) {
                RelatedDocument.Related related = tells.addNewRelated();
                related.addNewIndividual().setName(indReference);
                related.addNewRatom().setName(nextProperty.getURI().toString());
                OWLIndividual nextIndividual = (OWLIndividual)valIt.next();
                if (nextIndividual.isAnonymous()) {
                    related.addNewIndividual().setName(Renderer.anonymIndividual(nextIndividual));
                    continue;
                }
                related.addNewIndividual().setName(nextIndividual.getURI().toString());
            }
        }
        Map dataValues = ind.getDataPropertyValues(ontology);
        boolean isString = false;
        boolean isInteger = false;
        Iterator it3 = dataValues.keySet().iterator();
        while (it3.hasNext()) {
            OWLDataProperty nextDataProp = (OWLDataProperty)it3.next();
            vals = (Set)dataValues.get(nextDataProp);
            Iterator valIt = vals.iterator();
            while (valIt.hasNext()) {
                OWLDataValue nextDataValue = (OWLDataValue)valIt.next();
                URI nextDataValueURI = nextDataValue.getURI();
                if (nextDataValueURI != null) {
                    String uriString = nextDataValueURI.toString();
                    if (uriString.equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInteger()) || uriString.equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getPositiveInteger()) || uriString.equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getNegativeInteger()) || uriString.equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getNonNegativeInteger()) || uriString.equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getNonPositiveInteger())) {
                        isInteger = true;
                    } else if (uriString.equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getString())) {
                        isString = true;
                    }
                } else {
                    isString = true;
                }
                if (!isString && !isInteger) {
                    throw new RendererException("Unknown Datatype: " + nextDataValueURI);
                }
                ValueDocument.Value value = tells.addNewValue();
                value.addNewIndividual().setName(indReference);
                value.addNewAttribute().setName(nextDataProp.getURI().toString());
                if (isInteger) {
                    value.setIval(new BigInteger(nextDataValue.getValue().toString()));
                }
                if (!isString) continue;
                value.setSval(nextDataValue.getValue().toString());
            }
        }
    }

    public static String anonymIndividual(OWLIndividual individual) {
        return ANONYMOUS_INDIV + individual.hashCode();
    }

    void renderObjectProperty(OWLOntology ontology, OWLObjectProperty prop, TellsDocument.Tells tells) throws OWLException {
        OWLDescription nextDescription;
        RoleConceptPair nextRoleConceptPair;
        OWLObjectProperty nextProperty;
        RolePair nextRolePair;
        String propertyName = prop.getURI().toString();
        tells.addNewDefrole().setName(propertyName);
        if (prop.isTransitive(ontology)) {
            tells.addNewTransitive().addNewRatom().setName(propertyName);
        }
        if (prop.isFunctional(ontology)) {
            tells.addNewFunctional().addNewRatom().setName(propertyName);
        }
        if (prop.isInverseFunctional(ontology)) {
            tells.addNewFunctional().addNewInverse().addNewRatom().setName(propertyName);
        }
        if (prop.isSymmetric(ontology)) {
            RolePair rolePair = tells.addNewEqualr();
            rolePair.addNewRatom().setName(propertyName);
            rolePair.addNewInverse().addNewRatom().setName(propertyName);
        }
        Iterator it = prop.getInverses(ontology).iterator();
        while (it.hasNext()) {
            nextRolePair = tells.addNewEqualr();
            nextRolePair.addNewRatom().setName(propertyName);
            nextProperty = (OWLObjectProperty)it.next();
            nextRolePair.addNewInverse().addNewRatom().setName(nextProperty.getURI().toString());
        }
        it = prop.getSuperProperties(ontology).iterator();
        while (it.hasNext()) {
            nextRolePair = tells.addNewImpliesr();
            nextRolePair.addNewRatom().setName(propertyName);
            nextProperty = (OWLObjectProperty)it.next();
            nextRolePair.addNewRatom().setName(nextProperty.getURI().toString());
        }
        Iterator it2 = prop.getDomains(ontology).iterator();
        while (it2.hasNext()) {
            nextRoleConceptPair = tells.addNewDomain();
            nextRoleConceptPair.addNewRatom().setName(propertyName);
            nextDescription = (OWLDescription)it2.next();
            nextDescription.accept((OWLDescriptionVisitor)new RoleConceptPairRenderingVisitor(nextRoleConceptPair));
        }
        it2 = prop.getRanges(ontology).iterator();
        while (it2.hasNext()) {
            nextRoleConceptPair = tells.addNewRange();
            nextRoleConceptPair.addNewRatom().setName(propertyName);
            nextDescription = (OWLDescription)it2.next();
            nextDescription.accept((OWLDescriptionVisitor)new RoleConceptPairRenderingVisitor(nextRoleConceptPair));
        }
    }

    void renderDataProperty(OWLOntology ontology, OWLDataProperty prop, TellsDocument.Tells tells) throws OWLException {
        String propertyName = prop.getURI().toString();
        tells.addNewDefattribute().setName(propertyName);
        Iterator it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            RoleConceptPair nextRoleConceptPair = tells.addNewDomain();
            nextRoleConceptPair.addNewAttribute().setName(propertyName);
            OWLDescription nextDescription = (OWLDescription)it.next();
            nextDescription.accept((OWLDescriptionVisitor)new RoleConceptPairRenderingVisitor(nextRoleConceptPair));
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            try {
                OWLDataType ran = (OWLDataType)it.next();
                if (ran.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInteger()) || ran.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInt())) {
                    tells.addNewRangeint().addNewAttribute().setName(prop.getURI().toString());
                    continue;
                }
                if (ran.getURI().toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getString())) {
                    tells.addNewRangestring().addNewAttribute().setName(prop.getURI().toString());
                    continue;
                }
                throw new RendererException("Unsupported range: " + prop.getURI() + "\n\t" + ran.getURI());
            }
            catch (ClassCastException ex) {
                throw new RendererException("Unsupported range: " + prop.getURI());
            }
        }
    }

    void renderDataType(OWLOntology ontology, OWLDataType datatype, TellsDocument.Tells tells) throws NotExpressableInDIGException {
        throw new NotExpressableInDIGException("Can't handle DataTypes");
    }

    void renderClassAxiom(OWLClassAxiom axiom, TellsDocument.Tells tells) throws OWLException {
        axiom.accept((OWLClassAxiomVisitor)new ClassAxiomRenderingVisitor(tells));
    }

    void renderPropertyAxiom(OWLPropertyAxiom axiom, TellsDocument.Tells tells) throws OWLException {
        axiom.accept((OWLPropertyAxiomVisitor)new PropertyAxiomRenderingVisitor(tells));
    }

    void renderIndividualAxiom(OWLIndividualAxiom axiom, TellsDocument.Tells tells) throws NotExpressableInDIGException {
        throw new NotExpressableInDIGException("Can't handle IndividualAxioms");
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                System.err.println("Failed: needs physical URI of OWL ontology to be rendered.");
                System.err.println("Optionally, provide name of file where the rendered ontology has to be written.");
                return;
            }
            URI owlOntologyUri = new URI(args[0]);
            OWLOntology ontology = null;
            OWLConnection connection = null;
            try {
                connection = OWLManager.getOWLConnection();
            }
            catch (OWLException e) {
                System.err.println("Could not obtain connection");
                System.exit(-1);
            }
            OWLRDFParser parser = new OWLRDFParser();
            parser.setConnection(connection);
            ontology = parser.parseOntology(owlOntologyUri);
            Renderer renderer = new Renderer();
            TellsDocument tells = renderer.renderOntology(ontology);
            tells.getTells().setUri("urn:just-to-validate/replace-me-with-kb-uri");
            if (!tells.validate()) {
                System.err.println("Translation not valid.");
            }
            if (args.length > 1) {
                File file = new File(args[1]);
                XmlOptions prettyPrint = Renderer.prettyPrintOptions();
                tells.save(file, prettyPrint);
                System.out.println("OWL ontology " + owlOntologyUri.toString() + " translated to DIG 1.1 in file " + file.toString());
            } else {
                System.out.println("OWL ontology " + owlOntologyUri.toString() + " translated to DIG 1.1:");
                System.out.println(tells.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static XmlOptions prettyPrintOptions() {
        XmlOptions prettyPrint = new XmlOptions();
        prettyPrint.setSavePrettyPrint();
        prettyPrint.setUseDefaultNamespace();
        return prettyPrint;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

