/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.factplus;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyInstance;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualTypeAssertion;
import org.semanticweb.owl.model.OWLInverseFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLInversePropertyAxiom;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyInstance;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.OWLSymmetricPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitivePropertyAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;
import uk.ac.man.cs.img.owl.io.factplus.ShortFormProvider;

public class RenderingVisitor
extends OWLObjectVisitorAdapter {
    ShortFormProvider shortForms;
    StringWriter sw;
    PrintWriter pw;
    int level;
    boolean indenting = true;

    public RenderingVisitor(ShortFormProvider shortForms) {
        this.shortForms = shortForms;
        this.reset();
    }

    public String result() {
        return this.sw.toString();
    }

    public void reset() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public void visit(OWLClass clazz) throws OWLException {
        this.pw.print(this.shortForms.shortForm((OWLNamedObject)clazz));
    }

    public void visit(OWLIndividual ind) throws OWLException {
        this.pw.print(this.shortForms.shortForm((OWLNamedObject)ind));
    }

    public void visit(OWLObjectProperty prop) throws OWLException {
        this.pw.print(this.shortForms.shortForm((OWLNamedObject)prop));
    }

    public void visit(OWLDataProperty prop) throws OWLException {
        this.pw.print(this.shortForms.shortForm((OWLNamedObject)prop));
    }

    public void visit(OWLDataValue cd) throws OWLException {
        this.pw.print("[" + cd.getValue() + "^^" + cd + "]");
    }

    public void visit(OWLAnd and) throws OWLException {
        this.pw.print("(and ");
        Iterator it = and.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLOr or) throws OWLException {
        this.pw.print("(or ");
        Iterator it = or.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLNot not) throws OWLException {
        this.pw.print("(not ");
        OWLDescription desc = not.getOperand();
        desc.accept((OWLObjectVisitor)this);
        this.pw.print(")");
    }

    public void visit(OWLEnumeration enumeration) throws OWLException {
        this.pw.print("(one-of ");
        Iterator it = enumeration.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLObjectSomeRestriction restriction) throws OWLException {
        this.pw.print("(some ");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" ");
        restriction.getDescription().accept((OWLObjectVisitor)this);
        this.pw.print(")");
    }

    public void visit(OWLObjectAllRestriction restriction) throws OWLException {
        this.pw.print("(all ");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" ");
        restriction.getDescription().accept((OWLObjectVisitor)this);
        this.pw.print(")");
    }

    public void visit(OWLObjectValueRestriction restriction) throws OWLException {
        this.pw.print("(some ");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" ");
        restriction.getIndividual().accept((OWLObjectVisitor)this);
        this.pw.print(")");
    }

    public void visit(OWLObjectCardinalityRestriction restriction) throws OWLException {
        if (restriction.isExactly()) {
            this.pw.print(" (and (atmost " + restriction.getAtLeast() + " ");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.print(" :TOP)");
            this.pw.print(" (atleast " + restriction.getAtLeast() + " ");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.print(" :TOP))");
        } else if (restriction.isAtMost()) {
            this.pw.print(" (atmost " + restriction.getAtMost() + " ");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.print(" :TOP)");
        } else if (restriction.isAtLeast()) {
            this.pw.print(" (atleast " + restriction.getAtLeast() + " ");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.print(" :TOP)");
        }
    }

    public void visit(OWLDataSomeRestriction restriction) throws OWLException {
        throw new OWLException(" Data restriction ");
    }

    public void visit(OWLDataAllRestriction restriction) throws OWLException {
        throw new OWLException(" Data restriction ");
    }

    public void visit(OWLDataValueRestriction restriction) throws OWLException {
        throw new OWLException(" Data restriction ");
    }

    public void visit(OWLDataCardinalityRestriction restriction) throws OWLException {
        if (restriction.isExactly()) {
            this.pw.print(" (and (atmost " + restriction.getAtLeast() + " ");
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.print(" :TOP)");
            this.pw.print(" (atleast " + restriction.getAtLeast() + " ");
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.print(" :TOP))");
        } else if (restriction.isAtMost()) {
            this.pw.print(" (atmost " + restriction.getAtMost() + " ");
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.print(" :TOP)");
        } else if (restriction.isAtLeast()) {
            this.pw.print(" (atleast " + restriction.getAtLeast() + " ");
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.print(" :TOP)");
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) throws OWLException {
        Object[] eqs = axiom.getEquivalentClasses().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                this.pw.print(" (equal_c ");
                OWLDescription desc1 = (OWLDescription)eqs[i];
                desc1.accept((OWLObjectVisitor)this);
                OWLDescription desc2 = (OWLDescription)eqs[j];
                desc2.accept((OWLObjectVisitor)this);
                this.pw.print(")");
            }
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) throws OWLException {
        this.pw.println(" ;; Disjoint");
        this.pw.print(" (disjoint ");
        Iterator it = axiom.getDisjointClasses().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLSubClassAxiom axiom) throws OWLException {
        this.pw.print(" (implies_c ");
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.pw.print(" ");
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.pw.print(")");
    }

    public void visit(OWLEquivalentPropertiesAxiom axiom) throws OWLException {
        Object[] eqs = axiom.getProperties().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                this.pw.print(" (equal_r ");
                OWLProperty desc1 = (OWLProperty)eqs[i];
                desc1.accept((OWLObjectVisitor)this);
                OWLProperty desc2 = (OWLProperty)eqs[j];
                desc2.accept((OWLObjectVisitor)this);
                this.pw.print(")");
            }
        }
    }

    public void visit(OWLSubPropertyAxiom axiom) throws OWLException {
        this.pw.print(" (implies_r ");
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        this.pw.print(" ");
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.pw.print(")");
    }

    public void visit(OWLDifferentIndividualsAxiom ax) throws OWLException {
        this.pw.print("(different ");
        Iterator it = ax.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLSameIndividualsAxiom ax) throws OWLException {
        this.pw.print("(same ");
        Iterator it = ax.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" ");
        }
        this.pw.print(")");
    }

    public void visit(OWLDataType ocdt) throws OWLException {
        this.pw.print(ocdt.getURI());
    }

    public void visit(OWLFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInverseFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLTransitivePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLSymmetricPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInversePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLPropertyDomainAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLDataPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyInstance node) throws OWLException {
    }

    public void visit(OWLDataPropertyInstance node) throws OWLException {
    }

    public void visit(OWLIndividualTypeAssertion node) throws OWLException {
    }
}

