/* Generated By:JavaCC: Do not edit this line. KRSS2Parser.java */
package de.uulm.ecs.ai.owl.krssparser;

import org.semanticweb.owl.model.*;
import org.semanticweb.owl.util.NamespaceUtil;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.*;

public class KRSS2Parser implements KRSS2ParserConstants {

    private OWLOntology ontology;

    private OWLDataFactory dataFactory;

    private Map<String, URI> string2URI;

    private boolean ignoreAnnotationsAndDeclarations = false;

    private boolean ignoreOntologyURI = false;

    private String base;

    private NamespaceUtil utils;

    public void setOntology(OWLOntology ontology, OWLDataFactory dataFactory)  {
        this.ontology = ontology;
        this.dataFactory = dataFactory;
        this.string2URI = new HashMap<String, URI>();
        this.base = ontology.getURI().toString() + "#";
        this.utils = new NamespaceUtil();
    }

     protected void addAxiom(OWLAxiom ax) throws KRSS2OWLParserException {
        try {
            ((OWLMutableOntology) ontology).applyChange(new AddAxiom(ontology, ax));
        }
        catch(OWLOntologyChangeException e) {
            throw new KRSS2OWLParserException(e);
        }
    }

      protected static boolean isFileURI(final URI uri) {
        URL url;
        if (!uri.isAbsolute()) return false;
        try {
            url = uri.toURL();
        } catch (MalformedURLException e) {
            return false;
        }
        return (url.getProtocol().equals("file"));
    }


     protected static String extractLocalname(final URI uri) {
        if (uri.getFragment() != null && !uri.getFragment().equals(""))
            return uri.getFragment();
        String uriString = uri.toString();
        int index = -1;
        if (isFileURI(uri)) {
            //bug: all other file separators?
            index = uriString.lastIndexOf("/");
            if (index < 0)
                index = uriString.lastIndexOf("\\");
        } else
            index = uriString.indexOf("#");
        index++;
        if (index > -1) {
            return uriString.substring(index, uriString.length());
        } else
            return null; //""
    }


    public URI getURI(String s) throws URISyntaxException {

      URI uri = string2URI.get(s);
      if(uri != null) {
        return uri;
      }

      if (!this.ignoreOntologyURI) {
         String[] splitted = utils.split(s, null);
          if (splitted[0].equals("")) {
               s = base + s;
          } else {
              int i=0 ;
          }
      }
      uri = new URI(s);
      string2URI.put(s, uri);
      return uri;
    }


    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        ignoreAnnotationsAndDeclarations = b;
    }

    public void setIgnoreOntologyBaseURI(boolean b) {
        this.ignoreOntologyURI = b;
    }

  final public void parse() throws ParseException, KRSS2OWLParserException {
    label_1:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_1;
      }
      TBoxStatement();
    }
    if (jj_2_2(2)) {
      jj_consume_token(ENDTBOX);
    } else {
      ;
    }
    label_2:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_2;
      }
      ABoxStatement();
    }
    if (jj_2_4(2)) {
      jj_consume_token(ENDABOX);
    } else {
      ;
    }
    jj_consume_token(0);
  }

  final public void TBoxStatement() throws ParseException, KRSS2OWLParserException {
    if (jj_2_5(2)) {
      DefinePrimitiveConcept();
    } else if (jj_2_6(2)) {
      DefineConcept();
    } else if (jj_2_7(2)) {
      DefinePrimitiveRole();
    } else if (jj_2_8(2)) {
      Transitive();
    } else if (jj_2_9(2)) {
      Range();
    } else if (jj_2_10(2)) {
      Implies();
    } else if (jj_2_11(2)) {
      ComplexRoleInclusion();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public void DefinePrimitiveConcept() throws ParseException, KRSS2OWLParserException {
    OWLDescription subClass = null;
    OWLDescription superClass = null;
    jj_consume_token(OPENPAR);
    jj_consume_token(DEFINEPRIMITIVECONCEPT);
    subClass = ConceptName();
    if (jj_2_12(2)) {
      superClass = ConceptExpression();
    } else {
      ;
    }
    jj_consume_token(CLOSEPAR);
        if (subClass instanceof OWLClass) {
            addAxiom(dataFactory.getOWLDeclarationAxiom((OWLClass) subClass));
            if (superClass != null) {
               addAxiom(dataFactory.getOWLSubClassAxiom(subClass, superClass));
            }
        }
  }

  final public void DefineConcept() throws ParseException, KRSS2OWLParserException {
    OWLDescription clsA;
    OWLDescription clsB;
    jj_consume_token(OPENPAR);
    jj_consume_token(DEFINECONCEPT);
    clsA = ConceptName();
    clsB = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        if (clsA instanceof OWLClass)
            addAxiom(dataFactory.getOWLDeclarationAxiom((OWLClass) clsA));
        Set<OWLDescription> ops = new HashSet<OWLDescription>();
        ops.add(clsA);
        ops.add(clsB);
        addAxiom( dataFactory.getOWLEquivalentClassesAxiom(ops));
  }

  final public void DefinePrimitiveRole() throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty subProp;
    OWLObjectProperty superProp;
    OWLDescription desc;
    Set<OWLObjectProperty> roles = new HashSet<OWLObjectProperty>();
    Set<OWLDescription> descs = new HashSet<OWLDescription>();
    jj_consume_token(OPENPAR);
    jj_consume_token(DEFINEPRIMITIVEROLE);
    subProp = RoleName();
          if (subProp != null)
            addAxiom( dataFactory.getOWLDeclarationAxiom(subProp));
    Parent(subProp);
    RightIdentity(subProp);
    Parents(subProp);
    Domain(subProp);
    RangeAttribute(subProp);
    TransitiveAttribute(subProp);
    SymmetricAttribute(subProp);
    InverseProperty(subProp);
    jj_consume_token(CLOSEPAR);
  }

  final public void RightIdentity(OWLObjectProperty r) throws ParseException, KRSS2OWLParserException {
OWLObjectProperty s;
    if (jj_2_13(2)) {
      jj_consume_token(RIGHT_IDENTITY_ATTRIBUTE);
      s = RoleName();
        List<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>(2);
        chain.add(r); chain.add(s);
        addAxiom(dataFactory.getOWLObjectPropertyChainSubPropertyAxiom(chain, r));
    } else {
      ;
    }
  }

  final public void LeftIdentity(OWLObjectProperty r) throws ParseException, KRSS2OWLParserException {
OWLObjectProperty s;
    if (jj_2_14(2)) {
      jj_consume_token(LEFT_IDENTITY_ATTRIBUTE);
      s = RoleName();
        List<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>(2);
        chain.add(s); chain.add(r);
        addAxiom(dataFactory.getOWLObjectPropertyChainSubPropertyAxiom(chain, r));
    } else {
      ;
    }
  }

  final public void InverseProperty(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
OWLObjectProperty superProp;
    if (jj_2_15(2)) {
      jj_consume_token(INVERSE_ATTRIBUTE);
      superProp = RoleName();
            addAxiom(dataFactory.getOWLInverseObjectPropertiesAxiom(subProp, superProp));
    } else {
      ;
    }
  }

  final public void Domain(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
      OWLDescription desc;
      Set<OWLDescription> descs = new HashSet<OWLDescription>();
    if (jj_2_19(2)) {
      jj_consume_token(DOMAIN_ATTRIBUTE);
      if (jj_2_17(2)) {
        jj_consume_token(OPENPAR);
        label_3:
        while (true) {
          desc = ConceptExpression();
                                                          if (desc != null) descs.add(desc);
          if (jj_2_16(2)) {
            ;
          } else {
            break label_3;
          }
        }
        jj_consume_token(CLOSEPAR);
      } else if (jj_2_18(2)) {
        desc = ConceptExpression();
                                                                                                                                      descs.add(desc);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
                for (OWLDescription eachDescription : descs) {
                    addAxiom(dataFactory.getOWLObjectPropertyDomainAxiom(subProp, eachDescription));
                    if (eachDescription instanceof OWLClass)
                          addAxiom(dataFactory.getOWLDeclarationAxiom((OWLClass) eachDescription));
                }
    } else {
      ;
    }
  }

  final public void RangeAttribute(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
      OWLDescription desc;
      Set<OWLDescription> descs = new HashSet<OWLDescription>();
    if (jj_2_23(2)) {
      jj_consume_token(RANGE_ATTRIBUTE);
      if (jj_2_21(2)) {
        jj_consume_token(OPENPAR);
        label_4:
        while (true) {
          desc = ConceptExpression();
                                                         if (desc != null) descs.add(desc);
          if (jj_2_20(2)) {
            ;
          } else {
            break label_4;
          }
        }
        jj_consume_token(CLOSEPAR);
      } else if (jj_2_22(2)) {
        desc = ConceptExpression();
                                                                                                                                     descs.add(desc);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
                for (OWLDescription eachDescription : descs) {
                    addAxiom(dataFactory.getOWLObjectPropertyRangeAxiom(subProp, eachDescription));
                    if (eachDescription instanceof OWLClass)
                          addAxiom(dataFactory.getOWLDeclarationAxiom((OWLClass) eachDescription));
                }
    } else {
      ;
    }
  }

  final public void TransitiveAttribute(OWLObjectProperty property) throws ParseException, KRSS2OWLParserException {
    if (jj_2_26(2)) {
      jj_consume_token(TRANSITIVE_ATTRIBUTE);
      if (jj_2_24(2)) {
        jj_consume_token(NIL);
      } else if (jj_2_25(2)) {
        jj_consume_token(TRUE);
    addAxiom(dataFactory.getOWLTransitiveObjectPropertyAxiom(property));
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
  }

  final public void SymmetricAttribute(OWLObjectProperty property) throws ParseException, KRSS2OWLParserException {
    if (jj_2_29(2)) {
      jj_consume_token(SYMMETRIC_ATTRIBUTE);
      if (jj_2_27(2)) {
        jj_consume_token(NIL);
      } else if (jj_2_28(2)) {
        jj_consume_token(TRUE);
    addAxiom(dataFactory.getOWLSymmetricObjectPropertyAxiom(property));
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
  }

/*void Range(OWLObjectProperty subProp) throws KRSS2OWLParserException :
{
      OWLDescription desc;
      Set<OWLDescription> descs = new HashSet<OWLDescription>();

}
{
 (<RANGE_ATTRIBUTE>( <OPENPAR>(desc=ConceptExpression(){descs.add(desc);})+<CLOSEPAR>| (desc=ConceptExpression(){ descs.add(desc);})  )
            {
                for (OWLDescription eachDescription : descs) {
                    addAxiom(dataFactory.getOWLObjectPropertyRangeAxiom(subProp, eachDescription));
                    if (eachDescription instanceof OWLClass)
                          addAxiom(dataFactory.getOWLDeclarationAxiom((OWLClass) eachDescription));
                }
            }
        )+
}*/
  final public void Parents(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
    Set<OWLObjectProperty> roles;
    OWLObjectProperty superProp;
    if (jj_2_36(2)) {
      if (jj_2_34(2)) {
        jj_consume_token(PARENTS);
        if (jj_2_30(2)) {
          jj_consume_token(NIL);
        } else if (jj_2_31(2)) {
          jj_consume_token(OPENPAR);
          roles = RoleNameSet();
          jj_consume_token(CLOSEPAR);
                if (roles != null)
                    for (OWLObjectProperty prop: roles) {
                        addAxiom(dataFactory.getOWLSubObjectPropertyAxiom(subProp, prop));
                        if (prop instanceof OWLObjectProperty)
                          addAxiom(dataFactory.getOWLDeclarationAxiom((OWLObjectProperty) prop));
                    }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else if (jj_2_35(2)) {
        jj_consume_token(PARENT);
        if (jj_2_32(2)) {
          jj_consume_token(NIL);
        } else if (jj_2_33(2)) {
          superProp = RoleName();
                            addAxiom(dataFactory.getOWLSubObjectPropertyAxiom(subProp, superProp));
                            if (superProp instanceof OWLObjectProperty)
                          addAxiom(dataFactory.getOWLDeclarationAxiom((OWLObjectProperty) superProp));
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
  }

  final public void Parent(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty superProp;
    if (jj_2_37(2)) {
      superProp = RoleName();
       addAxiom(dataFactory.getOWLSubObjectPropertyAxiom(subProp, superProp));
    } else {
      ;
    }
  }

  final public void ComplexRoleInclusion() throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty superProp;
    OWLObjectProperty subProp1, subProp2;
    jj_consume_token(OPENPAR);
    jj_consume_token(ROLE_INCLUSION);
    jj_consume_token(COMPLEX);
    subProp1 = RoleName();
    subProp2 = RoleName();
    jj_consume_token(CLOSEPAR);
    superProp = RoleName();
    jj_consume_token(CLOSEPAR);
         List<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>(2);
         chain.add(subProp1); chain.add(subProp2);
         addAxiom(dataFactory.getOWLObjectPropertyChainSubPropertyAxiom(chain, superProp));
  }

  final public void Implies() throws ParseException, KRSS2OWLParserException {
    OWLDescription subDescription;
    OWLDescription superDescription;
    jj_consume_token(OPENPAR);
    jj_consume_token(IMPLIES);
    subDescription = ConceptExpression();
    superDescription = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        addAxiom( dataFactory.getOWLSubClassAxiom(subDescription, superDescription));
        if (subDescription instanceof OWLClass)
            addAxiom(dataFactory.getOWLDeclarationAxiom((OWLClass) subDescription));
        if (superDescription instanceof OWLClass)
            addAxiom(dataFactory.getOWLDeclarationAxiom((OWLClass) superDescription));
  }

  final public void Transitive() throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty prop;
    jj_consume_token(OPENPAR);
    jj_consume_token(TRANSITIVE);
    prop = RoleName();
    jj_consume_token(CLOSEPAR);
        addAxiom( dataFactory.getOWLTransitiveObjectPropertyAxiom(prop));
  }

  final public void Range() throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty prop;
    OWLDescription rng;
    jj_consume_token(OPENPAR);
    jj_consume_token(RANGE);
    prop = RoleName();
    rng = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        addAxiom( dataFactory.getOWLObjectPropertyRangeAxiom(prop, rng));
        if (prop instanceof OWLObjectProperty)
         addAxiom(dataFactory.getOWLDeclarationAxiom((OWLObjectProperty) prop));
        if (rng instanceof OWLClass)
         addAxiom(dataFactory.getOWLDeclarationAxiom((OWLClass) rng));
  }

  final public OWLDescription ConceptExpression() throws ParseException, KRSS2OWLParserException {
    OWLDescription desc;
    if (jj_2_38(2)) {
      desc = ConceptName();
    } else if (jj_2_39(2)) {
      desc = And();
    } else if (jj_2_40(2)) {
      desc = Or();
    } else if (jj_2_41(2)) {
      desc = Not();
    } else if (jj_2_42(2)) {
      desc = All();
    } else if (jj_2_43(2)) {
      desc = Some();
    } else if (jj_2_44(2)) {
      desc = AtLeast();
    } else if (jj_2_45(2)) {
      desc = AtMost();
    } else if (jj_2_46(2)) {
      desc = Exactly();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return desc;}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription ConceptName() throws ParseException, KRSS2OWLParserException {
    URI uri;
    uri = Name();
        {if (true) return dataFactory.getOWLClass(uri);}
    throw new Error("Missing return statement in function");
  }

  final public Set<OWLDescription> ConceptSet() throws ParseException, KRSS2OWLParserException {
    Set<OWLDescription> descs = new HashSet<OWLDescription>();
    OWLDescription desc;
    label_5:
    while (true) {
      desc = ConceptExpression();
                                descs.add(desc);
      if (jj_2_47(2)) {
        ;
      } else {
        break label_5;
      }
    }
        {if (true) return descs;}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription And() throws ParseException, KRSS2OWLParserException {
    Set<OWLDescription> operands;
    jj_consume_token(OPENPAR);
    jj_consume_token(AND);
    operands = ConceptSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectIntersectionOf(operands);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription Or() throws ParseException, KRSS2OWLParserException {
    Set<OWLDescription> operands;
    jj_consume_token(OPENPAR);
    jj_consume_token(OR);
    operands = ConceptSet();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectUnionOf(operands);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription Not() throws ParseException, KRSS2OWLParserException {
    OWLDescription operand;
    jj_consume_token(OPENPAR);
    jj_consume_token(NOT);
    operand = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectComplementOf(operand);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription All() throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty prop;
    OWLDescription filler;
    jj_consume_token(OPENPAR);
    jj_consume_token(ALL);
    prop = RoleName();
    filler = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectAllRestriction(prop, filler);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription Some() throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty prop;
    OWLDescription filler;
    jj_consume_token(OPENPAR);
    jj_consume_token(SOME);
    prop = RoleName();
    filler = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectSomeRestriction(prop, filler);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription AtLeast() throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty prop;
    OWLDescription filler;
    int card;
    jj_consume_token(OPENPAR);
    jj_consume_token(ATLEAST);
    card = Integer();
    prop = RoleName();
    filler = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectMinCardinalityRestriction(prop, card, filler);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription AtMost() throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty prop;
    OWLDescription filler;
    int card;
    jj_consume_token(OPENPAR);
    jj_consume_token(ATMOST);
    card = Integer();
    prop = RoleName();
    filler = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectMaxCardinalityRestriction(prop, card, filler);}
    throw new Error("Missing return statement in function");
  }

  final public OWLDescription Exactly() throws ParseException, KRSS2OWLParserException {
    OWLObjectProperty prop;
    OWLDescription filler;
    int card;
    jj_consume_token(OPENPAR);
    jj_consume_token(EXACTLY);
    card = Integer();
    prop = RoleName();
    filler = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        {if (true) return dataFactory.getOWLObjectExactCardinalityRestriction(prop, card, filler);}
    throw new Error("Missing return statement in function");
  }

  final public OWLObjectProperty RoleName() throws ParseException, KRSS2OWLParserException {
    URI uri;
    uri = Name();
            if (uri == null) {if (true) return null;}
        {if (true) return dataFactory.getOWLObjectProperty(uri);}
    throw new Error("Missing return statement in function");
  }

  final public Set<OWLObjectProperty> RoleNameSet() throws ParseException, KRSS2OWLParserException {
    Set<OWLObjectProperty> roles = new HashSet<OWLObjectProperty>();
    OWLObjectProperty role;
    label_6:
    while (true) {
      role = RoleName();
                       roles.add(role);
      if (jj_2_48(2)) {
        ;
      } else {
        break label_6;
      }
    }
        {if (true) return roles;}
    throw new Error("Missing return statement in function");
  }

  final public void ABoxStatement() throws ParseException, KRSS2OWLParserException {
    if (jj_2_49(2)) {
      Instance();
    } else if (jj_2_50(2)) {
      Related();
    } else if (jj_2_51(2)) {
      Equal();
    } else if (jj_2_52(2)) {
      Distinct();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Instance() throws ParseException, KRSS2OWLParserException {
    OWLIndividual ind;
    OWLDescription type;
    jj_consume_token(OPENPAR);
    jj_consume_token(INSTANCE);
    ind = IndividualName();
    type = ConceptExpression();
    jj_consume_token(CLOSEPAR);
        addAxiom( dataFactory.getOWLClassAssertionAxiom(ind, type));
  }

  final public void Related() throws ParseException, KRSS2OWLParserException {
    OWLIndividual subj;
    OWLObjectProperty prop;
    OWLIndividual obj;
    jj_consume_token(OPENPAR);
    jj_consume_token(RELATED);
    subj = IndividualName();
    prop = RoleName();
    obj = IndividualName();
    jj_consume_token(CLOSEPAR);
        addAxiom( dataFactory.getOWLObjectPropertyAssertionAxiom(subj, prop, obj));
  }

  final public void Equal() throws ParseException, KRSS2OWLParserException {
    OWLIndividual indA, indB;
    Set<OWLIndividual> inds = new HashSet<OWLIndividual>();
    jj_consume_token(OPENPAR);
    jj_consume_token(EQUAL);
    indA = IndividualName();
    indB = IndividualName();
    jj_consume_token(CLOSEPAR);
        inds.add(indA);
        inds.add(indB);
        addAxiom( dataFactory.getOWLSameIndividualsAxiom(inds));
  }

  final public void Distinct() throws ParseException, KRSS2OWLParserException {
    OWLIndividual indA, indB;
    Set<OWLIndividual> inds = new HashSet<OWLIndividual>();
    jj_consume_token(OPENPAR);
    jj_consume_token(DISTINCT);
    indA = IndividualName();
    indB = IndividualName();
    jj_consume_token(CLOSEPAR);
        inds.add(indA);
        inds.add(indB);
        addAxiom( dataFactory.getOWLDifferentIndividualsAxiom(inds));
  }

  final public OWLIndividual IndividualName() throws ParseException, KRSS2OWLParserException {
    URI name;
    name = Name();
        {if (true) return  dataFactory.getOWLIndividual(name);}
    throw new Error("Missing return statement in function");
  }

  final public int Integer() throws ParseException, KRSS2OWLParserException {
    Token t;
    t = jj_consume_token(INT);
        {if (true) return Integer.parseInt(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public boolean parseBoolean() throws ParseException {
    if (jj_2_53(2)) {
      jj_consume_token(TRUE);
            {if (true) return true;}
    } else if (jj_2_54(2)) {
      jj_consume_token(NIL);
                                   {if (true) return false;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }

    throw new Error("Missing return statement in function");
  }

  final public URI Name() throws ParseException {
    Token t;
    if (jj_2_59(2)) {
      if (jj_2_55(2)) {
        t = jj_consume_token(NAME);
      } else if (jj_2_56(2)) {
        t = jj_consume_token(INT);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
        try {
            {if (true) return getURI(t.image);}
        }
        catch(URISyntaxException e) {
            {if (true) return null;}
        }
    } else if (jj_2_60(2)) {
      if (jj_2_57(2)) {
        t = jj_consume_token(TOP);
          {if (true) return OWLRDFVocabulary.OWL_THING.getURI();}
      } else if (jj_2_58(2)) {
        t = jj_consume_token(BOTTOM);
         {if (true) return OWLRDFVocabulary.OWL_NOTHING.getURI();}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(AND)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_scan_token(DOMAIN_ATTRIBUTE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) return true;
    }
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_3R_32()) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_scan_token(INVERSE_ATTRIBUTE)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3_46()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_scan_token(LEFT_IDENTITY_ATTRIBUTE)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_31()) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_12()) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_scan_token(RIGHT_IDENTITY_ATTRIBUTE)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(RANGE)) return true;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_3R_30()) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(RELATED)) return true;
    return false;
  }

  final private boolean jj_3R_12() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(TRANSITIVE)) return true;
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(DEFINEPRIMITIVEROLE)) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_29()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(INSTANCE)) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(ENDABOX)) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(IMPLIES)) return true;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_3R_28()) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3R_8() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3_51()) {
    jj_scanpos = xsp;
    if (jj_3_52()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3R_10() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(DEFINECONCEPT)) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(ROLE_INCLUSION)) return true;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    Token xsp;
    if (jj_3_48()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_48()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(PARENT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3_33()) return true;
    }
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3R_9() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(DEFINEPRIMITIVECONCEPT)) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(ENDTBOX)) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_3R_32()) return true;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_9()) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(EXACTLY)) return true;
    return false;
  }

  final private boolean jj_3R_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_7()) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(ATMOST)) return true;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(PARENTS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3_31()) return true;
    }
    return false;
  }

  final private boolean jj_3_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) return true;
    }
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(ATLEAST)) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(SOME)) return true;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_scan_token(SYMMETRIC_ATTRIBUTE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) return true;
    }
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_scan_token(OPENPAR)) return true;
    Token xsp;
    if (jj_3_20()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_20()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_scan_token(BOTTOM)) return true;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_scan_token(TOP)) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_scan_token(TRANSITIVE_ATTRIBUTE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3_25()) return true;
    }
    return false;
  }

  final private boolean jj_3_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3_58()) return true;
    }
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) return true;
    }
    return false;
  }

  final private boolean jj_3R_32() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) return true;
    }
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_scan_token(OR)) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_scan_token(OPENPAR)) return true;
    Token xsp;
    if (jj_3_16()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_16()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_scan_token(RANGE_ATTRIBUTE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) return true;
    }
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  public KRSS2ParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[60];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public KRSS2Parser(java.io.InputStream stream) {
     this(stream, null);
  }
  public KRSS2Parser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new KRSS2ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public KRSS2Parser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new KRSS2ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public KRSS2Parser(KRSS2ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(KRSS2ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[61];
    for (int i = 0; i < 61; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 61; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 60; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
