package org.coode.owl.rdfxml.parser;

import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

import java.net.URI;

/**
 * @author Mike Smith
 * 
 */
public class TPPropertyDisjointWithHandler extends TriplePredicateHandler {

    public TPPropertyDisjointWithHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getURI());
    }

    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        final OWLRDFConsumer consumer = getConsumer();
        return ((consumer.isObjectPropertyOnly(subject) && consumer.isObjectPropertyOnly(object)) || (consumer.isDataPropertyOnly(subject) && consumer.isDataPropertyOnly(object)));
    }

    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        final OWLRDFConsumer consumer = getConsumer();
        if (consumer.isObjectPropertyOnly(subject)) {
            if (consumer.isDataPropertyOnly(object)) {
                throw new OWLRDFParserException(
                                                "owl:disjointPropertyWith triple with object property subject and data property object");
            }
            else {
                translateDisjointObjectProperties(subject, predicate, object);
            }
        }
        else if (consumer.isDataPropertyOnly(subject)) {
            if (consumer.isObjectPropertyOnly(object)) {
                throw new OWLRDFParserException(
                                                "owl:disjointPropertyWith triple with data property subject and object property object");
            }
            else {
                translateDisjointDataProperties(subject, predicate, object);
            }
        }
        else if (consumer.isObjectPropertyOnly(object)) {
            translateDisjointObjectProperties(subject, predicate, object);
        }
        else if (consumer.isDataPropertyOnly(object)) {
            translateDisjointDataProperties(subject, predicate, object);
        }
        else {
            // No clear typing add two axioms
            translateDisjointDataProperties(subject, predicate, object);
            translateDisjointObjectProperties(subject, predicate, object);
        }
    }

    private void translateDisjointDataProperties(URI subject, URI predicate, URI object) throws OWLException {
        addAxiom(getDataFactory().getOWLDisjointDataPropertiesAxiom(translateDataProperty(subject),
                                                                    translateDataProperty(object)));
        consumeTriple(subject, predicate, object);
    }

    private void translateDisjointObjectProperties(URI subject, URI predicate, URI object) throws OWLException {
        addAxiom(getDataFactory().getOWLDisjointObjectPropertiesAxiom(translateObjectProperty(subject),
                                                                      translateObjectProperty(object)));
        consumeTriple(subject, predicate, object);
    }

}
